/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class NodeConnectionsService
extends AbstractLifecycleComponent {
    public static final Setting<TimeValue> CLUSTER_NODE_RECONNECT_INTERVAL_SETTING = Setting.positiveTimeSetting("cluster.nodes.reconnect_interval", TimeValue.timeValueSeconds(10L), Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private ConcurrentMap<DiscoveryNode, Integer> nodes = ConcurrentCollections.newConcurrentMap();
    private final KeyedLock<DiscoveryNode> nodeLocks = new KeyedLock();
    private final TimeValue reconnectInterval;
    private volatile ScheduledFuture<?> backgroundFuture = null;

    @Inject
    public NodeConnectionsService(Settings settings, ThreadPool threadPool, TransportService transportService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.reconnectInterval = CLUSTER_NODE_RECONNECT_INTERVAL_SETTING.get(settings);
    }

    public void connectToNodes(Iterable<DiscoveryNode> discoveryNodes) {
        for (DiscoveryNode node : discoveryNodes) {
            Releasable ignored = this.nodeLocks.acquire(node);
            Throwable throwable = null;
            try {
                this.nodes.putIfAbsent(node, 0);
                this.validateNodeConnected(node);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
    }

    public void disconnectFromNodesExcept(Iterable<DiscoveryNode> nodesToKeep) {
        HashSet currentNodes = new HashSet(this.nodes.keySet());
        for (DiscoveryNode node : nodesToKeep) {
            currentNodes.remove(node);
        }
        for (DiscoveryNode node : currentNodes) {
            Releasable ignored = this.nodeLocks.acquire(node);
            Throwable throwable = null;
            try {
                Integer current = (Integer)this.nodes.remove(node);
                assert (current != null) : "node " + node + " was removed in event but not in internal nodes";
                try {
                    this.transportService.disconnectFromNode(node);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to disconnect to node [{}]", (Object)node), (Throwable)e);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
    }

    void validateNodeConnected(DiscoveryNode node) {
        assert (this.nodeLocks.isHeldByCurrentThread(node)) : "validateNodeConnected must be called under lock";
        if (!this.lifecycle.stoppedOrClosed() && this.nodes.containsKey(node)) {
            try {
                this.transportService.connectToNode(node);
                this.nodes.put(node, 0);
            }
            catch (Exception e) {
                Integer nodeFailureCount = (Integer)this.nodes.get(node);
                assert (nodeFailureCount != null) : node + " didn't have a counter in nodes map";
                if ((nodeFailureCount = Integer.valueOf(nodeFailureCount + 1)) % 6 == 1) {
                    int finalNodeFailureCount = nodeFailureCount;
                    this.logger.warn(() -> new ParameterizedMessage("failed to connect to node {} (tried [{}] times)", (Object)node, (Object)finalNodeFailureCount), (Throwable)e);
                }
                this.nodes.put(node, nodeFailureCount);
            }
        }
    }

    @Override
    protected void doStart() {
        this.backgroundFuture = this.threadPool.schedule(this.reconnectInterval, "generic", new ConnectionChecker());
    }

    @Override
    protected void doStop() {
        FutureUtils.cancel(this.backgroundFuture);
    }

    @Override
    protected void doClose() {
    }

    class ConnectionChecker
    extends AbstractRunnable {
        ConnectionChecker() {
        }

        @Override
        public void onFailure(Exception e) {
            NodeConnectionsService.this.logger.warn("unexpected error while checking for node reconnects", (Throwable)e);
        }

        @Override
        protected void doRun() {
            for (DiscoveryNode node : NodeConnectionsService.this.nodes.keySet()) {
                Releasable ignored = NodeConnectionsService.this.nodeLocks.acquire(node);
                Throwable throwable = null;
                try {
                    NodeConnectionsService.this.validateNodeConnected(node);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }

        @Override
        public void onAfter() {
            if (NodeConnectionsService.this.lifecycle.started()) {
                NodeConnectionsService.this.backgroundFuture = NodeConnectionsService.this.threadPool.schedule(NodeConnectionsService.this.reconnectInterval, "generic", this);
            }
        }
    }
}

