/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.main;

import java.io.IOException;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MainResponse
extends ActionResponse
implements ToXContent {
    private String nodeName;
    private Version version;
    private ClusterName clusterName;
    private String clusterUuid;
    private Build build;
    private boolean available;

    MainResponse() {
    }

    public MainResponse(String nodeName, Version version, ClusterName clusterName, String clusterUuid, Build build, boolean available) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.available = available;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Version getVersion() {
        return this.version;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.nodeName);
        Version.writeVersion(this.version, out);
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUuid);
        Build.writeBuild(this.build, out);
        out.writeBoolean(this.available);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodeName = in.readString();
        this.version = Version.readVersion(in);
        this.clusterName = new ClusterName(in);
        this.clusterUuid = in.readString();
        this.build = Build.readBuild(in);
        this.available = in.readBoolean();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version").field("number", this.version.toString()).field("build_hash", this.build.shortHash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.version.luceneVersion.toString()).endObject();
        builder.field("tagline", "You Know, for Search");
        builder.endObject();
        return builder;
    }
}

