/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.painless.Augmentation;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.WriterConstants;

public final class Definition {
    private static final List<String> DEFINITION_FILES = Collections.unmodifiableList(Arrays.asList("org.elasticsearch.txt", "java.lang.txt", "java.math.txt", "java.text.txt", "java.time.txt", "java.time.chrono.txt", "java.time.format.txt", "java.time.temporal.txt", "java.time.zone.txt", "java.util.txt", "java.util.function.txt", "java.util.regex.txt", "java.util.stream.txt", "joda.time.txt"));
    private static final Definition INSTANCE = new Definition();
    public static final Type VOID_TYPE = Definition.getType("void");
    public static final Type BOOLEAN_TYPE = Definition.getType("boolean");
    public static final Type BOOLEAN_OBJ_TYPE = Definition.getType("Boolean");
    public static final Type BYTE_TYPE = Definition.getType("byte");
    public static final Type BYTE_OBJ_TYPE = Definition.getType("Byte");
    public static final Type SHORT_TYPE = Definition.getType("short");
    public static final Type SHORT_OBJ_TYPE = Definition.getType("Short");
    public static final Type INT_TYPE = Definition.getType("int");
    public static final Type INT_OBJ_TYPE = Definition.getType("Integer");
    public static final Type LONG_TYPE = Definition.getType("long");
    public static final Type LONG_OBJ_TYPE = Definition.getType("Long");
    public static final Type FLOAT_TYPE = Definition.getType("float");
    public static final Type FLOAT_OBJ_TYPE = Definition.getType("Float");
    public static final Type DOUBLE_TYPE = Definition.getType("double");
    public static final Type DOUBLE_OBJ_TYPE = Definition.getType("Double");
    public static final Type CHAR_TYPE = Definition.getType("char");
    public static final Type CHAR_OBJ_TYPE = Definition.getType("Character");
    public static final Type OBJECT_TYPE = Definition.getType("Object");
    public static final Type DEF_TYPE = Definition.getType("def");
    public static final Type STRING_TYPE = Definition.getType("String");
    public static final Type EXCEPTION_TYPE = Definition.getType("Exception");
    public static final Type PATTERN_TYPE = Definition.getType("Pattern");
    public static final Type MATCHER_TYPE = Definition.getType("Matcher");
    private final Map<Class<?>, RuntimeClass> runtimeMap;
    private final Map<String, Struct> structsMap = new HashMap<String, Struct>();
    private final Map<String, Type> simpleTypesMap = new HashMap<String, Type>();

    public static boolean isSimpleType(String name) {
        return Definition.INSTANCE.structsMap.containsKey(name);
    }

    public static boolean isType(String name) {
        try {
            INSTANCE.getTypeInternal(name);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static Type getType(String name) {
        return INSTANCE.getTypeInternal(name);
    }

    public static Type getType(Struct struct, int dimensions) {
        return INSTANCE.getTypeInternal(struct, dimensions);
    }

    public static RuntimeClass getRuntimeClass(Class<?> clazz) {
        return Definition.INSTANCE.runtimeMap.get(clazz);
    }

    private Definition() {
        this.runtimeMap = new HashMap();
        Map<String, List<String>> hierarchy = this.addStructs();
        this.addElements();
        for (Map.Entry<String, List<String>> entry : hierarchy.entrySet()) {
            this.copyStruct(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.structsMap.entrySet()) {
            String name = entry.getKey();
            Class<?> javaPeer = ((Struct)entry.getValue()).clazz;
            if (javaPeer.isInterface()) {
                this.copyStruct(name, Collections.singletonList("Object"));
                continue;
            }
            if (name.equals("def") || name.equals("Object") || javaPeer.isPrimitive()) continue;
            assert (hierarchy.get(name) != null) : "class '" + name + "' does not extend Object!";
            assert (hierarchy.get(name).contains("Object")) : "class '" + name + "' does not extend Object!";
        }
        for (Struct struct : this.structsMap.values()) {
            struct.functionalMethod.set((Object)this.computeFunctionalInterfaceMethod(struct));
        }
        for (Struct struct : this.structsMap.values()) {
            this.addRuntimeClass(struct);
        }
        for (Map.Entry entry : this.structsMap.entrySet()) {
            entry.setValue(((Struct)entry.getValue()).freeze());
        }
    }

    private Map<String, List<String>> addStructs() {
        HashMap<String, List<String>> hierarchy = new HashMap<String, List<String>>();
        for (String file : DEFINITION_FILES) {
            int currentLine = -1;
            try {
                InputStream stream = Definition.class.getResourceAsStream(file);
                Throwable throwable = null;
                try {
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            Class<Object> javaClazz;
                            String javaPeer;
                            currentLine = reader.getLineNumber();
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || !line.startsWith("class ")) continue;
                            CharSequence[] elements = line.split(" ");
                            assert (elements[2].equals("->")) : "Invalid struct definition [" + String.join((CharSequence)" ", elements) + "]";
                            if (elements.length == 7) {
                                hierarchy.put(elements[1], Arrays.asList(elements[5].split(",")));
                            } else assert (elements.length == 5) : "Invalid struct definition [" + String.join((CharSequence)" ", elements) + "]";
                            String className = elements[1];
                            switch (javaPeer = elements[3]) {
                                case "void": {
                                    javaClazz = Void.TYPE;
                                    break;
                                }
                                case "boolean": {
                                    javaClazz = Boolean.TYPE;
                                    break;
                                }
                                case "byte": {
                                    javaClazz = Byte.TYPE;
                                    break;
                                }
                                case "short": {
                                    javaClazz = Short.TYPE;
                                    break;
                                }
                                case "char": {
                                    javaClazz = Character.TYPE;
                                    break;
                                }
                                case "int": {
                                    javaClazz = Integer.TYPE;
                                    break;
                                }
                                case "long": {
                                    javaClazz = Long.TYPE;
                                    break;
                                }
                                case "float": {
                                    javaClazz = Float.TYPE;
                                    break;
                                }
                                case "double": {
                                    javaClazz = Double.TYPE;
                                    break;
                                }
                                default: {
                                    javaClazz = Class.forName(javaPeer);
                                }
                            }
                            this.addStruct(className, javaClazz);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error in " + file + ", line: " + currentLine, e);
            }
        }
        return hierarchy;
    }

    private void addElements() {
        for (String file : DEFINITION_FILES) {
            int currentLine = -1;
            try {
                InputStream stream = Definition.class.getResourceAsStream(file);
                Throwable throwable = null;
                try {
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        String line = null;
                        String currentClass = null;
                        while ((line = reader.readLine()) != null) {
                            currentLine = reader.getLineNumber();
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                            if (line.startsWith("class ")) {
                                assert (currentClass == null);
                                currentClass = line.split(" ")[1];
                                continue;
                            }
                            if (line.equals("}")) {
                                assert (currentClass != null);
                                currentClass = null;
                                continue;
                            }
                            assert (currentClass != null);
                            this.addSignature(currentClass, line);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("syntax error in " + file + ", line: " + currentLine, e);
            }
        }
    }

    private void addStruct(String name, Class<?> clazz) {
        if (!name.matches("^[_a-zA-Z][\\.,_a-zA-Z0-9]*$")) {
            throw new IllegalArgumentException("Invalid struct name [" + name + "].");
        }
        if (this.structsMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate struct name [" + name + "].");
        }
        Struct struct = new Struct(name, clazz, org.objectweb.asm.Type.getType(clazz));
        this.structsMap.put(name, struct);
        this.simpleTypesMap.put(name, this.getTypeInternal(name));
    }

    private void addConstructorInternal(String struct, String name, Type[] args) {
        MethodHandle handle;
        Constructor<?> reflect;
        Struct owner = this.structsMap.get(struct);
        if (owner == null) {
            throw new IllegalArgumentException("Owner struct [" + struct + "] not defined for constructor [" + name + "].");
        }
        if (!name.matches("<init>")) {
            throw new IllegalArgumentException("Invalid constructor name [" + name + "] with the struct [" + owner.name + "].");
        }
        MethodKey methodKey = new MethodKey(name, args.length);
        if (owner.constructors.containsKey(methodKey)) {
            throw new IllegalArgumentException("Duplicate constructor [" + methodKey + "] found within the struct [" + owner.name + "].");
        }
        if (owner.staticMethods.containsKey(methodKey)) {
            throw new IllegalArgumentException("Constructors and static methods may not have the same signature [" + methodKey + "] within the same struct [" + owner.name + "].");
        }
        if (owner.methods.containsKey(methodKey)) {
            throw new IllegalArgumentException("Constructors and methods may not have the same signature [" + methodKey + "] within the same struct [" + owner.name + "].");
        }
        Object[] classes = new Class[args.length];
        for (int count = 0; count < classes.length; ++count) {
            classes[count] = args[count].clazz;
        }
        try {
            reflect = owner.clazz.getConstructor((Class<?>[])classes);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Constructor [" + name + "] not found for class [" + owner.clazz.getName() + "] with arguments " + Arrays.toString(classes) + ".");
        }
        org.objectweb.asm.commons.Method asm = org.objectweb.asm.commons.Method.getMethod(reflect);
        Type returnType = this.getTypeInternal("void");
        try {
            handle = MethodHandles.publicLookup().in(owner.clazz).unreflectConstructor(reflect);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException("Constructor  not found for class [" + owner.clazz.getName() + "] with arguments " + Arrays.toString(classes) + ".");
        }
        Method constructor = new Method(name, owner, false, returnType, Arrays.asList(args), asm, reflect.getModifiers(), handle);
        owner.constructors.put(methodKey, constructor);
    }

    private void addSignature(String className, String signature) {
        String[] elements = signature.split(" ");
        if (elements.length != 2) {
            throw new IllegalArgumentException("Malformed signature: " + signature);
        }
        Type rtn = this.getTypeInternal(elements[0]);
        int parenIndex = elements[1].indexOf(40);
        if (parenIndex != -1) {
            String methodName;
            Type[] args;
            int parenEnd = elements[1].indexOf(41);
            if (parenEnd > parenIndex + 1) {
                String[] arguments = elements[1].substring(parenIndex + 1, parenEnd).split(",");
                args = new Type[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    args[i] = this.getTypeInternal(arguments[i]);
                }
            } else {
                args = new Type[]{};
            }
            if ((methodName = elements[1].substring(0, parenIndex)).equals("<init>")) {
                if (!elements[0].equals(className)) {
                    throw new IllegalArgumentException("Constructors must return their own type");
                }
                this.addConstructorInternal(className, "<init>", args);
            } else if (methodName.indexOf("*") >= 0) {
                this.addMethodInternal(className, methodName.substring(0, methodName.length() - 1), true, rtn, args);
            } else {
                this.addMethodInternal(className, methodName, false, rtn, args);
            }
        } else {
            this.addFieldInternal(className, elements[1], rtn);
        }
    }

    private void addMethodInternal(String struct, String name, boolean augmentation, Type rtn, Type[] args) {
        MethodHandle handle;
        java.lang.reflect.Method reflect;
        int count;
        Object[] params;
        Class implClass;
        Struct owner = this.structsMap.get(struct);
        if (owner == null) {
            throw new IllegalArgumentException("Owner struct [" + struct + "] not defined for method [" + name + "].");
        }
        if (!name.matches("^[_a-zA-Z][_a-zA-Z0-9]*$")) {
            throw new IllegalArgumentException("Invalid method name [" + name + "] with the struct [" + owner.name + "].");
        }
        MethodKey methodKey = new MethodKey(name, args.length);
        if (owner.constructors.containsKey(methodKey)) {
            throw new IllegalArgumentException("Constructors and methods may not have the same signature [" + methodKey + "] within the same struct [" + owner.name + "].");
        }
        if (owner.staticMethods.containsKey(methodKey) || owner.methods.containsKey(methodKey)) {
            throw new IllegalArgumentException("Duplicate method signature [" + methodKey + "] found within the struct [" + owner.name + "].");
        }
        if (!augmentation) {
            implClass = owner.clazz;
            params = new Class[args.length];
            for (count = 0; count < args.length; ++count) {
                params[count] = args[count].clazz;
            }
        } else {
            implClass = Augmentation.class;
            params = new Class[args.length + 1];
            params[0] = owner.clazz;
            for (count = 0; count < args.length; ++count) {
                params[count + 1] = args[count].clazz;
            }
        }
        try {
            reflect = implClass.getMethod(name, (Class<?>[])params);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Method [" + name + "] not found for class [" + implClass.getName() + "] with arguments " + Arrays.toString(params) + ".");
        }
        if (!reflect.getReturnType().equals(rtn.clazz)) {
            throw new IllegalArgumentException("Specified return type class [" + rtn.clazz + "] does not match the found return type class [" + reflect.getReturnType() + "] for the method [" + name + "] within the struct [" + owner.name + "].");
        }
        org.objectweb.asm.commons.Method asm = org.objectweb.asm.commons.Method.getMethod((java.lang.reflect.Method)reflect);
        try {
            handle = MethodHandles.publicLookup().in(implClass).unreflect(reflect);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException("Method [" + name + "] not found for class [" + implClass.getName() + "] with arguments " + Arrays.toString(params) + ".");
        }
        int modifiers = reflect.getModifiers();
        Method method = new Method(name, owner, augmentation, rtn, Arrays.asList(args), asm, modifiers, handle);
        if (!augmentation && Modifier.isStatic(modifiers)) {
            owner.staticMethods.put(methodKey, method);
        } else {
            owner.methods.put(methodKey, method);
        }
    }

    private void addFieldInternal(String struct, String name, Type type) {
        java.lang.reflect.Field reflect;
        Struct owner = this.structsMap.get(struct);
        if (owner == null) {
            throw new IllegalArgumentException("Owner struct [" + struct + "] not defined for  field [" + name + "].");
        }
        if (!name.matches("^[_a-zA-Z][_a-zA-Z0-9]*$")) {
            throw new IllegalArgumentException("Invalid field  name [" + name + "] with the struct [" + owner.name + "].");
        }
        if (owner.staticMembers.containsKey(name) || owner.members.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate field name [" + name + "] found within the struct [" + owner.name + "].");
        }
        try {
            reflect = owner.clazz.getField(name);
        }
        catch (NoSuchFieldException exception) {
            throw new IllegalArgumentException("Field [" + name + "] not found for class [" + owner.clazz.getName() + "].");
        }
        int modifiers = reflect.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        MethodHandle getter = null;
        MethodHandle setter = null;
        try {
            if (!isStatic) {
                getter = MethodHandles.publicLookup().unreflectGetter(reflect);
                setter = MethodHandles.publicLookup().unreflectSetter(reflect);
            }
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException("Getter/Setter [" + name + "] not found for class [" + owner.clazz.getName() + "].");
        }
        Field field = new Field(name, reflect.getName(), owner, type, modifiers, getter, setter);
        if (isStatic) {
            if (!Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException("Static [" + name + "] within the struct [" + owner.name + "] is not final.");
            }
            owner.staticMembers.put(name, field);
        } else {
            owner.members.put(name, field);
        }
    }

    private void copyStruct(String struct, List<String> children) {
        Struct owner = this.structsMap.get(struct);
        if (owner == null) {
            throw new IllegalArgumentException("Owner struct [" + struct + "] not defined for copy.");
        }
        for (int count = 0; count < children.size(); ++count) {
            Struct child = this.structsMap.get(children.get(count));
            if (child == null) {
                throw new IllegalArgumentException("Child struct [" + children.get(count) + "] not defined for copy to owner struct [" + owner.name + "].");
            }
            if (!child.clazz.isAssignableFrom(owner.clazz)) {
                throw new ClassCastException("Child struct [" + child.name + "] is not a super type of owner struct [" + owner.name + "] in copy.");
            }
            for (Map.Entry<MethodKey, Method> kvPair : child.methods.entrySet()) {
                MethodKey methodKey = kvPair.getKey();
                Method method = kvPair.getValue();
                if (owner.methods.get(methodKey) != null) continue;
                if (!(owner.clazz.isInterface() && child.clazz == Object.class || child.clazz == Spliterator.OfPrimitive.class || child.clazz == PrimitiveIterator.class || Constants.JRE_IS_MINIMUM_JAVA9 && owner.clazz == LocalDate.class)) {
                    try {
                        java.lang.reflect.Method source;
                        java.lang.reflect.Method m;
                        int i;
                        Class[] arguments;
                        Class impl;
                        if (method.augmentation) {
                            impl = Augmentation.class;
                            arguments = new Class[method.arguments.size() + 1];
                            arguments[0] = method.owner.clazz;
                            for (i = 0; i < method.arguments.size(); ++i) {
                                arguments[i + 1] = method.arguments.get((int)i).clazz;
                            }
                        } else {
                            impl = owner.clazz;
                            arguments = new Class[method.arguments.size()];
                            for (i = 0; i < method.arguments.size(); ++i) {
                                arguments[i] = method.arguments.get((int)i).clazz;
                            }
                        }
                        if ((m = impl.getMethod(method.method.getName(), arguments)).getReturnType() != method.rtn.clazz) {
                            throw new IllegalStateException("missing covariant override for: " + m + " in " + owner.name);
                        }
                        if (m.isBridge() && !Modifier.isVolatile(method.modifiers) && !Arrays.equals((source = child.clazz.getMethod(method.method.getName(), arguments)).getGenericParameterTypes(), source.getParameterTypes())) {
                            throw new IllegalStateException("missing generic override for: " + m + " in " + owner.name);
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                owner.methods.put(methodKey, method);
            }
            for (Field field : child.members.values()) {
                if (owner.members.get(field.name) != null) continue;
                owner.members.put(field.name, new Field(field.name, field.javaName, owner, field.type, field.modifiers, field.getter, field.setter));
            }
        }
    }

    private void addRuntimeClass(Struct struct) {
        Map<MethodKey, Method> methods = struct.methods;
        HashMap<String, MethodHandle> getters = new HashMap<String, MethodHandle>();
        HashMap<String, MethodHandle> setters = new HashMap<String, MethodHandle>();
        for (Map.Entry<String, Field> entry : struct.members.entrySet()) {
            getters.put(entry.getKey(), entry.getValue().getter);
            setters.put(entry.getKey(), entry.getValue().setter);
        }
        for (Map.Entry<Object, Object> entry : methods.entrySet()) {
            StringBuilder newName;
            String name = ((MethodKey)entry.getKey()).name;
            Method m = (Method)entry.getValue();
            if (m.arguments.size() == 0 && name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                newName = new StringBuilder();
                newName.append(Character.toLowerCase(name.charAt(3)));
                newName.append(name.substring(4));
                getters.putIfAbsent(newName.toString(), m.handle);
            } else if (m.arguments.size() == 0 && name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                newName = new StringBuilder();
                newName.append(Character.toLowerCase(name.charAt(2)));
                newName.append(name.substring(3));
                getters.putIfAbsent(newName.toString(), m.handle);
            }
            if (m.arguments.size() != 1 || !name.startsWith("set") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3))) continue;
            newName = new StringBuilder();
            newName.append(Character.toLowerCase(name.charAt(3)));
            newName.append(name.substring(4));
            setters.putIfAbsent(newName.toString(), m.handle);
        }
        this.runtimeMap.put(struct.clazz, new RuntimeClass(methods, getters, setters));
    }

    private Method computeFunctionalInterfaceMethod(Struct clazz) {
        if (!clazz.clazz.isInterface()) {
            return null;
        }
        boolean hasAnnotation = clazz.clazz.isAnnotationPresent(FunctionalInterface.class);
        ArrayList<java.lang.reflect.Method> methods = new ArrayList<java.lang.reflect.Method>();
        for (java.lang.reflect.Method m : clazz.clazz.getMethods()) {
            if (m.isDefault() || Modifier.isStatic(m.getModifiers())) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                methods.add(m);
            }
        }
        if (methods.size() != 1) {
            if (hasAnnotation) {
                throw new IllegalArgumentException("Class: " + clazz.name + " is marked with FunctionalInterface but doesn't fit the bill: " + methods);
            }
            return null;
        }
        java.lang.reflect.Method oneMethod = (java.lang.reflect.Method)methods.get(0);
        Method painless = clazz.methods.get(new MethodKey(oneMethod.getName(), oneMethod.getParameterCount()));
        if (painless == null || !painless.method.equals((Object)org.objectweb.asm.commons.Method.getMethod((java.lang.reflect.Method)oneMethod))) {
            throw new IllegalArgumentException("Class: " + clazz.name + " is functional but the functional method is not whitelisted!");
        }
        return painless;
    }

    private Type getTypeInternal(String name) {
        Type simple = this.simpleTypesMap.get(name);
        if (simple != null) {
            return simple;
        }
        int dimensions = this.getDimensions(name);
        String structstr = dimensions == 0 ? name : name.substring(0, name.indexOf(91));
        Struct struct = this.structsMap.get(structstr);
        if (struct == null) {
            throw new IllegalArgumentException("The struct with name [" + name + "] has not been defined.");
        }
        return this.getTypeInternal(struct, dimensions);
    }

    private Type getTypeInternal(Struct struct, int dimensions) {
        Sort sort;
        String name = struct.name;
        org.objectweb.asm.Type type = struct.type;
        Class<?> clazz = struct.clazz;
        if (dimensions > 0) {
            StringBuilder builder = new StringBuilder(name);
            char[] brackets = new char[dimensions];
            for (int count = 0; count < dimensions; ++count) {
                builder.append("[]");
                brackets[count] = 91;
            }
            String descriptor = new String(brackets) + struct.type.getDescriptor();
            name = builder.toString();
            type = org.objectweb.asm.Type.getType((String)descriptor);
            try {
                clazz = Class.forName(type.getInternalName().replace('/', '.'));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("The class [" + type.getInternalName() + "] could not be found to create type [" + name + "].");
            }
            sort = Sort.ARRAY;
        } else if ("def".equals(struct.name)) {
            sort = Sort.DEF;
        } else {
            sort = Sort.OBJECT;
            for (Sort value : Sort.values()) {
                if (value.clazz == null || !value.clazz.equals(struct.clazz)) continue;
                sort = value;
                break;
            }
        }
        return new Type(name, dimensions, struct, clazz, type, sort);
    }

    private int getDimensions(String name) {
        int dimensions = 0;
        int index = name.indexOf(91);
        if (index != -1) {
            int length = name.length();
            while (index < length) {
                if (name.charAt(index) == '[' && ++index < length && name.charAt(index++) == ']') {
                    ++dimensions;
                    continue;
                }
                throw new IllegalArgumentException("Invalid array braces in canonical name [" + name + "].");
            }
        }
        return dimensions;
    }

    public static final class RuntimeClass {
        public final Map<MethodKey, Method> methods;
        public final Map<String, MethodHandle> getters;
        public final Map<String, MethodHandle> setters;

        private RuntimeClass(Map<MethodKey, Method> methods, Map<String, MethodHandle> getters, Map<String, MethodHandle> setters) {
            this.methods = Collections.unmodifiableMap(methods);
            this.getters = Collections.unmodifiableMap(getters);
            this.setters = Collections.unmodifiableMap(setters);
        }
    }

    public static class Cast {
        public final Type from;
        public final Type to;
        public final boolean explicit;
        public final boolean unboxFrom;
        public final boolean unboxTo;
        public final boolean boxFrom;
        public final boolean boxTo;

        public Cast(Type from, Type to, boolean explicit) {
            this.from = from;
            this.to = to;
            this.explicit = explicit;
            this.unboxFrom = false;
            this.unboxTo = false;
            this.boxFrom = false;
            this.boxTo = false;
        }

        public Cast(Type from, Type to, boolean explicit, boolean unboxFrom, boolean unboxTo, boolean boxFrom, boolean boxTo) {
            this.from = from;
            this.to = to;
            this.explicit = explicit;
            this.unboxFrom = unboxFrom;
            this.unboxTo = unboxTo;
            this.boxFrom = boxFrom;
            this.boxTo = boxTo;
        }
    }

    public static final class Struct {
        public final String name;
        public final Class<?> clazz;
        public final org.objectweb.asm.Type type;
        public final Map<MethodKey, Method> constructors;
        public final Map<MethodKey, Method> staticMethods;
        public final Map<MethodKey, Method> methods;
        public final Map<String, Field> staticMembers;
        public final Map<String, Field> members;
        private final SetOnce<Method> functionalMethod;

        private Struct(String name, Class<?> clazz, org.objectweb.asm.Type type) {
            this.name = name;
            this.clazz = clazz;
            this.type = type;
            this.constructors = new HashMap<MethodKey, Method>();
            this.staticMethods = new HashMap<MethodKey, Method>();
            this.methods = new HashMap<MethodKey, Method>();
            this.staticMembers = new HashMap<String, Field>();
            this.members = new HashMap<String, Field>();
            this.functionalMethod = new SetOnce();
        }

        private Struct(Struct struct) {
            this.name = struct.name;
            this.clazz = struct.clazz;
            this.type = struct.type;
            this.constructors = Collections.unmodifiableMap(struct.constructors);
            this.staticMethods = Collections.unmodifiableMap(struct.staticMethods);
            this.methods = Collections.unmodifiableMap(struct.methods);
            this.staticMembers = Collections.unmodifiableMap(struct.staticMembers);
            this.members = Collections.unmodifiableMap(struct.members);
            this.functionalMethod = struct.functionalMethod;
        }

        private Struct freeze() {
            return new Struct(this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Struct struct = (Struct)object;
            return this.name.equals(struct.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public Method getFunctionalMethod() {
            return (Method)this.functionalMethod.get();
        }
    }

    public static final class MethodKey {
        public final String name;
        public final int arity;

        public MethodKey(String name, int arity) {
            this.name = Objects.requireNonNull(name);
            this.arity = arity;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.arity;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.arity != other.arity) {
                return false;
            }
            return this.name.equals(other.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append('/');
            sb.append(this.arity);
            return sb.toString();
        }
    }

    public static final class Field {
        public final String name;
        public final Struct owner;
        public final Type type;
        public final String javaName;
        public final int modifiers;
        private final MethodHandle getter;
        private final MethodHandle setter;

        private Field(String name, String javaName, Struct owner, Type type, int modifiers, MethodHandle getter, MethodHandle setter) {
            this.name = name;
            this.javaName = javaName;
            this.owner = owner;
            this.type = type;
            this.modifiers = modifiers;
            this.getter = getter;
            this.setter = setter;
        }
    }

    public static class Method {
        public final String name;
        public final Struct owner;
        public final boolean augmentation;
        public final Type rtn;
        public final List<Type> arguments;
        public final org.objectweb.asm.commons.Method method;
        public final int modifiers;
        public final MethodHandle handle;

        public Method(String name, Struct owner, boolean augmentation, Type rtn, List<Type> arguments, org.objectweb.asm.commons.Method method, int modifiers, MethodHandle handle) {
            this.name = name;
            this.augmentation = augmentation;
            this.owner = owner;
            this.rtn = rtn;
            this.arguments = Collections.unmodifiableList(arguments);
            this.method = method;
            this.modifiers = modifiers;
            this.handle = handle;
        }

        public MethodType getMethodType() {
            Class<?> returnValue;
            Class[] params;
            if (this.handle != null) {
                return this.handle.type();
            }
            if (this.augmentation) {
                params = new Class[1 + this.arguments.size()];
                params[0] = Augmentation.class;
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i + 1] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            } else if (Modifier.isStatic(this.modifiers)) {
                params = new Class[this.arguments.size()];
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            } else if ("<init>".equals(this.name)) {
                params = new Class[this.arguments.size()];
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.owner.clazz;
            } else {
                params = new Class[1 + this.arguments.size()];
                params[0] = this.owner.clazz;
                for (int i = 0; i < this.arguments.size(); ++i) {
                    params[i + 1] = this.arguments.get((int)i).clazz;
                }
                returnValue = this.rtn.clazz;
            }
            return MethodType.methodType(returnValue, params);
        }

        public void write(MethodWriter writer) {
            org.objectweb.asm.Type type;
            if (this.augmentation) {
                assert (Modifier.isStatic(this.modifiers));
                type = WriterConstants.AUGMENTATION_TYPE;
            } else {
                type = this.owner.type;
            }
            if (Modifier.isStatic(this.modifiers)) {
                writer.invokeStatic(type, this.method);
            } else if (Modifier.isInterface(this.owner.clazz.getModifiers())) {
                writer.invokeInterface(type, this.method);
            } else {
                writer.invokeVirtual(type, this.method);
            }
        }
    }

    public static final class Type {
        public final String name;
        public final int dimensions;
        public final Struct struct;
        public final Class<?> clazz;
        public final org.objectweb.asm.Type type;
        public final Sort sort;

        private Type(String name, int dimensions, Struct struct, Class<?> clazz, org.objectweb.asm.Type type, Sort sort) {
            this.name = name;
            this.dimensions = dimensions;
            this.struct = struct;
            this.clazz = clazz;
            this.type = type;
            this.sort = sort;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Type type = (Type)object;
            return this.type.equals((Object)type.type) && this.struct.equals(type.struct);
        }

        public int hashCode() {
            int result = this.struct.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Sort {
        VOID(Void.TYPE, Void.class, null, 0, true, false, false, false),
        BOOL(Boolean.TYPE, Boolean.class, null, 1, true, true, false, true),
        BYTE(Byte.TYPE, Byte.class, null, 1, true, false, true, true),
        SHORT(Short.TYPE, Short.class, null, 1, true, false, true, true),
        CHAR(Character.TYPE, Character.class, null, 1, true, false, true, true),
        INT(Integer.TYPE, Integer.class, null, 1, true, false, true, true),
        LONG(Long.TYPE, Long.class, null, 2, true, false, true, true),
        FLOAT(Float.TYPE, Float.class, null, 1, true, false, true, true),
        DOUBLE(Double.TYPE, Double.class, null, 2, true, false, true, true),
        VOID_OBJ(Void.class, null, Void.TYPE, 1, true, false, false, false),
        BOOL_OBJ(Boolean.class, null, Boolean.TYPE, 1, false, true, false, false),
        BYTE_OBJ(Byte.class, null, Byte.TYPE, 1, false, false, true, false),
        SHORT_OBJ(Short.class, null, Short.TYPE, 1, false, false, true, false),
        CHAR_OBJ(Character.class, null, Character.TYPE, 1, false, false, true, false),
        INT_OBJ(Integer.class, null, Integer.TYPE, 1, false, false, true, false),
        LONG_OBJ(Long.class, null, Long.TYPE, 1, false, false, true, false),
        FLOAT_OBJ(Float.class, null, Float.TYPE, 1, false, false, true, false),
        DOUBLE_OBJ(Double.class, null, Double.TYPE, 1, false, false, true, false),
        NUMBER(Number.class, null, null, 1, false, false, false, false),
        STRING(String.class, null, null, 1, false, false, false, true),
        OBJECT(null, null, null, 1, false, false, false, false),
        DEF(null, null, null, 1, false, false, false, false),
        ARRAY(null, null, null, 1, false, false, false, false);

        public final Class<?> clazz;
        public final Class<?> boxed;
        public final Class<?> unboxed;
        public final int size;
        public final boolean primitive;
        public final boolean bool;
        public final boolean numeric;
        public final boolean constant;

        private Sort(Class<?> clazz, Class<?> boxed, Class<?> unboxed, int size, boolean primitive, boolean bool, boolean numeric, boolean constant) {
            this.clazz = clazz;
            this.boxed = boxed;
            this.unboxed = unboxed;
            this.size = size;
            this.bool = bool;
            this.primitive = primitive;
            this.numeric = numeric;
            this.constant = constant;
        }
    }
}

