/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPTransactionElement;
import ca.sqlpower.util.SQLPowerUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;

public class PersistedSPOProperty
implements SPTransactionElement,
Comparable<PersistedSPOProperty> {
    private final String uuid;
    private final String propertyName;
    private final SPPersister.DataType dataType;
    private final Object oldValue;
    private final Object newValue;
    private final boolean unconditional;

    public PersistedSPOProperty(String uuid, String propertyName, SPPersister.DataType dataType, Object oldValue, Object newValue, boolean unconditional) {
        this.uuid = uuid;
        this.propertyName = propertyName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.unconditional = unconditional;
        this.dataType = dataType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public SPPersister.DataType getDataType() {
        return this.dataType;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        return "SPObjectProperty [uuid=" + this.uuid + ", propertyName=" + this.propertyName + ", dataType=" + (Object)((Object)this.dataType) + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", unconditional=" + this.unconditional + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PersistedSPOProperty wop = (PersistedSPOProperty)obj;
        if (!(this.isUnconditional() || wop.isUnconditional() || SQLPowerUtils.areEqual(this.getOldValue(), wop.getOldValue()))) {
            return false;
        }
        if (this.isUnconditional() == wop.isUnconditional() && this.getUUID().equals(wop.getUUID()) && this.getPropertyName().equals(wop.getPropertyName()) && this.getDataType().equals((Object)wop.getDataType())) {
            if (this.getDataType().equals((Object)SPPersister.DataType.PNG_IMG)) {
                return PersistedSPOProperty.imageObjectsAreEqual(this.getNewValue(), wop.getNewValue());
            }
            return this.getNewValue().equals(wop.getNewValue());
        }
        return false;
    }

    public static boolean imageObjectsAreEqual(Object a, Object b) throws IllegalArgumentException {
        if (a instanceof ByteArrayInputStream) {
            ByteArrayInputStream aStream = (ByteArrayInputStream)a;
            ByteArrayInputStream bStream = (ByteArrayInputStream)b;
            byte[] aBytes = new byte[aStream.available()];
            byte[] bBytes = new byte[bStream.available()];
            try {
                aStream.mark(-1);
                aStream.read(aBytes);
                aStream.reset();
                bStream.mark(-1);
                bStream.read(bBytes);
                bStream.reset();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Arrays.equals(aBytes, bBytes);
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (this.unconditional ? 1 : 0);
        result = 31 * result + (this.oldValue == null ? 0 : this.oldValue.hashCode());
        result = 31 * result + this.uuid.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (this.newValue == null ? 0 : this.newValue.hashCode());
        return result;
    }

    @Override
    public int compareTo(PersistedSPOProperty p) {
        return (this.getUUID() + this.getPropertyName()).compareTo(p.getUUID() + p.getPropertyName());
    }
}

