/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.Writer;

public final class SeekableStringWriter
extends Writer {
    private final StringBuffer stringBuffer;
    private int offset = 0;

    public SeekableStringWriter() {
        this.stringBuffer = new StringBuffer();
    }

    public SeekableStringWriter(int initialSize) {
        this.stringBuffer = new StringBuffer(initialSize);
    }

    public SeekableStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public SeekableStringWriter append(CharSequence csq) {
        this.write(csq.toString());
        return this;
    }

    public SeekableStringWriter append(CharSequence csq, int start, int end) {
        this.write(csq.subSequence(start, end).toString());
        return this;
    }

    public void write(char[] cbuf) {
        this._write(cbuf, 0, cbuf.length);
    }

    public void write(char[] cbuf, int off, int len) {
        int bufLen = cbuf.length;
        if (off < 0 || off > bufLen || len < 0 || off + len > bufLen) {
            throw new IllegalArgumentException();
        }
        this._write(cbuf, off, len);
    }

    public void write(int c) {
        if (this.offset == this.stringBuffer.length()) {
            this.stringBuffer.append((char)c);
        } else {
            this.stringBuffer.setCharAt(this.offset, (char)c);
        }
        ++this.offset;
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) {
        this.write(str.toCharArray(), off, len);
    }

    private void _write(char[] cbuf, int off, int len) {
        int strLen = this.stringBuffer.length();
        int space = strLen - this.offset;
        int written = Math.min(len, space);
        if (written > 0) {
            this.stringBuffer.replace(this.offset, this.offset + written, new String(cbuf, off, written));
        }
        if (written < len) {
            this.stringBuffer.append(cbuf, off + written, len - written);
        }
        this.offset += len;
    }

    public void seek(int offset) {
        if (offset < 0 || offset > this.stringBuffer.length()) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
    }

    public StringBuffer getBuffer() {
        return this.stringBuffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return this.stringBuffer.toString();
    }

    public void close() {
    }

    public void flush() {
    }
}

