/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DispatchMacroFunction;
import org.armedbear.lisp.FaslReadtable;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.ReaderMacroFunction;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class FaslReader {
    public static final ReaderMacroFunction FASL_READ_STRING = new ReaderMacroFunction("fasl-read-string", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char terminator) {
            return stream.readString(terminator, Stream.faslReadtable);
        }
    };
    public static final ReaderMacroFunction FASL_READ_LIST = new ReaderMacroFunction("fasl-read-list", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            return stream.readList(false, Stream.faslReadtable);
        }
    };
    public static final ReaderMacroFunction FASL_READ_QUOTE = new ReaderMacroFunction("fasl-read-quote", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char ignored) {
            return new Cons(Symbol.QUOTE, (LispObject)new Cons(stream.read(true, Lisp.NIL, true, LispThread.currentThread(), Stream.faslReadtable)));
        }
    };
    public static final ReaderMacroFunction FASL_READ_DISPATCH_CHAR = new ReaderMacroFunction("fasl-read-dispatch-char", Lisp.PACKAGE_SYS, false, "stream character"){

        public LispObject execute(Stream stream, char c) {
            return stream.readDispatchChar(c, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_LEFT_PAREN = new DispatchMacroFunction("fasl-sharp-left-paren", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readSharpLeftParen(c, n, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_STAR = new DispatchMacroFunction("fasl-sharp-star", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char ignored, int n) {
            return stream.readSharpStar(ignored, n, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_DOT = new DispatchMacroFunction("fasl-sharp-dot", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readSharpDot(c, n, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_COLON = new DispatchMacroFunction("fasl-sharp-colon", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            LispThread thread = LispThread.currentThread();
            return stream.readSymbol(FaslReadtable.getInstance());
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_A = new DispatchMacroFunction("fasl-sharp-a", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readArray(n, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_B = new DispatchMacroFunction("fasl-sharp-b", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(2, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_C = new DispatchMacroFunction("fasl-sharp-c", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readComplex(Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_O = new DispatchMacroFunction("fasl-sharp-o", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(8, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_P = new DispatchMacroFunction("fasl-sharp-p", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readPathname(Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_R = new DispatchMacroFunction("fasl-sharp-r", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(n, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_S = new DispatchMacroFunction("fasl-sharp-s", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readStructure(Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_X = new DispatchMacroFunction("fasl-sharp-x", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readRadix(16, Stream.faslReadtable);
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_QUOTE = new DispatchMacroFunction("fasl-sharp-quote", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return new Cons(Symbol.FUNCTION, (LispObject)new Cons(stream.read(true, Lisp.NIL, true, LispThread.currentThread(), Stream.faslReadtable)));
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_BACKSLASH = new DispatchMacroFunction("fasl-sharp-backslash", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return stream.readCharacterLiteral(FaslReadtable.getInstance(), LispThread.currentThread());
        }
    };
    public static final DispatchMacroFunction FASL_SHARP_QUESTION_MARK = new DispatchMacroFunction("fasl-sharp-question-mark", Lisp.PACKAGE_SYS, false, "stream sub-char numarg"){

        public LispObject execute(Stream stream, char c, int n) {
            return Load.getUninternedSymbol(n);
        }
    };
}

