/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsRow;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTable;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsToolBar;

public class TransformsPanel
extends JPanel {
    private static final long serialVersionUID = 7196885404320613786L;
    private TransformsToolBar controlPanel;
    private FuzzingPanel fp;
    private TransformsTable transformsTable;
    private ArrayList<TransformsTableModel> transformsLists;

    public TransformsPanel(FuzzingPanel fp) {
        this.fp = fp;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Added Fuzzer Transforms (rules applied top first) "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.transformsTable = new TransformsTable(new TransformsTableModel());
        this.transformsLists = new ArrayList();
        this.controlPanel = new TransformsToolBar(fp);
        JScrollPane fuzzersScrollPane = new JScrollPane(this.transformsTable);
        fuzzersScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)fuzzersScrollPane, "Center");
        this.add((Component)this.controlPanel, "East");
    }

    public void addTransformsList() {
        TransformsTableModel tm = new TransformsTableModel();
        this.transformsLists.add(tm);
        this.transformsTable.setModel(tm);
        this.transformsTable.updateUI();
        this.updateUI();
    }

    public TransformsTableModel getTransforms(int fuzzerRow) {
        return this.transformsLists.get(fuzzerRow);
    }

    public void removeTransformsList(int i) {
        this.transformsLists.remove(i);
    }

    public void addTransform(int fuzzerNumber, String transform, String prefix, String suffix) {
        TransformsRow tr = new TransformsRow(transform, prefix, suffix);
        this.transformsLists.get(fuzzerNumber).addRow(tr);
    }

    public void addTransform(int fuzzer) {
        TransformsRow tr = new TransformsRow();
        this.transformsLists.get(fuzzer).addRow(tr);
    }

    public void showTransformsList(int row) {
        TransformsTableModel tl = this.transformsLists.get(row);
        this.transformsTable.setModel(tl);
        this.transformsTable.updateUI();
        if (row == 0) {
            this.fp.getControlPanel().disableAll();
            this.fp.getControlPanel().enableAdd();
        } else if (row == 1) {
            this.fp.getControlPanel().disableAll();
            this.fp.getControlPanel().enableAdd();
            this.fp.getControlPanel().enableDelete();
        } else {
            this.fp.getControlPanel().enableAll();
        }
    }

    public void clear() {
    }

    public TransformsToolBar getTransformsToolBar() {
        return this.controlPanel;
    }

    public TransformsTable getTransformsTable() {
        return this.transformsTable;
    }

    public TransformsTableModel getTransformsTableModel(int index) {
        return this.transformsLists.get(index);
    }
}

