/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.ascan.ChallengeCallbackPlugin;

public abstract class ChallengeCallbackAPI
extends ApiImplementor {
    private static final String API_RESPONSE_KO = "ko";
    private static final String API_RESPONSE_OK = "ok";
    private static final long CALLBACK_EXPIRE_TIME = 120000L;
    private static final Logger logger = Logger.getLogger(ChallengeCallbackAPI.class);
    private final Map<String, RegisteredCallback> regCallbacks = Collections.synchronizedMap(new TreeMap());

    public ChallengeCallbackAPI() {
        this.addApiShortcut(this.getPrefix());
    }

    @Override
    public abstract String getPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredCallbacks() {
        long l = System.currentTimeMillis();
        Map<String, RegisteredCallback> map = this.regCallbacks;
        synchronized (map) {
            Iterator<Map.Entry<String, RegisteredCallback>> iterator = this.regCallbacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, RegisteredCallback> entry = iterator.next();
                if (l - entry.getValue().getTimestamp() <= 120000L) continue;
                iterator.remove();
            }
        }
    }

    public String getCallbackUrl(String string) {
        String string2 = "http://" + Model.getSingleton().getOptionsParam().getProxyParam().getProxyIp() + ":" + Model.getSingleton().getOptionsParam().getProxyParam().getProxyPort() + "/" + this.getPrefix() + "/" + string;
        return string2;
    }

    @Override
    public HttpMessage handleShortcut(HttpMessage httpMessage) throws ApiException {
        try {
            String string;
            RegisteredCallback registeredCallback;
            String string2 = httpMessage.getRequestHeader().getURI().getPath();
            String string3 = string2.substring(string2.indexOf(this.getPrefix()) + this.getPrefix().length() + 1);
            if (string3.charAt(string3.length() - 1) == '/') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((registeredCallback = this.regCallbacks.get(string3)) != null) {
                registeredCallback.getPlugin().notifyCallback(string3, registeredCallback.getAttackMessage());
                string = API_RESPONSE_OK;
                this.regCallbacks.remove(string3);
            } else {
                string = API_RESPONSE_KO;
                this.cleanExpiredCallbacks();
            }
            httpMessage.setResponseHeader("HTTP/1.1 200 OK\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nAccess-Control-Allow-Origin: *\r\nAccess-Control-Allow-Methods: GET,POST,OPTIONS\r\nAccess-Control-Allow-Headers: ZAP-Header\r\nContent-Length: " + string.length() + "\r\nContent-Type: text/html;");
            httpMessage.setResponseBody(string);
        }
        catch (URIException | HttpMalformedHeaderException throwable) {
            logger.warn((Object)throwable.getMessage(), throwable);
        }
        return httpMessage;
    }

    public void registerCallback(String string, ChallengeCallbackPlugin challengeCallbackPlugin, HttpMessage httpMessage) {
        this.cleanExpiredCallbacks();
        this.regCallbacks.put(string, new RegisteredCallback(challengeCallbackPlugin, httpMessage));
    }

    private static class RegisteredCallback {
        private final ChallengeCallbackPlugin plugin;
        private HistoryReference hRef;
        private long timeStamp;

        public RegisteredCallback(ChallengeCallbackPlugin challengeCallbackPlugin, HttpMessage httpMessage) {
            this.plugin = challengeCallbackPlugin;
            this.timeStamp = System.currentTimeMillis();
            try {
                this.hRef = new HistoryReference(Model.getSingleton().getSession(), 0, httpMessage);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                // empty catch block
            }
        }

        public ChallengeCallbackPlugin getPlugin() {
            return this.plugin;
        }

        public HttpMessage getAttackMessage() {
            try {
                if (this.hRef != null) {
                    return this.hRef.getHttpMessage();
                }
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                // empty catch block
            }
            return null;
        }

        public long getTimestamp() {
            return this.timeStamp;
        }
    }
}

