/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zaproxy.zap.control.AddOnClassnames;

public class AddOnClassLoader
extends URLClassLoader {
    private final ParentClassLoader parent;
    private final List<AddOnClassLoader> childClassLoaders;
    private List<AddOnClassLoader> dependencies;
    private AddOnClassnames addOnClassnames;

    public AddOnClassLoader(URL uRL, ClassLoader classLoader) {
        this(uRL, classLoader, Collections.emptyList(), AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL uRL, ClassLoader classLoader, AddOnClassnames addOnClassnames) {
        this(uRL, classLoader, Collections.emptyList(), addOnClassnames);
    }

    public AddOnClassLoader(URL uRL, ClassLoader classLoader, List<AddOnClassLoader> list) {
        this(uRL, classLoader, list, AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL uRL, ClassLoader classLoader, List<AddOnClassLoader> list, AddOnClassnames addOnClassnames) {
        super(new URL[]{uRL}, (ClassLoader)null);
        if (uRL == null) {
            throw new IllegalArgumentException("Parameter addOnFileUrl must not be null.");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Parameter parent must not be null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        this.parent = new ParentClassLoader(classLoader);
        this.dependencies = list.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(list);
        this.childClassLoaders = new ArrayList<AddOnClassLoader>(2);
        this.addOnClassnames = addOnClassnames;
    }

    public AddOnClassLoader(AddOnClassLoader addOnClassLoader, List<AddOnClassLoader> list) {
        super(addOnClassLoader.getURLs(), (ClassLoader)null);
        if (list == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        addOnClassLoader.childClassLoaders.add(this);
        this.parent = new ParentClassLoader(addOnClassLoader);
        this.dependencies = list.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(list);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
    }

    public AddOnClassLoader(AddOnClassLoader addOnClassLoader, List<AddOnClassLoader> list, AddOnClassnames addOnClassnames) {
        super(addOnClassLoader.getURLs(), (ClassLoader)null);
        if (list == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        if (addOnClassnames == null) {
            throw new IllegalArgumentException("Parameter addOnClassnames must not be null.");
        }
        addOnClassLoader.childClassLoaders.add(this);
        this.parent = new ParentClassLoader(addOnClassLoader);
        this.dependencies = list.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(list);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = addOnClassnames;
    }

    public void removeChildClassLoader(AddOnClassLoader addOnClassLoader) {
        this.childClassLoaders.remove(addOnClassLoader);
    }

    @Override
    public void close() throws IOException {
        for (AddOnClassLoader addOnClassLoader : this.childClassLoaders) {
            addOnClassLoader.close();
        }
        super.close();
    }

    public void clearDependencies() {
        this.dependencies = Collections.emptyList();
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (this.addOnClassnames.isAllowed(string)) {
            try {
                return this.findClassInAddOn(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return this.parent.loadClass(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = this.findClassInDependencies(string);
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            return clazz;
        }
    }

    private Class<?> findClassInAddOn(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    private Class<?> findClassInDependencies(String string) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            try {
                return addOnClassLoader.loadClass(string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public URL findResource(String string) {
        URL uRL = this.findResourceInAddOn(string);
        if (uRL == null) {
            uRL = this.parent.getResource(string);
        }
        if (uRL == null) {
            uRL = this.findResourceInDependencies(string);
        }
        return uRL;
    }

    public URL findResourceInAddOn(String string) {
        return super.findResource(string);
    }

    private URL findResourceInDependencies(String string) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            URL uRL = addOnClassLoader.findResourceInAddOn(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static class ParentClassLoader
    extends ClassLoader {
        public ParentClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            return super.loadClass(string, bl);
        }
    }
}

