/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntityWithUniqueID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;

public class ProjectConfig {
    private final ProjectFile m_parent;
    private boolean m_autoWBS = true;
    private boolean m_autoOutlineLevel = true;
    private boolean m_autoOutlineNumber = true;
    private boolean m_autoTaskUniqueID = true;
    private boolean m_autoCalendarUniqueID = true;
    private boolean m_autoAssignmentUniqueID = true;
    private boolean m_autoTaskID = true;
    private boolean m_autoResourceUniqueID = true;
    private boolean m_autoResourceID = true;
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_assignmentUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;

    public ProjectConfig(ProjectFile projectFile) {
        this.m_parent = projectFile;
    }

    public void setAutoWBS(boolean bl) {
        this.m_autoWBS = bl;
    }

    public void setAutoOutlineLevel(boolean bl) {
        this.m_autoOutlineLevel = bl;
    }

    public void setAutoOutlineNumber(boolean bl) {
        this.m_autoOutlineNumber = bl;
    }

    public void setAutoTaskUniqueID(boolean bl) {
        this.m_autoTaskUniqueID = bl;
    }

    public void setAutoCalendarUniqueID(boolean bl) {
        this.m_autoCalendarUniqueID = bl;
    }

    public void setAutoAssignmentUniqueID(boolean bl) {
        this.m_autoAssignmentUniqueID = bl;
    }

    public void setAutoTaskID(boolean bl) {
        this.m_autoTaskID = bl;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoAssignmentUniqueID() {
        return this.m_autoAssignmentUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public void setAutoResourceUniqueID(boolean bl) {
        this.m_autoResourceUniqueID = bl;
    }

    public void setAutoResourceID(boolean bl) {
        this.m_autoResourceID = bl;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getNextTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    public int getNextCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getNextAssignmentUniqueID() {
        return ++this.m_assignmentUniqueID;
    }

    public int getNextTaskID() {
        return ++this.m_taskID;
    }

    public int getNextResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getNextResourceID() {
        return ++this.m_resourceID;
    }

    public void updateUniqueCounters() {
        int n;
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this.m_parent.getAllTasks()) {
            n = NumberHelper.getInt(((Task)projectEntityWithUniqueID).getUniqueID());
            if (n <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = n;
        }
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this.m_parent.getAllResources()) {
            n = NumberHelper.getInt(((Resource)projectEntityWithUniqueID).getUniqueID());
            if (n <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = n;
        }
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this.m_parent.getCalendars()) {
            n = NumberHelper.getInt(((ProjectCalendar)projectEntityWithUniqueID).getUniqueID());
            if (n <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = n;
        }
        for (ProjectEntityWithUniqueID projectEntityWithUniqueID : this.m_parent.getAllResourceAssignments()) {
            n = NumberHelper.getInt(((ResourceAssignment)projectEntityWithUniqueID).getUniqueID());
            if (n <= this.m_assignmentUniqueID) continue;
            this.m_assignmentUniqueID = n;
        }
    }
}

