/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.BCConverter;
import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class CodeAttribute
extends AttributeInfo {
    private ClassConstantPool constantPool;
    private static final String attributeName = "Code";
    private short attributeNameIndex = (short)-1;
    private static final short attributeCount = 0;
    Safeptr byteCodesFromCAP;
    MethodDescriptor md;
    short maxStack;
    short maxLocals;
    int codeLength;
    Vector<ExceptionInfo> exceptionTable;
    Vector<Instruction> byteCodeVector;

    public CodeAttribute(ClassConstantPool classConstantPool) {
        this.constantPool = classConstantPool;
        this.exceptionTable = new Vector();
        this.attributeNameIndex = (short)this.constantPool.addConstantUtf8Info(attributeName);
        this.setNameIndex(this.attributeNameIndex);
    }

    public CodeAttribute(ClassConstantPool classConstantPool, MethodDescriptor methodDescriptor) {
        this(classConstantPool);
        boolean bl;
        this.md = methodDescriptor;
        MethodInfo methodInfo = Cap.Method.methodInfo(methodDescriptor.methodOffset());
        int n = methodInfo.flags();
        boolean bl2 = bl = (n & 8) == 8;
        if (bl) {
            this.maxStack = (short)methodInfo.maxStackExtended();
            this.maxLocals = (short)(methodInfo.maxLocalsExtended() + methodInfo.numArgsExtended());
            this.byteCodesFromCAP = methodInfo.bytecodeExtended();
        } else {
            this.maxStack = (short)methodInfo.maxStackCompact();
            this.maxLocals = (short)(methodInfo.maxLocalsCompact() + methodInfo.numArgsCompact());
            this.byteCodesFromCAP = methodInfo.bytecodeCompact();
        }
        this.byteCodeVector = BCConverter.convert(methodDescriptor, bl, classConstantPool);
        BCConverter.fixOffsets(this.byteCodeVector);
        this.createExceptionList(methodDescriptor);
        this.length = this.getAttributeSize();
    }

    public CodeAttribute(Vector<Instruction> vector, int n, int n2, ClassConstantPool classConstantPool) {
        this(classConstantPool);
        this.byteCodeVector = vector;
        this.maxStack = (short)n;
        this.maxLocals = (short)n2;
        this.length = this.getAttributeSize();
    }

    private void createExceptionList(MethodDescriptor methodDescriptor) {
        int n = methodDescriptor.methodOffset();
        int n2 = methodDescriptor.bytecodeCount();
        int n3 = n + methodDescriptor.bytecodeCount();
        int n4 = Cap.Method.handlerCount();
        for (int i = 0; i < n4; ++i) {
            ExnHandlerInfo exnHandlerInfo = Cap.Method.exceptionHandler(i);
            short s = (short)exnHandlerInfo.startOffset();
            short s2 = (short)exnHandlerInfo.endOffset();
            if (s < n || s >= n3 || s2 >= n3) continue;
            short s3 = (short)exnHandlerInfo.handlerOffset();
            int n5 = exnHandlerInfo.catchType();
            short s4 = 0;
            if (n5 != 0) {
                ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n5);
                int n6 = constantPoolEntry.classRef();
                String string = CAPUtil.getRefName(n6);
                s4 = this.constantPool.getClassRefIndex(string);
            }
            short s5 = (short)(s - n - 2);
            s = BCConverter.translateOffset(this.byteCodeVector, s5);
            s5 = (short)(s2 - n - 2);
            s2 = BCConverter.translateOffset(this.byteCodeVector, s5);
            s5 = (short)(s3 - n - 2);
            s3 = BCConverter.translateOffset(this.byteCodeVector, s5);
            this.exceptionTable.add(new ExceptionInfo(s, s2, s3, s4));
        }
    }

    private int getAttributeSize() {
        int n;
        int n2 = 12;
        this.codeLength = 0;
        for (n = 0; n < this.byteCodeVector.size(); ++n) {
            Instruction instruction = this.byteCodeVector.elementAt(n);
            Vector<JavaInstruction> vector = instruction.getJavaInstructions();
            for (int i = 0; i < vector.size(); ++i) {
                JavaInstruction javaInstruction = vector.elementAt(i);
                n2 += javaInstruction.getSize();
                this.codeLength += javaInstruction.getSize();
            }
        }
        for (n = 0; n < this.exceptionTable.size(); ++n) {
            n2 += 8;
        }
        return n2;
    }

    @Override
    void write(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = Util.getShortBytes(this.nameIndex);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        byteArrayOutputStream.write(byArray2, 0, 4);
        byte[] byArray3 = Util.getShortBytes(this.maxStack);
        byteArrayOutputStream.write(byArray3, 0, 2);
        byte[] byArray4 = Util.getShortBytes(this.maxLocals);
        byteArrayOutputStream.write(byArray4, 0, 2);
        byte[] byArray5 = Util.getIntBytes(this.codeLength);
        byteArrayOutputStream.write(byArray5, 0, 4);
        for (int i = 0; i < this.byteCodeVector.size(); ++i) {
            Instruction instruction = this.byteCodeVector.elementAt(i);
            Vector<JavaInstruction> vector = instruction.getJavaInstructions();
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).write(byteArrayOutputStream);
            }
        }
        byte[] byArray6 = Util.getShortBytes((short)this.exceptionTable.size());
        byteArrayOutputStream.write(byArray6, 0, 2);
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            this.exceptionTable.elementAt(i).write(byteArrayOutputStream);
        }
        byte[] byArray7 = Util.getShortBytes((short)0);
        byteArrayOutputStream.write(byArray7, 0, 2);
    }

    @Override
    public void print(String string) {
        System.out.println(string + "Code Attribute");
        byte[] byArray = Util.getShortBytes(this.nameIndex);
        Util.printArray(string + "\tAttribute Name Index: ", byArray, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        Util.printArray(string + "\tAttribute Length: ", byArray2, byArray2.length);
        byte[] byArray3 = Util.getShortBytes(this.maxStack);
        Util.printArray(string + "\tMax Stack: ", byArray3, byArray3.length);
        byte[] byArray4 = Util.getShortBytes(this.maxLocals);
        Util.printArray(string + "\tMax Locals: ", byArray4, byArray4.length);
        byte[] byArray5 = Util.getIntBytes(this.codeLength);
        Util.printArray(string + "\tCode Length: ", byArray5, byArray5.length);
        for (int i = 0; i < this.byteCodeVector.size(); ++i) {
            Instruction instruction = this.byteCodeVector.elementAt(i);
            Vector<JavaInstruction> vector = instruction.getJavaInstructions();
            for (int j = 0; j < vector.size(); ++j) {
                vector.elementAt(j).print(string + "\t");
            }
        }
        byte[] byArray6 = Util.getShortBytes((short)this.exceptionTable.size());
        Util.printArray(string + "\tException Table Length: ", byArray6, byArray6.length);
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            this.exceptionTable.elementAt(i).print(string);
        }
        byte[] byArray7 = Util.getShortBytes((short)0);
        Util.printArray(string + "\tAttribute Count: ", byArray7, byArray7.length);
    }

    class ExceptionInfo {
        static final int size = 8;
        short startPC;
        short endPC;
        short handlerPC;
        short catchType;

        ExceptionInfo(short s, short s2, short s3, short s4) {
            this.startPC = s;
            this.endPC = s2;
            this.handlerPC = s3;
            this.catchType = s4;
        }

        void write(ByteArrayOutputStream byteArrayOutputStream) {
            byte[] byArray = Util.getShortBytes(this.startPC);
            byteArrayOutputStream.write(byArray, 0, 2);
            byte[] byArray2 = Util.getShortBytes(this.endPC);
            byteArrayOutputStream.write(byArray2, 0, 2);
            byte[] byArray3 = Util.getShortBytes(this.handlerPC);
            byteArrayOutputStream.write(byArray3, 0, 2);
            byte[] byArray4 = Util.getShortBytes(this.catchType);
            byteArrayOutputStream.write(byArray4, 0, 2);
        }

        void print(String string) {
            byte[] byArray = Util.getShortBytes(this.startPC);
            Util.printArray(string + "\tStart PC: ", byArray, byArray.length);
            byte[] byArray2 = Util.getShortBytes(this.endPC);
            Util.printArray(string + "\tEnd PC: ", byArray2, byArray2.length);
            byte[] byArray3 = Util.getShortBytes(this.handlerPC);
            Util.printArray(string + "\tEnd PC: ", byArray3, byArray3.length);
            byte[] byArray4 = Util.getShortBytes(this.catchType);
            Util.printArray(string + "\tEnd PC: ", byArray4, byArray4.length);
        }
    }
}

