/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocStaticAccessType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;

public class PHPVarCommentParser {
    private static String PHPDOCTAG = "@" + PHPDocTag.Type.VAR.name().toLowerCase();

    PHPVarComment parse(int startOffset, int endOffset, String comment) {
        int index = comment.indexOf(PHPDOCTAG);
        if (index > -1) {
            String definition = comment.substring(index);
            if ((index = definition.indexOf("*/")) > -1) {
                definition = definition.substring(0, index);
            }
            int startDocNode = 0;
            int endPosition = 0;
            String[] parts = definition.split(" +");
            if (parts.length == 3 && parts[1].charAt(0) == '$') {
                String[] types = parts[2].split("[|]");
                int typePosition = startOffset + comment.indexOf(parts[2]);
                ArrayList<PHPDocNode> typeNodes = new ArrayList<PHPDocNode>();
                for (String type : types) {
                    PHPDocNode docType;
                    startDocNode = typePosition + parts[2].indexOf(type);
                    index = type.indexOf("::");
                    endPosition = startDocNode + type.length();
                    if (index == -1) {
                        docType = new PHPDocNode(startDocNode, endPosition, type);
                    } else {
                        String className = type.substring(0, index);
                        String constantName = type.substring(index + 2, type.length());
                        PHPDocNode classNameNode = new PHPDocNode(startDocNode, startDocNode + className.length(), className);
                        PHPDocNode constantNode = new PHPDocNode(startDocNode + className.length() + 2, startDocNode + type.length(), constantName);
                        docType = new PHPDocStaticAccessType(startDocNode, startDocNode + type.length(), type, classNameNode, constantNode);
                    }
                    typeNodes.add(docType);
                }
                startDocNode = startOffset + comment.indexOf(parts[1]);
                PHPDocNode variableNode = new PHPDocNode(startDocNode, startDocNode + parts[1].length(), parts[1]);
                startDocNode = startOffset + comment.indexOf(PHPDOCTAG);
                PHPDocVarTypeTag variableType = new PHPDocVarTypeTag(startDocNode, endPosition, PHPDocTag.Type.VAR, definition, typeNodes, variableNode);
                return new PHPVarComment(startOffset, endOffset, variableType);
            }
        }
        return null;
    }
}

