/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class SmartSteppingCallback {
    public abstract void initFilter(SmartSteppingFilter var1);

    public abstract boolean stopHere(ContextProvider var1, JPDAThread var2, SmartSteppingFilter var3);

    static class ContextAware
    extends SmartSteppingCallback
    implements ContextAwareService<SmartSteppingCallback> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        public SmartSteppingCallback forContext(ContextProvider context) {
            return (SmartSteppingCallback)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)context);
        }

        @Override
        public void initFilter(SmartSteppingFilter f) {
            assert (false);
        }

        @Override
        public boolean stopHere(ContextProvider lookupProvider, JPDAThread thread, SmartSteppingFilter f) {
            assert (false);
            throw new UnsupportedOperationException("Not supported.");
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

