/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Image;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.beans.PatternAnalyser;
import org.openide.util.ImageUtilities;

public abstract class Pattern {
    public static final Comparator<Pattern> NAME_COMPARATOR = new NameComparator();
    public static final String TYPE_COLOR = "#707070";
    private static final String ICON_BASE = "org/netbeans/modules/beans/resources/";
    private static final String GIF_EXTENSION = ".gif";
    protected static final Image PATTERNS = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/patternGroup.gif");
    protected static final Image PROPERTY_READ = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyRO.gif");
    protected static final Image PROPERTY_WRITE = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyWO.gif");
    protected static final Image PROPERTY_READ_WRITE = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyRW.gif");
    protected static final Image IDX_PROPERTY_READ = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyIndexedRO.gif");
    protected static final Image IDX_PROPERTY_WRITE = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyIndexedWO.gif");
    protected static final Image IDX_PROPERTY_READ_WRITE = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/propertyIndexedRW.gif");
    protected static final Image EVENT_SET_UNICAST = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/eventSetUnicast.gif");
    protected static final Image EVENT_SET_MULTICAST = ImageUtilities.loadImage((String)"org/netbeans/modules/beans/resources/eventSetMulticast.gif");
    protected static final Image CLASS = ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)ElementKind.CLASS, Collections.emptySet()));
    protected static final Image INTERFACE = ImageUtilities.icon2Image((Icon)ElementIcons.getElementIcon((ElementKind)ElementKind.INTERFACE, Collections.emptySet()));
    protected final TypeMirrorHandle<TypeMirror> type;
    protected final String name;
    protected final Kind kind;
    private PatternAnalyser patternAnalyser;

    public Pattern(PatternAnalyser patternAnalyser, Kind kind, String string, TypeMirrorHandle<TypeMirror> typeMirrorHandle) {
        this.patternAnalyser = patternAnalyser;
        this.kind = kind;
        this.name = string;
        this.type = typeMirrorHandle;
    }

    public PatternAnalyser getPatternAnalyser() {
        return this.patternAnalyser;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setName(String var1);

    public abstract Image getIcon();

    public String getHtmlDisplayName() {
        return null;
    }

    public ElementHandle<TypeElement> getDeclaringClass() {
        return this.patternAnalyser.getClassElementHandle();
    }

    public TypeMirrorHandle<TypeMirror> getType() {
        return this.type;
    }

    public Kind getKind() {
        return this.kind;
    }

    public List<Pattern> getPatterns() {
        if (this.kind == Kind.CLASS) {
            return this.patternAnalyser.getPatterns();
        }
        return Collections.emptyList();
    }

    public void destroy() {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        if (!(this.name == pattern.name || this.name != null && this.name.equals(pattern.name))) {
            return false;
        }
        return this.kind == pattern.kind || this.kind != null && this.kind.equals((Object)pattern.kind);
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 67 * n + (this.kind != null ? this.kind.hashCode() : 0);
        return n;
    }

    private static class NameComparator
    implements Comparator<Pattern> {
        private NameComparator() {
        }

        @Override
        public int compare(Pattern pattern, Pattern pattern2) {
            return pattern.name.compareToIgnoreCase(pattern2.name);
        }
    }

    public static enum Kind {
        CLASS,
        PROPERTY,
        EVENT_SOURCE;

    }
}

