/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.FoldersListSettings;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private final PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private JButton browseButton;
    private JLabel description;
    private JPanel projectInfoPanel;
    private JTextField projectLocation;
    private JLabel projectLocationLabel;
    private JTextField projectName;
    private JLabel projectNameLabel;

    public PanelProjectLocationExtSrc(PanelConfigureProject panel) {
        this.firer = panel;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File f = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(f.getAbsolutePath() + File.separator + this.projectName.getText());
            this.calculatePF = true;
        }
    }

    private synchronized void setCalculateProjectFolder(boolean value) {
        this.calculatePF = value;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        String projectName = null;
        File projectLocation = (File)settings.getProperty("projdir");
        if (projectLocation == null) {
            File file;
            projectLocation = ProjectChooser.getProjectsFolder();
            int index = FoldersListSettings.getDefault().getNewProjectCount();
            String formater = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_JavaProject");
            while ((file = new File(projectLocation, projectName = MessageFormat.format(formater, ++index))).exists()) {
            }
            settings.putProperty("nameIndex", (Object)index);
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(true);
        } else {
            projectName = (String)settings.getProperty("name");
            boolean tmpFlag = this.calculatePF;
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(tmpFlag);
        }
        this.projectName.setText(projectName);
        this.projectName.selectAll();
    }

    @Override
    void store(WizardDescriptor settings) {
        settings.putProperty("name", (Object)this.projectName.getText());
        File projectsDir = new File(this.projectLocation.getText());
        settings.putProperty("projdir", (Object)projectsDir);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        String result = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            File environment = new File(this.projectLocation.getText(), "config" + File.separator + "environment.rb");
            if (environment.exists()) {
                String message = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ProbablyRails");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
            }
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(String projectName, String projectLocation) {
        if (projectName.length() == 0 || projectName.indexOf(47) > 0 || projectName.indexOf(92) > 0 || projectName.indexOf(58) > 0) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectName");
        }
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NetBeansProject");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (Util.isProjectAlready(destFolder)) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectAlreadyProject");
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    private void initComponents() {
        this.projectInfoPanel = new JPanel();
        this.description = new JLabel();
        this.projectNameLabel = new JLabel();
        this.projectName = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocation = new JTextField();
        this.browseButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.projectInfoPanel.setLayout(new GridBagLayout());
        this.description.setLabelFor(this.projectInfoPanel);
        Mnemonics.setLocalizedText((JLabel)this.description, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.projectInfoPanel.add((Component)this.description, gridBagConstraints);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.projectNameLabel.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.projectInfoPanel.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.projectName, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.projectInfoPanel.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.projectLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.projectInfoPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent evt) {
        File file;
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocation.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

