/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2JavaEEPlatformFactory;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class Hk2JavaEEPlatformImpl
extends J2eePlatformImpl {
    private Hk2DeploymentManager dm;
    private final LibraryImplementation lib = new J2eeLibraryTypeProvider().createLibrary();
    private final LibraryImplementation[] libraries = new LibraryImplementation[]{this.lib};
    private Hk2JavaEEPlatformFactory pf;
    private static final String PERSISTENCE_PROV_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String TOOL_WSCOMPILE = "wscompile";
    private static final String TOOL_JSR109 = "jsr109";
    private static final String TOOL_WSIMPORT = "wsimport";
    private static final String TOOL_WSGEN = "wsgen";
    private static final String TOOL_KEYSTORE = "keystore";
    private static final String TOOL_KEYSTORECLIENT = "keystoreClient";
    private static final String TOOL_TRUSTSTORE = "truststore";
    private static final String TOOL_TRUSTSTORECLIENT = "truststoreClient";
    private static final String TOOL_WSIT = "wsit";
    private static final String TOOL_JAXWSTESTER = "jaxws-tester";
    private static final String TOOL_APPCLIENTRUNTIME = "appClientRuntime";
    private static final String KEYSTORE_LOCATION = "config/keystore.jks";
    private static final String TRUSTSTORE_LOCATION = "config/cacerts.jks";
    private static final String EMBEDDED_EJB_CONTAINER_PATH = "lib/embedded/glassfish-embedded-static-shell.jar";
    private static RequestProcessor libInitThread = new RequestProcessor("init libs -- Hk2JavaEEPlatformImpl");

    public Hk2JavaEEPlatformImpl(Hk2DeploymentManager hk2DeploymentManager, Hk2JavaEEPlatformFactory hk2JavaEEPlatformFactory) {
        this.dm = hk2DeploymentManager;
        this.pf = hk2JavaEEPlatformFactory;
        String string = (String)hk2DeploymentManager.getCommonServerSupport().getInstanceProperties().get("homefolder");
        File file = new File(string, "modules");
        FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)).addFileChangeListener(new FileChangeListener(){

            public void fileFolderCreated(FileEvent fileEvent) {
                Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
            }

            public void fileDataCreated(FileEvent fileEvent) {
                Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
            }

            public void fileChanged(FileEvent fileEvent) {
                Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
            }

            public void fileDeleted(FileEvent fileEvent) {
                Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
            }

            public void fileRenamed(FileRenameEvent fileRenameEvent) {
                Hk2JavaEEPlatformImpl.this.notifyLibrariesChanged();
            }

            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            }
        });
        this.initLibraries();
    }

    public boolean isToolSupported(String string) {
        if (PERSISTENCE_PROV_ECLIPSELINK.equals(string)) {
            return true;
        }
        if ("org.hibernate.ejb.HibernatePersistence".equals(string) || "oracle.toplink.essentials.PersistenceProvider".equals(string) || "kodo.persistence.PersistenceProviderImpl".equals(string) || "org.apache.openjpa.persistence.PersistenceProviderImpl".equals(string)) {
            return true;
        }
        if ("defaultPersistenceProviderJavaEE5".equals(string)) {
            return true;
        }
        if ("eclipseLinkPersistenceProviderIsDefault".equals(string)) {
            return true;
        }
        String string2 = this.dm.getProperties().getGlassfishRoot();
        if ("embeddableejb".equals(string)) {
            File file = new File(string2, EMBEDDED_EJB_CONTAINER_PATH);
            return file.exists() && file.isFile() && file.canRead();
        }
        File file = null;
        if (string2 != null) {
            file = ServerUtilities.getJarName((String)string2, (String)"webservices(|-osgi).jar");
        }
        if (file != null && file.exists()) {
            if (TOOL_WSGEN.equals(string)) {
                return true;
            }
            if (TOOL_WSIMPORT.equals(string)) {
                return true;
            }
            if (TOOL_WSIT.equals(string)) {
                return true;
            }
            if (TOOL_JAXWSTESTER.equals(string)) {
                return true;
            }
            if (TOOL_JSR109.equals(string)) {
                return true;
            }
            if (TOOL_KEYSTORE.equals(string)) {
                return true;
            }
            if (TOOL_KEYSTORECLIENT.equals(string)) {
                return true;
            }
            if (TOOL_TRUSTSTORE.equals(string)) {
                return true;
            }
            if (TOOL_TRUSTSTORECLIENT.equals(string)) {
                return true;
            }
            if (TOOL_WSCOMPILE.equals(string)) {
                return true;
            }
            if (TOOL_APPCLIENTRUNTIME.equals(string)) {
                return true;
            }
        }
        return false;
    }

    public File[] getToolClasspathEntries(String string) {
        String string2 = this.dm.getProperties().getGlassfishRoot();
        if (null != string2) {
            String string3;
            if ("embeddableejb".equals(string)) {
                return new File[]{new File(string2, EMBEDDED_EJB_CONTAINER_PATH)};
            }
            if (TOOL_WSGEN.equals(string) || TOOL_WSIMPORT.equals(string)) {
                String[] stringArray = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.activation.jar"};
                ArrayList<File> arrayList = new ArrayList<File>();
                for (String string4 : stringArray) {
                    File file = ServerUtilities.getWsJarName((String)string2, (String)string4);
                    if (file == null || !file.exists()) continue;
                    arrayList.add(file);
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            if (TOOL_WSCOMPILE.equals(string)) {
                String[] stringArray = new String[]{"webservices(|-osgi).jar"};
                ArrayList<File> arrayList = new ArrayList<File>();
                for (String string5 : stringArray) {
                    File file = ServerUtilities.getWsJarName((String)string2, (String)string5);
                    if (file == null || !file.exists()) continue;
                    arrayList.add(file);
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            File file = null;
            File file2 = new File(string2);
            if (file2 != null && file2.exists() && (string3 = this.dm.getProperties().getDomainDir()) != null) {
                file = new File(string3);
                if (TOOL_KEYSTORE.equals(string) || TOOL_KEYSTORECLIENT.equals(string)) {
                    return new File[]{new File(file, KEYSTORE_LOCATION)};
                }
                if (TOOL_TRUSTSTORE.equals(string) || TOOL_TRUSTSTORECLIENT.equals(string)) {
                    return new File[]{new File(file, TRUSTSTORE_LOCATION)};
                }
            }
        } else {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "dm has no root???", new Exception());
        }
        return new File[0];
    }

    public Set<Profile> getSupportedProfiles() {
        return this.getCorrectedProfileSet();
    }

    public Set<Profile> getSupportedProfiles(J2eeModule.Type type) {
        return this.getCorrectedProfileSet();
    }

    private Set<Profile> getCorrectedProfileSet() {
        Set<Profile> set = this.pf.getSupportedProfiles();
        String string = this.dm.getProperties().getGlassfishRoot();
        File file = new File(string, "modules/appclient-server-core.jar");
        if (!file.exists()) {
            set.remove(Profile.JAVA_EE_6_FULL);
        }
        return set;
    }

    public Set<J2eeModule.Type> getSupportedTypes() {
        Set<J2eeModule.Type> set = this.pf.getSupportedTypes();
        Set<Profile> set2 = this.getCorrectedProfileSet();
        if (set2.contains(Profile.JAVA_EE_6_WEB) && !set2.contains(Profile.JAVA_EE_6_FULL)) {
            set.remove(J2eeModule.Type.CAR);
            set.remove(J2eeModule.Type.EAR);
            set.remove(J2eeModule.Type.EJB);
            set.remove(J2eeModule.Type.RAR);
        }
        return set;
    }

    public File[] getPlatformRoots() {
        File file;
        String string = this.dm.getProperties().getGlassfishRoot();
        File[] fileArray = new File[]{};
        if (string != null && (file = new File(string)).exists()) {
            fileArray = new File[]{file};
        }
        return fileArray;
    }

    public LibraryImplementation[] getLibraries() {
        return (LibraryImplementation[])this.libraries.clone();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/hk2/resources/server.gif");
    }

    public String getDisplayName() {
        return this.pf.getDisplayName();
    }

    public Set getSupportedJavaPlatformVersions() {
        return this.pf.getSupportedJavaPlatforms();
    }

    public JavaPlatform getJavaPlatform() {
        return this.pf.getJavaPlatform();
    }

    public void notifyLibrariesChanged() {
        this.initLibraries();
    }

    private void initLibraries() {
        libInitThread.post(new Runnable(){

            @Override
            public void run() {
                Hk2JavaEEPlatformImpl.this.lib.setName(Hk2JavaEEPlatformImpl.this.pf.getLibraryName());
                Hk2JavaEEPlatformImpl.this.lib.setContent("classpath", Hk2JavaEEPlatformImpl.this.dm.getProperties().getClasses());
                Hk2JavaEEPlatformImpl.this.lib.setContent("javadoc", Hk2JavaEEPlatformImpl.this.dm.getProperties().getJavadocs());
                Hk2JavaEEPlatformImpl.this.firePropertyChange("libraries", null, Hk2JavaEEPlatformImpl.this.libraries.clone());
            }
        });
    }

    public Lookup getLookup() {
        String string = this.dm.getProperties().getGlassfishRoot();
        Lookup lookup = Lookups.fixed((Object[])new Object[]{string});
        return LookupProviderSupport.createCompositeLookup((Lookup)lookup, (String)this.pf.getLookupKey());
    }

    private String quotedString(String string) {
        return "\"" + string + "\"";
    }

    public String getToolProperty(String string, String string2) {
        if (TOOL_APPCLIENTRUNTIME.equals(string)) {
            File file = new File(this.dm.getProperties().getGlassfishRoot());
            String string3 = this.dm.getProperties().getDomainDir();
            if ("main.class".equals(string2)) {
                return "org.glassfish.appclient.client.AppClientFacade";
            }
            if ("main.class.args".equals(string2)) {
                return "${j2ee.appclient.tool.args}";
            }
            if ("jvm.opts".equals(string2)) {
                if (string3 != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("-Djava.endorsed.dirs=");
                    stringBuilder.append(this.quotedString(new File(file, "lib/endorsed").getAbsolutePath()));
                    stringBuilder.append(File.pathSeparator);
                    stringBuilder.append(this.quotedString(new File(file, "modules/endorsed").getAbsolutePath()));
                    stringBuilder.append(" -javaagent:");
                    stringBuilder.append(this.quotedString(new File(file, "modules/gf-client.jar").getAbsolutePath()));
                    stringBuilder.append("=mode=acscript,arg=-configxml,arg=");
                    stringBuilder.append(this.quotedString(new File(string3, "config/sun-acc.xml").getAbsolutePath()));
                    stringBuilder.append(",client=jar=");
                    return stringBuilder.toString();
                }
                return null;
            }
            if ("client.jar.location".equals(string2)) {
                if (string3 != null) {
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string3)));
                    if (fileObject == null) {
                        return null;
                    }
                    return FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + File.separator + "generated" + File.separator + "xml";
                }
                return null;
            }
            if ("j2ee.appclient.args".equals(string2)) {
                return null;
            }
        }
        return null;
    }
}

