/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.j2ee.sun.persistence.mapping.core;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import java.util.List;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.AbstractState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.FieldHolderState;
import org.netbeans.lib.j2ee.sun.persistence.mapping.core.TableState;

public class ClassState
extends AbstractState
implements Cloneable {
    private TableState _tableState;
    private FieldHolderState _fieldHolderState;

    public ClassState(Model model, MappingClassElement mappingClass) {
        this(model, mappingClass, null);
    }

    public ClassState(Model model, MappingClassElement mappingClass, TableState tableState) {
        super(model, mappingClass);
        this.setTableState(tableState);
    }

    public Object clone() {
        ClassState clonedState = (ClassState)super.clone();
        if (this.hasTableState()) {
            clonedState._tableState = (TableState)this.getTableState().clone();
        }
        if (this.hasFieldHolderState()) {
            clonedState._fieldHolderState = (FieldHolderState)this.getFieldHolderState().clone();
        }
        return clonedState;
    }

    public String getDebugInfo() {
        StringBuffer lDump = new StringBuffer();
        lDump.append("Tables\n");
        if (this.hasTableState()) {
            lDump.append(this.getTableState().getDebugInfo());
        }
        lDump.append("Fields and relationships\n");
        if (this.hasFieldHolderState()) {
            lDump.append(this.getFieldHolderState().getDebugInfo());
        }
        return lDump.toString();
    }

    public boolean hasTableState() {
        return this._tableState != null;
    }

    public TableState getTableState() {
        if (!this.hasTableState()) {
            this._tableState = new TableState(this);
        }
        return this._tableState;
    }

    public void setTableState(TableState state) {
        if (this._tableState != state) {
            if (this.hasFieldHolderState()) {
                this._fieldHolderState.updateFieldStates(state);
            }
            this._tableState = state;
        }
        if (this._tableState != null) {
            this._tableState.setClassState(this);
            this._tableState.updateSecondaryTables();
        }
    }

    public boolean hasFieldHolderState() {
        return this._fieldHolderState != null;
    }

    public FieldHolderState getFieldHolderState() {
        if (!this.hasFieldHolderState()) {
            this._fieldHolderState = new FieldHolderState(this);
        }
        return this._fieldHolderState;
    }

    public void setFieldHolderState(FieldHolderState state) {
        if (this._fieldHolderState != state) {
            this._fieldHolderState = state;
        }
        if (this._fieldHolderState != null) {
            this._fieldHolderState.setClassState(this);
        }
    }

    public void addDefaultMapping(List suffixes) {
        this.getTableState().addDefaultTableMapping(this.getMappingClassElement().getName(), suffixes);
        this.getFieldHolderState().addDefaultMapping();
    }
}

