/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class SaasClientPhpAuthenticationGenerator
extends SaasClientAuthenticationGenerator {
    public static final String INDENT = "             ";
    private FileObject saasAuthFile;
    private FileObject loginFile;
    private FileObject callbackFile;

    public SaasClientPhpAuthenticationGenerator(SaasBean bean, Project project) {
        super(bean, project);
    }

    public String getPreAuthenticationCode() {
        String methodBody = "";
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.API_KEY) {
            methodBody = methodBody + "             $apiKey = " + this.getBean().getAuthenticatorClassName() + "::getApiKey();";
        } else if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            methodBody = methodBody + INDENT + this.getBean().getAuthenticatorClassName() + "::login(" + this.getLoginArguments() + ");\n";
            List signParams = sessionKey.getParameters();
            String paramStr = "";
            if (signParams != null && signParams.size() > 0) {
                paramStr = SaasClientPhpAuthenticationGenerator.getSignParamDeclaration(this.getBean(), signParams, Collections.<ParameterInfo>emptyList());
            }
            String sigName = sessionKey.getSigKeyName();
            paramStr = paramStr + "             $sign_params = array();\n";
            for (ParameterInfo p : this.getBean().getInputParameters()) {
                if (p.getName().equals(sigName)) continue;
                paramStr = paramStr + "             $sign_params[\"" + p.getName() + "\"] = $" + Util.getVariableName((String)p.getName()) + ";\n";
            }
            paramStr = paramStr + "             $" + Util.getVariableName((String)sigName) + " = " + this.getBean().getAuthenticatorClassName() + "::sign($sign_params);\n";
            methodBody = methodBody + paramStr;
        } else if (authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            methodBody = methodBody + INDENT + this.getBean().getAuthenticatorClassName() + "::login(" + this.getLoginArguments() + ");\n";
        }
        return methodBody;
    }

    public String getPostAuthenticationCode() {
        String methodBody = "";
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SIGNED_URL) {
            SaasBean.SignedUrlAuthentication signedUrl = (SaasBean.SignedUrlAuthentication)this.getBean().getAuthentication();
            List signParams = signedUrl.getParameters();
            if (signParams != null && signParams.size() > 0) {
                String paramStr = SaasClientPhpAuthenticationGenerator.getSignParamDeclaration(this.getBean(), signParams, this.getBean().getInputParameters());
                paramStr = paramStr + "             $sign_params = array();\n";
                for (ParameterInfo p : signParams) {
                    paramStr = paramStr + "             $sign_params[\"" + p.getName() + "\"] = $" + Util.getVariableName((String)p.getName()) + ";\n";
                }
                paramStr = paramStr + "             $" + Util.getVariableName((String)signedUrl.getSigKeyName()) + " = " + this.getBean().getAuthenticatorClassName() + "::sign($sign_params);\n";
                methodBody = methodBody + paramStr;
            }
        } else if (authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            String serviceName = "";
            try {
                serviceName = this.getSaasServiceFolder().getName();
            }
            catch (IOException ex) {
                // empty catch block
            }
            methodBody = methodBody + "             $username = " + this.getBean().getAuthenticatorClassName() + "::getSession(\"" + serviceName + "username\");\n";
            methodBody = methodBody + "             $password = " + this.getBean().getAuthenticatorClassName() + "::getSession(\"" + serviceName + "password\");\n";
            methodBody = methodBody + "             $conn->setAuthentication($username, $password);\n";
        }
        return methodBody;
    }

    public void createAuthenticatorClass() throws IOException {
        FileObject targetFolder;
        block11: {
            block10: {
                DataObject d;
                targetFolder = this.getSaasServiceFolder();
                if (this.getBean().isUseTemplates()) break block10;
                if (this.saasAuthFile != null) break block11;
                String authFileName = this.getBean().getAuthenticatorClassName();
                String authTemplate = null;
                Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
                if (authType == Constants.SaasAuthenticationType.API_KEY || authType == Constants.SaasAuthenticationType.HTTP_BASIC || authType == Constants.SaasAuthenticationType.SIGNED_URL || authType == Constants.SaasAuthenticationType.SESSION_KEY) {
                    authTemplate = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                }
                if (authTemplate == null || (d = Util.createDataObjectFromTemplate((String)(authTemplate + "Authenticator" + "." + "php"), (FileObject)targetFolder, (String)authFileName)) == null) break block11;
                this.saasAuthFile = d.getPrimaryFile();
                break block11;
            }
            SaasBean.SaasAuthentication.UseTemplates useTemplates = null;
            if (this.getBean().getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
                useTemplates = sessionKey.getUseTemplates();
            } else if (this.getBean().getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                SaasBean.HttpBasicAuthentication httpBasic = (SaasBean.HttpBasicAuthentication)this.getBean().getAuthentication();
                useTemplates = httpBasic.getUseTemplates();
            }
            if (useTemplates != null) {
                String dropType = this.getDropFileType().prefix();
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : useTemplates.getTemplates()) {
                    String fileName;
                    FileObject fobj;
                    if (!template.getDropTypeList().contains(dropType)) continue;
                    String id = template.getId();
                    String type = template.getType();
                    String templateUrl = template.getUrl();
                    if (!templateUrl.contains("Authenticator") || (fobj = targetFolder.getFileObject(fileName = this.getBean().getAuthenticatorClassName())) != null) continue;
                    Util.createDataObjectFromTemplate((String)templateUrl, (FileObject)targetFolder, (String)fileName);
                    HashMap<String, String> tokens = new HashMap<String, String>();
                    tokens.put("__GROUP__", targetFolder.getName());
                    SaasClientPhpAuthenticationGenerator.replaceTokens(targetFolder.getFileObject(fileName, "php"), tokens);
                }
            }
        }
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            String profileName = this.getBean().getAuthenticatorClassName() + "Profile";
            if (this.getAuthenticationProfile() != null && !this.getAuthenticationProfile().trim().equals("")) {
                try {
                    Util.createDataObjectFromTemplate((String)this.getAuthenticationProfile(), (FileObject)targetFolder, (String)profileName);
                }
                catch (Exception ex) {
                    throw new IOException("Profile file specified in saas-services/service-metadata/authentication/@profile, not found: " + this.getAuthenticationProfile());
                }
            }
        }
    }

    public void createAuthorizationClasses() throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            List filterParams = this.getAuthenticatorMethodParameters();
            String[] parameters = Util.getGetParamNames((List)filterParams);
            Object[] paramTypes = Util.getGetParamTypes((List)filterParams);
            SaasClientPhpAuthenticationGenerator.createSessionKeyAuthorizationClassesForWeb(this.getBean(), this.getProject(), this.getBean().getSaasName(), this.getBean().getSaasServicePackageName(), this.getSaasServiceFolder(), this.loginFile, this.callbackFile, parameters, paramTypes, this.getBean().isUseTemplates(), this.getDropFileType());
        }
    }

    public void modifyAuthenticationClass() throws IOException {
    }

    public void modifyAuthenticationClass(String comment, Object[] modifiers, Object returnType, String name, String[] parameters, Object[] paramTypes, Object[] throwList, String bodyText) throws IOException {
    }

    public String getLoginBody(SaasBean bean, String groupName, String paramVariableName) throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyLoginBodyForWeb((SaasBean)bean, (String)groupName, (String)paramVariableName);
        }
        String methodBody = "";
        return methodBody;
    }

    public String getLogoutBody() {
        String methodBody = "";
        return methodBody;
    }

    public String getTokenBody(SaasBean bean, String groupName, String paramVariableName, String saasServicePkgName) throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyTokenBodyForWeb((SaasBean)bean, (String)groupName, (String)paramVariableName, (String)saasServicePkgName);
        }
        String authFileName = this.getBean().getAuthorizationFrameClassName();
        String methodBody = "";
        return methodBody;
    }

    public String getSignParamUsage(List<ParameterInfo> signParams, String groupName) {
        return Util.getSignParamUsage(signParams, (String)groupName, (boolean)this.getBean().isDropTargetWeb());
    }

    public static String getSignParamDeclaration(SaasBean bean, List<ParameterInfo> signParams, List<ParameterInfo> filterParams) {
        String paramStr = "";
        for (ParameterInfo p : signParams) {
            String[] pIds = SaasClientPhpAuthenticationGenerator.getParamIds(p, bean.getSaasName(), bean.isDropTargetWeb());
            if (pIds != null) {
                paramStr = paramStr + "             $" + Util.getVariableName((String)pIds[0]) + " = " + pIds[1] + ";\n";
                continue;
            }
            if (Util.isContains((ParameterInfo)p, filterParams)) continue;
            paramStr = paramStr + "             $" + Util.getVariableName((String)p.getName()) + " = ";
            if (p.getFixed() != null) {
                paramStr = paramStr + "\"" + p.getFixed() + "\";\n";
                continue;
            }
            if (p.getType() == Date.class) {
                paramStr = paramStr + "$conn->getDate();\n";
                continue;
            }
            if (p.getType() == SaasBean.Time.class) {
                paramStr = paramStr + "RestConnection::currentTimeMillis();\n";
                continue;
            }
            if (p.getType() == Constants.HttpMethodType.class) {
                paramStr = paramStr + "\"" + bean.getHttpMethod().value() + "\";\n";
                continue;
            }
            if (p.isRequired()) {
                if (p.getDefaultValue() != null) {
                    paramStr = paramStr + SaasClientPhpAuthenticationGenerator.getQuotedValue(p.getDefaultValue().toString()) + ";\n";
                    continue;
                }
                paramStr = paramStr + "\"\";\n";
                continue;
            }
            if (p.getDefaultValue() != null) {
                paramStr = paramStr + SaasClientPhpAuthenticationGenerator.getQuotedValue(p.getDefaultValue().toString()) + ";\n";
                continue;
            }
            paramStr = paramStr + "null;\n";
        }
        paramStr = paramStr + "\n";
        return paramStr;
    }

    public static String getQuotedValue(String value) {
        String[] parts;
        StringBuffer sb = new StringBuffer();
        for (String part : parts = value.replace("+", "&plus;").split("&plus;")) {
            if (SaasClientPhpAuthenticationGenerator.isWord(part)) {
                sb.append("$" + part.trim() + ".");
                continue;
            }
            sb.append(part + ".");
        }
        String str = sb.toString();
        if (parts.length > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return Util.getQuotedValue((String)str);
    }

    public static boolean isWord(String part) {
        if (part == null || part.trim().equals("")) {
            return false;
        }
        String word = part.trim();
        for (char ch : word.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    public static String[] getParamIds(ParameterInfo p, String groupName, boolean isDropTargetWeb) {
        String[] pElems;
        if (p.getId() != null && (pElems = p.getId().split("=")).length == 2) {
            String val = pElems[1];
            if (val.startsWith("{")) {
                val = val.substring(1);
            }
            if (val.endsWith("}")) {
                val = val.substring(0, val.length() - 1);
            }
            val = Util.getVariableName((String)val);
            val = Util.getAuthenticatorClassName((String)groupName) + "::" + "get" + val.substring(0, 1).toUpperCase() + val.substring(1);
            val = val + "()";
            return new String[]{pElems[0], val};
        }
        return null;
    }

    public static void createSessionKeyAuthorizationClassesForWeb(SaasBean bean, Project project, String groupName, String saasServicePackageName, FileObject targetFolder, FileObject loginFile, FileObject callbackFile, String[] parameters, Object[] paramTypes, boolean isUseTemplates, Constants.DropFileType dropFileType) throws IOException {
        Constants.SaasAuthenticationType authType = bean.getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SESSION_KEY || authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            SaasBean.SaasAuthentication.UseTemplates useTemplates = null;
            if (bean.getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)bean.getAuthentication();
                useTemplates = sessionKey.getUseTemplates();
            } else if (bean.getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                SaasBean.HttpBasicAuthentication httpBasic = (SaasBean.HttpBasicAuthentication)bean.getAuthentication();
                useTemplates = httpBasic.getUseTemplates();
            }
            if (useTemplates != null) {
                String dropType = dropFileType.prefix();
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : useTemplates.getTemplates()) {
                    DataObject d;
                    if (!template.getDropTypeList().contains(dropType)) continue;
                    String id = template.getId();
                    String type = template.getType() == null ? "" : template.getType();
                    String templateUrl = template.getUrl();
                    if (templateUrl == null || templateUrl.trim().equals("")) {
                        throw new IOException("Authentication template is empty.");
                    }
                    if (templateUrl.contains("Desktop")) continue;
                    String fileName = null;
                    if (templateUrl.contains("Login")) {
                        fileName = bean.getSaasName() + Util.upperFirstChar((String)"login");
                    } else if (templateUrl.contains("Callback")) {
                        fileName = bean.getSaasName() + Util.upperFirstChar((String)"callback");
                    } else if (templateUrl.contains("Authenticator")) continue;
                    FileObject fObj = null;
                    if (fileName != null && (fObj = targetFolder.getFileObject(fileName)) == null && (d = Util.createDataObjectFromTemplate((String)templateUrl, (FileObject)targetFolder, (String)fileName)) != null) {
                        fObj = d.getPrimaryFile();
                        HashMap<String, String> tokens = new HashMap<String, String>();
                        tokens.put("__GROUP__", targetFolder.getName());
                        SaasClientPhpAuthenticationGenerator.replaceTokens(targetFolder.getFileObject(fileName, "php"), tokens);
                    }
                    if (fObj == null) continue;
                    if (type.equals("login")) {
                        loginFile = fObj;
                        continue;
                    }
                    if (!type.equals("callback")) continue;
                    callbackFile = fObj;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceTokens(FileObject fO, Map<String, String> tokens) throws IOException {
        FileLock lock = fO.lock();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fO)));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> e : tokens.entrySet()) {
                    String key = e.getKey();
                    String value = e.getValue();
                    line = line.replaceAll(key, value);
                }
                sb.append(line + "\n");
            }
            OutputStreamWriter writer = new OutputStreamWriter(fO.getOutputStream(lock), "UTF-8");
            try {
                writer.write(sb.toString());
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

