/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2SEProjectGenerator {
    private static final String loggerName = "org.netbeans.ui.metrics.j2se";
    private static final String loggerKey = "USG_PROJECT_CREATE_J2SE";
    private static SpecificationVersion defaultSourceLevel;
    private static final Pattern INVALID_NAME;

    private J2SEProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, final String name, final String mainClass, final String manifestFile, final String librariesDefinition) throws IOException {
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = J2SEProjectGenerator.createProject(dirFO, name, "src", "test", mainClass, manifestFile, manifestFile == null, librariesDefinition);
                J2SEProject p = (J2SEProject)ProjectManager.getDefault().findProject(dirFO);
                ProjectManager.getDefault().saveProject((Project)p);
                final ReferenceHelper refHelper = p.getReferenceHelper();
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            J2SEProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                FileObject srcFolder = dirFO.createFolder("src");
                dirFO.createFolder("test");
                if (mainClass != null) {
                    J2SEProjectGenerator.createMainClass(mainClass, srcFolder);
                }
            }
        });
        return h[0];
    }

    public static AntProjectHelper createProject(File dir, final String name, final File[] sourceFolders, final File[] testFolders, final String manifestFile, final String librariesDefinition, final String buildXmlName) throws IOException {
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        final FileObject dirFO = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                h[0] = J2SEProjectGenerator.createProject(dirFO, name, null, null, null, manifestFile, false, librariesDefinition);
                final J2SEProject p = (J2SEProject)ProjectManager.getDefault().findProject(dirFO);
                final ReferenceHelper refHelper = p.getReferenceHelper();
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            Element root;
                            EditableProperties props;
                            int rootIndex;
                            String propName;
                            int i;
                            Element data = h[0].getPrimaryConfigurationData(true);
                            Document doc = data.getOwnerDocument();
                            NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                            assert (nl.getLength() == 1);
                            Element sourceRoots = (Element)nl.item(0);
                            nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                            assert (nl.getLength() == 1);
                            Element testRoots = (Element)nl.item(0);
                            for (i = 0; i < sourceFolders.length; ++i) {
                                if (i == 0) {
                                    propName = "src.dir";
                                } else {
                                    String name = sourceFolders[i].getName();
                                    propName = name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = name + ++rootIndex + ".dir";
                                }
                                String srcReference = refHelper.createForeignFileReference(sourceFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                sourceRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, srcReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            for (i = 0; i < testFolders.length; ++i) {
                                if (!testFolders[i].exists()) {
                                    testFolders[i].mkdirs();
                                }
                                if (i == 0) {
                                    propName = "test.src.dir";
                                } else {
                                    String name = testFolders[i].getName();
                                    propName = "test." + name + ".dir";
                                }
                                rootIndex = 1;
                                props = h[0].getProperties("nbproject/project.properties");
                                while (props.containsKey((Object)propName)) {
                                    propName = "test." + name + ++rootIndex + ".dir";
                                }
                                String testReference = refHelper.createForeignFileReference(testFolders[i], "java");
                                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                                root.setAttribute("id", propName);
                                testRoots.appendChild(root);
                                props = h[0].getProperties("nbproject/project.properties");
                                props.put(propName, testReference);
                                h[0].putProperties("nbproject/project.properties", props);
                            }
                            h[0].putPrimaryConfigurationData(data, true);
                            if (buildXmlName != null) {
                                EditableProperties props2 = h[0].getProperties("nbproject/project.properties");
                                props2.put("buildfile", buildXmlName);
                                h[0].putProperties("nbproject/project.properties", props2);
                            }
                            ProjectManager.getDefault().saveProject((Project)p);
                            J2SEProjectGenerator.copyRequiredLibraries(h[0], refHelper);
                            ProjectUtils.getSources((Project)p).getSourceGroups("java");
                            return null;
                        }
                    });
                }
                catch (MutexException me) {
                    ErrorManager.getDefault().notify((Throwable)me);
                }
            }
        });
        return h[0];
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, String srcRoot, String testRoot, String mainClass, String manifestFile, boolean isLibrary, String librariesDefinition) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2seproject", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + J2SEProjectGenerator.validatePropertyValue(name) + ".jar");
        ep.setProperty("javac.classpath", new String[0]);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}"});
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        if (!isLibrary) {
            ep.setProperty("main.class", mainClass == null ? "" : mainClass);
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        SpecificationVersion sourceLevel = J2SEProjectGenerator.getDefaultSourceLevel();
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}:", "${libs.junit_4.classpath}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("run.jvmargs", "");
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("compile.on.save", "true");
        h.putProperties("nbproject/private/private.properties", ep);
        J2SEProjectGenerator.logUsage();
        return h;
    }

    private static void logUsage() {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        Logger.getLogger(loggerName).log(logRecord);
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        if (rh.getProjectLibraryManager().getLibrary("CopyLibs") == null && LibraryManager.getDefault().getLibrary("CopyLibs") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
        }
    }

    private static void createMainClass(String mainClassName, FileObject srcFolder) throws IOException {
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)"Templates/Classes/Main.java");
        if (mainTemplate == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static SpecificationVersion getDefaultSourceLevel() {
        if (defaultSourceLevel != null) {
            return defaultSourceLevel;
        }
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion v = defaultPlatform.getSpecification().getVersion();
        if (v.equals((Object)new SpecificationVersion("1.6")) || v.equals((Object)new SpecificationVersion("1.7"))) {
            return new SpecificationVersion("1.5");
        }
        return v;
    }

    private static String validatePropertyValue(String value) {
        Matcher m = INVALID_NAME.matcher(value);
        if (m.find()) {
            value = m.replaceAll("_");
        }
        return value;
    }

    public static void setDefaultSourceLevel(SpecificationVersion version) {
        defaultSourceLevel = version;
    }

    static {
        INVALID_NAME = Pattern.compile("[$/\\\\\\p{Cntrl}]");
    }
}

