/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.signature;

import com.sun.jersey.oauth.signature.Base64;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignatureMethod;
import com.sun.jersey.oauth.signature.URLCodec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMAC_SHA1
implements OAuthSignatureMethod {
    public static final String NAME = "HMAC-SHA1";
    private static final String SIGNATURE_ALGORITHM = "HmacSHA1";

    public String name() {
        return NAME;
    }

    public String sign(String elements, OAuthSecrets secrets) {
        byte[] key;
        Mac mac;
        try {
            mac = Mac.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        StringBuffer buf = new StringBuffer();
        String secret = secrets.getConsumerSecret();
        if (secret != null) {
            buf.append(URLCodec.encode(secret));
        }
        buf.append('&');
        secret = secrets.getTokenSecret();
        if (secret != null) {
            buf.append(URLCodec.encode(secret));
        }
        try {
            key = buf.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
        SecretKeySpec spec = new SecretKeySpec(key, SIGNATURE_ALGORITHM);
        try {
            mac.init(spec);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        return Base64.encode(mac.doFinal(elements.getBytes()));
    }

    public boolean verify(String elements, OAuthSecrets secrets, String signature) {
        return this.sign(elements, secrets).equals(signature);
    }
}

