/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OperationPanel
extends JPanel {
    static final String RUN_ACTION = "run-action";
    static final String RUN_IN_BACKGROUND = "run-in-background";
    private ButtonGroup bgRestartButtons;
    private JCheckBox cbRunInBackground;
    private JLabel lDetailLabel;
    private JLabel lMainLabel;
    private JPanel pAboveSpace;
    private JPanel pProgress;
    private JProgressBar pbPlaceHolder;
    private JRadioButton rbRestartLater;
    private JRadioButton rbRestartNow;

    public OperationPanel(boolean allowRunInBackground) {
        this.initComponents();
        this.rbRestartNow.setSelected(true);
        this.cbRunInBackground.setVisible(allowRunInBackground);
        if (allowRunInBackground) {
            this.cbRunInBackground.setSelected(false);
        }
        this.setRestartButtonsVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OperationPanel.this.firePropertyChange(OperationPanel.RUN_ACTION, null, Boolean.TRUE);
            }
        }, 200);
    }

    public void waitAndSetProgressComponents(final JLabel mainLabel, final JComponent progressComponent, final JLabel detailLabel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponents(mainLabel, progressComponent, detailLabel);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationPanel.this.setProgressComponents(mainLabel, progressComponent, detailLabel);
                }
            });
        }
    }

    public void setRestartButtonsVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rbRestartLater.setVisible(visible);
            this.rbRestartNow.setVisible(visible);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationPanel.this.rbRestartLater.setVisible(visible);
                    OperationPanel.this.rbRestartNow.setVisible(visible);
                }
            });
        }
    }

    public boolean restartNow() {
        return this.rbRestartNow.isSelected();
    }

    public void hideRunInBackground() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cbRunInBackground.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationPanel.this.cbRunInBackground.setVisible(false);
                }
            });
        }
    }

    private void setProgressComponents(JLabel mainLabel, JComponent progressComponent, JLabel detailLabel) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        mainLabel.setPreferredSize(new Dimension(0, 20));
        detailLabel.setPreferredSize(new Dimension(0, 20));
        progressComponent.setPreferredSize(new Dimension(0, 20));
        this.pProgress.removeAll();
        this.pProgress.add((Component)mainLabel, "North");
        this.pProgress.add((Component)progressComponent, "Center");
        this.pProgress.add((Component)detailLabel, "South");
        this.pAboveSpace.setVisible(true);
        this.revalidate();
    }

    public void setBody(final String msg, final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBodyInEQ(msg, text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationPanel.this.setBodyInEQ(msg, text);
                }
            });
        }
    }

    public void setBody(final String msg, Set<UpdateElement> updateElements) {
        final ArrayList<UpdateElement> elements = new ArrayList<UpdateElement>(updateElements);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBodyInEQ(msg, elements);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OperationPanel.this.setBodyInEQ(msg, elements);
                }
            });
        }
    }

    private void setBodyInEQ(String msg, List<UpdateElement> elements) {
        this.pProgress.removeAll();
        this.pProgress.add((Component)this.getTitleComponent(msg), "North");
        this.pProgress.add((Component)this.getElementsComponent(elements), "Center");
        this.pAboveSpace.setVisible(false);
        this.revalidate();
    }

    private void setBodyInEQ(String msg, String elements) {
        this.pProgress.removeAll();
        this.pProgress.add((Component)this.getTitleComponent(msg), "North");
        this.pProgress.add((Component)this.getElementsComponent(elements), "Center");
        this.pAboveSpace.setVisible(false);
        this.revalidate();
    }

    private JComponent getTitleComponent(String msg) {
        JTextArea area = new JTextArea(msg);
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        area.setEditable(false);
        area.setOpaque(false);
        return area;
    }

    private JComponent getElementsComponent(List<UpdateElement> elements) {
        StringBuilder body = new StringBuilder();
        for (UpdateElement el : elements) {
            body.append(el.getDisplayName() + "<br>");
        }
        return this.getElementsComponent(body.toString());
    }

    private JComponent getElementsComponent(String msg) {
        JTextPane area = new JTextPane();
        area.setEditable(false);
        area.setContentType("text/html");
        area.setText(msg);
        area.setOpaque(false);
        return area;
    }

    private void initComponents() {
        this.bgRestartButtons = new ButtonGroup();
        this.pAboveSpace = new JPanel();
        this.pProgress = new JPanel();
        this.pbPlaceHolder = new JProgressBar();
        this.lMainLabel = new JLabel();
        this.lDetailLabel = new JLabel();
        this.rbRestartNow = new JRadioButton();
        this.rbRestartLater = new JRadioButton();
        this.cbRunInBackground = new JCheckBox();
        this.pAboveSpace.setOpaque(false);
        GroupLayout pAboveSpaceLayout = new GroupLayout(this.pAboveSpace);
        this.pAboveSpace.setLayout(pAboveSpaceLayout);
        pAboveSpaceLayout.setHorizontalGroup(pAboveSpaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 157, Short.MAX_VALUE));
        pAboveSpaceLayout.setVerticalGroup(pAboveSpaceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 65, Short.MAX_VALUE));
        this.pProgress.setLayout(new BorderLayout());
        this.pbPlaceHolder.setPreferredSize(new Dimension(0, 20));
        this.pProgress.add((Component)this.pbPlaceHolder, "Center");
        this.pProgress.add((Component)this.lMainLabel, "North");
        this.pProgress.add((Component)this.lDetailLabel, "South");
        this.bgRestartButtons.add(this.rbRestartNow);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartNow, (String)NbBundle.getMessage(OperationPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartNow"));
        this.rbRestartNow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationPanel.this.rbRestartNowActionPerformed(evt);
            }
        });
        this.bgRestartButtons.add(this.rbRestartLater);
        Mnemonics.setLocalizedText((AbstractButton)this.rbRestartLater, (String)NbBundle.getMessage(OperationPanel.class, (String)"InstallUnitWizardModel_Buttons_RestartLater"));
        this.rbRestartLater.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRestartLater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationPanel.this.rbRestartLaterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbRunInBackground, (String)NbBundle.getMessage(OperationPanel.class, (String)"OperationPanel.cbRunInBackground.text"));
        this.cbRunInBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationPanel.this.cbRunInBackgroundActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pProgress, -1, 157, Short.MAX_VALUE).addComponent(this.pAboveSpace, -1, -1, Short.MAX_VALUE).addComponent(this.cbRunInBackground).addComponent(this.rbRestartNow, -1, 157, Short.MAX_VALUE).addComponent(this.rbRestartLater, -1, 157, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pAboveSpace, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pProgress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRunInBackground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbRestartNow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbRestartLater).addContainerGap(45, Short.MAX_VALUE)));
    }

    private void rbRestartLaterActionPerformed(ActionEvent evt) {
    }

    private void rbRestartNowActionPerformed(ActionEvent evt) {
    }

    private void cbRunInBackgroundActionPerformed(ActionEvent evt) {
        this.firePropertyChange(RUN_IN_BACKGROUND, null, Boolean.TRUE);
    }
}

