/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.repository.dependency.AddAsDependencyAction;
import org.openide.actions.CopyAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class VersionNode
extends AbstractNode {
    private static final String JAVADOC_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png";
    private static final String SOURCE_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencySrcIncluded.png";
    private NBVersionInfo record;
    private boolean hasJavadoc;
    private boolean hasSources;
    private RepositoryInfo info;
    private static String toolTipJavadoc = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_JavadocBadge");
    private static String toolTipSource = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_SourceBadge");

    public static Children createChildren(RepositoryInfo repositoryInfo, NBVersionInfo nBVersionInfo) {
        if (repositoryInfo.isLocal() && !"pom".equals(nBVersionInfo.getType())) {
            try {
                Artifact artifact = RepositoryUtil.createArtifact((NBVersionInfo)nBVersionInfo);
                FileObject fileObject = FileUtil.toFileObject((File)FileUtilities.convertArtifactToLocalRepositoryFile((Artifact)artifact));
                if (fileObject != null) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    return new FilterNode.Children(dataObject.getNodeDelegate().cloneNode());
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return Children.LEAF;
    }

    public VersionNode(RepositoryInfo repositoryInfo, NBVersionInfo nBVersionInfo, boolean bl, boolean bl2, boolean bl3) {
        super(VersionNode.createChildren(repositoryInfo, nBVersionInfo));
        this.info = repositoryInfo;
        this.hasJavadoc = bl;
        this.hasSources = bl2;
        this.record = nBVersionInfo;
        if (bl3) {
            this.setName(nBVersionInfo.getVersion());
            this.setDisplayName(nBVersionInfo.getVersion() + " [ " + (nBVersionInfo.getType() != null ? nBVersionInfo.getType() : "jar") + (nBVersionInfo.getClassifier() != null ? "," + nBVersionInfo.getClassifier() : "") + " ]");
        } else {
            this.setName(nBVersionInfo.getGroupId() + ":" + nBVersionInfo.getArtifactId() + ":" + nBVersionInfo.getVersion());
        }
        this.setIconBaseWithExtension("org/netbeans/modules/maven/repository/DependencyJar.gif");
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable transferable = super.clipboardCopy();
        ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
        ExTransferable.Single single = new ExTransferable.Single(DataFlavor.stringFlavor){

            protected Object getData() {
                return "<dependency>\n  <groupId>" + VersionNode.this.record.getGroupId() + "</groupId>\n" + "  <artifactId>" + VersionNode.this.record.getArtifactId() + "</artifactId>\n" + "  <version>" + VersionNode.this.record.getVersion() + "</version>\n" + "</dependency>";
            }
        };
        exTransferable.put(single);
        return exTransferable;
    }

    public Action[] getActions(boolean bl) {
        Artifact artifact = RepositoryUtil.createArtifact((NBVersionInfo)this.record);
        Action[] actionArray = this.info.isRemoteDownloadable() ? new Action[]{new ShowArtifactAction(this.record), new AddAsDependencyAction(artifact), CommonArtifactActions.createFindUsages((Artifact)artifact), null, CopyAction.get(CopyAction.class)} : new Action[]{new ShowArtifactAction(this.record), new AddAsDependencyAction(artifact), CommonArtifactActions.createFindUsages((Artifact)artifact), CommonArtifactActions.createViewJavadocAction((Artifact)artifact), null, CopyAction.get(CopyAction.class)};
        return actionArray;
    }

    public Action getPreferredAction() {
        return new ShowArtifactAction(this.record);
    }

    public Image getIcon(int n) {
        Image image;
        Image image2 = super.getIcon(n);
        if (this.hasJavadoc) {
            image = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
            image = ImageUtilities.addToolTipToImage((Image)image, (String)toolTipJavadoc);
            image2 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)12, (int)0);
        }
        if (this.hasSources) {
            image = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
            image = ImageUtilities.addToolTipToImage((Image)image, (String)toolTipSource);
            image2 = ImageUtilities.mergeImages((Image)image2, (Image)image, (int)12, (int)8);
        }
        return image2;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.record != null) {
            stringBuffer.append("<html>").append(NbBundle.getMessage(VersionNode.class, (String)"TXT_GroupId")).append("<b>").append(this.record.getGroupId()).append("</b><p>");
            stringBuffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_ArtifactId")).append("<b>").append(this.record.getArtifactId()).append("</b><p>");
            stringBuffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Version")).append("<b>").append(this.record.getVersion().toString()).append("</b><p>");
            stringBuffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Packaging")).append("<b>").append(this.record.getPackaging()).append("</b><p>");
            stringBuffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Name")).append(this.record.getProjectName()).append("<p>");
        }
        return stringBuffer.toString();
    }

    private static class ShowArtifactAction
    extends AbstractAction {
        private NBVersionInfo info;

        ShowArtifactAction(NBVersionInfo nBVersionInfo) {
            this.info = nBVersionInfo;
            this.putValue("Name", NbBundle.getMessage(VersionNode.class, (String)"ACT_View_Details"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArtifactViewer.showArtifactViewer((NBVersionInfo)this.info);
        }
    }
}

