/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentSerializationSupport {
    public static void refreshDescriptorRegistry(String projectType) {
        DataFolder producersFolder;
        GlobalDescriptorRegistry registry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType);
        DataFolder registryFolder = registry.getRegistryFolder();
        if (registryFolder != null) {
            registryFolder.getPrimaryFile().refresh(true);
        }
        if ((producersFolder = registry.getProducersFolder()) != null) {
            producersFolder.getPrimaryFile().refresh(true);
        }
        registry.reload();
    }

    public static void runUnderDescriptorRegistryReadAccess(String projectType, Runnable runnable) {
        GlobalDescriptorRegistry registry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType);
        registry.readAccess(runnable);
    }

    public static void runUnderDescriptorRegistryWriteAccess(String projectType, Runnable runnable) {
        GlobalDescriptorRegistry registry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType);
        registry.writeAccess(runnable);
    }

    public static void serialize(String projectType, TypeDescriptor typeDescriptor, PaletteDescriptor paletteDescriptor, List<PropertyDescriptor> properties, List<PresenterSerializer> presenters) {
        assert (projectType != null && typeDescriptor != null && properties != null && presenters != null);
        ComponentSerializationSupport.serializeComponentDescriptor(projectType, typeDescriptor, null, properties, presenters);
        if (typeDescriptor.isCanInstantiate()) {
            ComponentSerializationSupport.serializeComponentProducer(projectType, typeDescriptor.getThisType(), paletteDescriptor);
        }
    }

    private static void serializeComponentDescriptor(String projectType, TypeDescriptor typeDescriptor, PaletteDescriptor paletteDescriptor, List<PropertyDescriptor> properties, List<PresenterSerializer> presenters) {
        Document document = XMLUtil.createDocument((String)"ComponentDescriptor", null, null, null);
        Node rootNode = document.getFirstChild();
        ComponentSerializationSupport.setAttribute(document, rootNode, "version", "1");
        Element typeNode = document.createElement("TypeDescriptor");
        if (typeDescriptor.getSuperType() != null) {
            ComponentSerializationSupport.setAttribute(document, typeNode, "superTypeID", typeDescriptor.getSuperType().toString());
        }
        ComponentSerializationSupport.setAttribute(document, typeNode, "thisTypeID", typeDescriptor.getThisType().toString());
        ComponentSerializationSupport.setAttribute(document, typeNode, "canDerive", Boolean.toString(typeDescriptor.isCanDerive()));
        ComponentSerializationSupport.setAttribute(document, typeNode, "canInstantiate", Boolean.toString(typeDescriptor.isCanInstantiate()));
        rootNode.appendChild(typeNode);
        if (paletteDescriptor != null) {
            Element paletteNode = document.createElement("PaletteDescriptor");
            ComponentSerializationSupport.setAttribute(document, paletteNode, "displayName", paletteDescriptor.getDisplayName());
            if (paletteDescriptor.getToolTip() != null) {
                ComponentSerializationSupport.setAttribute(document, paletteNode, "toolTip", paletteDescriptor.getToolTip());
            }
            if (paletteDescriptor.getCategoryID() != null) {
                ComponentSerializationSupport.setAttribute(document, paletteNode, "preferredCategoryID", paletteDescriptor.getCategoryID());
            }
            if (paletteDescriptor.getSmallIcon() != null) {
                ComponentSerializationSupport.setAttribute(document, paletteNode, "smallIcon", paletteDescriptor.getSmallIcon());
            }
            if (paletteDescriptor.getLargeIcon() != null) {
                ComponentSerializationSupport.setAttribute(document, paletteNode, "largeIcon", paletteDescriptor.getLargeIcon());
            }
            rootNode.appendChild(paletteNode);
        }
        for (PropertyDescriptor propertyDescriptor : properties) {
            assert (propertyDescriptor != null);
            Element propertyNode = document.createElement("PropertyDescriptor");
            ComponentSerializationSupport.setAttribute(document, propertyNode, "name", propertyDescriptor.getName());
            ComponentSerializationSupport.setAttribute(document, propertyNode, "typeID", propertyDescriptor.getType().toString());
            String userCode = propertyDescriptor.getDefaultValue().getUserCode();
            if (userCode != null) {
                ComponentSerializationSupport.setAttribute(document, propertyNode, "defaultValue", userCode);
            }
            ComponentSerializationSupport.setAttribute(document, propertyNode, "allowNull", Boolean.toString(propertyDescriptor.isAllowNull()));
            ComponentSerializationSupport.setAttribute(document, propertyNode, "allowUserCode", Boolean.toString(propertyDescriptor.isAllowUserCode()));
            ComponentSerializationSupport.setAttribute(document, propertyNode, "useForSerialization", Boolean.toString(propertyDescriptor.isUseForSerialization()));
            ComponentSerializationSupport.setAttribute(document, propertyNode, "readOnly", Boolean.toString(propertyDescriptor.isReadOnly()));
            rootNode.appendChild(propertyNode);
        }
        Element presentersNode = document.createElement("Presenters");
        for (PresenterSerializer serializer : presenters) {
            List<Element> nodes = serializer.serialize(document);
            if (nodes == null) continue;
            for (Element node : nodes) {
                if (node == null) continue;
                presentersNode.appendChild(node);
            }
        }
        rootNode.appendChild(presentersNode);
        GlobalDescriptorRegistry registry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType);
        DataFolder registryFolder = registry.getRegistryFolder();
        if (!ComponentSerializationSupport.writeDocument(registryFolder.getPrimaryFile(), typeDescriptor.getThisType().toString(), "xml", document)) {
            Debug.warning("Error while serializing a component descriptor", typeDescriptor.getThisType().toString());
        }
    }

    private static void serializeComponentProducer(String projectType, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        GlobalDescriptorRegistry registry;
        DataFolder producersFolder;
        Document document = XMLUtil.createDocument((String)"ComponentProducer", null, null, null);
        Node rootNode = document.getFirstChild();
        ComponentSerializationSupport.setAttribute(document, rootNode, "version", "1");
        ComponentSerializationSupport.setAttribute(document, rootNode, "producerID", typeID.toString());
        ComponentSerializationSupport.setAttribute(document, rootNode, "mainComponentTypeID", typeID.toString());
        ComponentSerializationSupport.setAttribute(document, rootNode, "displayName", paletteDescriptor.getDisplayName());
        if (paletteDescriptor.getToolTip() != null) {
            ComponentSerializationSupport.setAttribute(document, rootNode, "toolTip", paletteDescriptor.getToolTip());
        }
        if (paletteDescriptor.getCategoryID() != null) {
            ComponentSerializationSupport.setAttribute(document, rootNode, "preferredCategoryID", paletteDescriptor.getCategoryID());
        }
        if (paletteDescriptor.getSmallIcon() != null) {
            ComponentSerializationSupport.setAttribute(document, rootNode, "smallIcon", paletteDescriptor.getSmallIcon());
        }
        if (paletteDescriptor.getLargeIcon() != null) {
            ComponentSerializationSupport.setAttribute(document, rootNode, "largeIcon", paletteDescriptor.getLargeIcon());
        }
        if (!ComponentSerializationSupport.writeDocument((producersFolder = (registry = GlobalDescriptorRegistry.getGlobalDescriptorRegistry(projectType)).getProducersFolder()).getPrimaryFile(), typeID.toString(), "xml", document)) {
            Debug.warning("Error while serializing a component producer", typeID.toString());
        }
    }

    private static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }

    public static boolean writeDocument(final FileObject folder, final String filename, final String ext, final Document doc) {
        try {
            folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject file = folder.getFileObject(filename, ext);
                    if (file == null) {
                        file = folder.createData(filename, ext);
                    }
                    ComponentSerializationSupport.writeDocument(file, doc);
                }
            });
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(FileObject file, Document doc) throws IOException {
        if (file == null) {
            throw new IOException("Null file to write document");
        }
        if (doc == null) {
            throw new IOException("Empty document is about to save");
        }
        OutputStream os = null;
        FileLock lock = null;
        try {
            lock = file.lock();
            os = file.getOutputStream(lock);
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

