/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.SiteDocsNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public class SiteDocsNodeFactory
implements NodeFactory {
    private static final String KEY_SITE = "SITE";
    private static final String SITE = "src/site";

    public NodeList createNodes(Project project) {
        NbMavenProjectImpl prj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(prj);
    }

    private static class NList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;

        private NList(NbMavenProjectImpl prj) {
            this.project = prj;
        }

        public List<String> keys() {
            if (this.project.getProjectDirectory().getFileObject(SiteDocsNodeFactory.SITE) != null) {
                return Collections.singletonList(SiteDocsNodeFactory.KEY_SITE);
            }
            return Collections.emptyList();
        }

        public Node node(String key) {
            return this.createSiteDocsNode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.fireChange();
            }
            if ("RESOURCES".equals(evt.getPropertyName()) && SiteDocsNodeFactory.SITE.equals(evt.getNewValue())) {
                this.fireChange();
            }
        }

        @Override
        public void addNotify() {
            NbMavenProject.addPropertyChangeListener(this.project, this);
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watcher.addWatchedPath(SiteDocsNodeFactory.SITE);
        }

        @Override
        public void removeNotify() {
            NbMavenProject.removePropertyChangeListener(this.project, this);
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watcher.removeWatchedPath(SiteDocsNodeFactory.SITE);
        }

        private Node createSiteDocsNode() {
            DataFolder fold;
            SiteDocsNode n = null;
            FileObject fo = this.project.getProjectDirectory().getFileObject(SiteDocsNodeFactory.SITE);
            if (fo != null && (fold = DataFolder.findFolder((FileObject)fo)) != null) {
                n = new SiteDocsNode(this.project, fold.getNodeDelegate().cloneNode());
            }
            return n;
        }
    }
}

