/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParser;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;

public class Parser {
    private final Ruby runtime;
    private volatile long totalTime;
    private volatile int totalBytes;

    public Parser(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public Node parse(String file2, ByteList content, DynamicScope blockScope, ParserConfiguration configuration) {
        return this.parse(file2, content.bytes(), blockScope, configuration);
    }

    public Node parse(String file2, byte[] content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyArray list2 = this.getLines(configuration, this.runtime, file2);
        LexerSource lexerSource = LexerSource.getSource(file2, content, (List<String>)list2, configuration);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    public Node parse(String file2, InputStream content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyArray list2 = this.getLines(configuration, this.runtime, file2);
        if (content instanceof LoadServiceResourceInputStream) {
            return this.parse(file2, ((LoadServiceResourceInputStream)content).getBytes(), blockScope, configuration);
        }
        LexerSource lexerSource = LexerSource.getSource(file2, content, (List<String>)list2, configuration);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    public Node parse(String file2, LexerSource lexerSource, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyParserResult result;
        long startTime;
        block10: {
            if (blockScope != null) {
                configuration.parseAsBlock(blockScope);
            }
            startTime = System.nanoTime();
            RubyParser parser = RubyParserPool.getInstance().borrowParser(configuration.getVersion());
            result = null;
            parser.setWarnings(this.runtime.getWarnings());
            try {
                result = parser.parse(configuration, lexerSource);
                if (result.getEndOffset() < 0) break block10;
                IRubyObject verbose = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                try {
                    this.runtime.defineGlobalConstant("DATA", new RubyFile(this.runtime, file2, lexerSource.getRemainingAsStream()));
                }
                catch (IOException e) {
                    this.runtime.defineGlobalConstant("DATA", this.runtime.getNil());
                }
                this.runtime.setVerbose(verbose);
                result.setEndOffset(-1);
            }
            catch (IOException e) {
                throw this.runtime.newSyntaxError("Problem reading source: " + e);
            }
            catch (SyntaxException e) {
                StringBuilder buffer = new StringBuilder(100);
                buffer.append(e.getPosition().getFile()).append(':');
                buffer.append(e.getPosition().getStartLine() + 1).append(": ");
                buffer.append(e.getMessage());
                throw this.runtime.newSyntaxError(buffer.toString());
            }
            finally {
                RubyParserPool.getInstance().returnParser(parser);
            }
        }
        if (result.getScope() != null) {
            result.getScope().growIfNeeded();
        }
        Node ast = result.getAST();
        this.totalTime += System.nanoTime() - startTime;
        this.totalBytes += lexerSource.getOffset();
        return ast;
    }

    private RubyArray getLines(ParserConfiguration configuration, Ruby runtime2, String file2) {
        RubyArray list2 = null;
        IRubyObject scriptLines = runtime2.getObject().fastGetConstantAt("SCRIPT_LINES__");
        if (!configuration.isEvalParse() && scriptLines != null && scriptLines instanceof RubyHash) {
            RubyString filename2 = runtime2.newString(file2);
            ThreadContext context = runtime2.getCurrentContext();
            IRubyObject object = ((RubyHash)scriptLines).op_aref(context, filename2);
            list2 = (RubyArray)(object instanceof RubyArray ? object : runtime2.newArray());
            ((RubyHash)scriptLines).op_aset(context, filename2, list2);
        }
        return list2;
    }
}

