/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import org.jruby.compiler.ir.OpType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operation {
    COPY(OpType.dont_care),
    SET_RETADDR(OpType.dont_care),
    LINE_NUM(OpType.debug_op),
    FILE_NAME(OpType.debug_op),
    NOT(OpType.alu_op),
    RETURN(OpType.ret_op),
    CLOSURE_RETURN(OpType.ret_op),
    RECV_ARG(OpType.recv_arg_op),
    RECV_CLOSURE(OpType.recv_arg_op),
    RECV_OPT_ARG(OpType.recv_arg_op),
    RECV_CLOSURE_ARG(OpType.recv_arg_op),
    RECV_EXCEPTION(OpType.recv_arg_op),
    CALL(OpType.call_op),
    JRUBY_IMPL(OpType.call_op),
    RUBY_INTERNALS(OpType.call_op),
    DECLARE_TYPE(OpType.declare_type_op),
    YIELD(OpType.dont_care),
    DEF_INST_METH(OpType.dont_care),
    DEF_CLASS_METH(OpType.dont_care),
    THROW(OpType.exc_op),
    RESCUE_BODY_START(OpType.dont_care),
    RESCUE_BODY_END(OpType.dont_care),
    RETRY(OpType.dont_care),
    GET_CONST(OpType.load_op),
    GET_GLOBAL_VAR(OpType.load_op),
    GET_FIELD(OpType.load_op),
    GET_CVAR(OpType.load_op),
    GET_ARRAY(OpType.load_op),
    FRAME_LOAD(OpType.load_op),
    PUT_CONST(OpType.store_op),
    PUT_GLOBAL_VAR(OpType.store_op),
    PUT_FIELD(OpType.store_op),
    PUT_ARRAY(OpType.store_op),
    PUT_CVAR(OpType.store_op),
    FRAME_STORE(OpType.store_op),
    BREAK(OpType.branch_op),
    JUMP(OpType.branch_op),
    JUMP_INDIRECT(OpType.branch_op),
    BEQ(OpType.branch_op),
    ATTR_ASSIGN(OpType.dont_care),
    BUILD_CLOSURE(OpType.dont_care),
    ALLOC_FRAME(OpType.dont_care),
    LABEL(OpType.dont_care),
    THREAD_POLL(OpType.dont_care),
    IS_TRUE(OpType.dont_care),
    EQQ(OpType.dont_care),
    CASE(OpType.dont_care),
    ASSERT_METHOD_VERSION(OpType.guard_op);

    private OpType _type;

    private Operation(OpType t) {
        this._type = t;
    }

    public boolean isALU() {
        return this._type == OpType.alu_op;
    }

    public boolean isBranch() {
        return this._type == OpType.branch_op;
    }

    public boolean isLoad() {
        return this._type == OpType.load_op;
    }

    public boolean isStore() {
        return this._type == OpType.store_op;
    }

    public boolean isCall() {
        return this._type == OpType.call_op;
    }

    public boolean isEval() {
        return this._type == OpType.eval_op;
    }

    public boolean isReturn() {
        return this._type == OpType.ret_op;
    }

    public boolean isException() {
        return this._type == OpType.exc_op;
    }

    public boolean isArgReceive() {
        return this._type == OpType.recv_arg_op;
    }

    public boolean startsBasicBlock() {
        return this == LABEL;
    }

    public boolean endsBasicBlock() {
        return this.isBranch() || this.isReturn() || this.isException();
    }

    public boolean hasSideEffects() {
        return this.isCall() || this.isEval() || this.isStore() || this.isReturn();
    }
}

