/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.lexer.LexUtilities;

public abstract class AstElement
extends RubyElement {
    protected Node node;
    protected ParserResult info;
    protected ArrayList<AstElement> children;
    protected String name;
    private String in;
    protected Set<Modifier> modifiers;
    private RubyType type;
    private boolean hidden;

    public AstElement(ParserResult info, Node node) {
        this.info = info;
        this.node = node;
        this.type = RubyType.unknown();
    }

    public String getFqn() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public static AstElement create(ParserResult info, Node node) {
        switch (node.getNodeType()) {
            case DEFNNODE: 
            case DEFSNODE: {
                return new AstMethodElement(info, node);
            }
            case CLASSNODE: 
            case SCLASSNODE: {
                return new AstClassElement(info, node);
            }
            case MODULENODE: {
                return new AstModuleElement(info, node);
            }
            case CONSTNODE: {
                return new AstNameElement(info, node, ((INameNode)node).getName(), ElementKind.VARIABLE);
            }
            case CLASSVARNODE: 
            case CLASSVARDECLNODE: 
            case INSTASGNNODE: 
            case INSTVARNODE: {
                return new AstFieldElement(info, node);
            }
            case CONSTDECLNODE: {
                return new AstNameElement(info, node, ((INameNode)node).getName(), ElementKind.CONSTANT);
            }
            case SYMBOLNODE: {
                return new AstAttributeElement(info, (SymbolNode)node, null);
            }
        }
        return null;
    }

    public String toString() {
        String clz = this.getClass().getName();
        return clz.substring(0, clz.lastIndexOf(46)) + ":" + this.node.toString();
    }

    public Image getIcon() {
        return null;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    public void setIn(String in) {
        this.in = in;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public ParserResult getInfo() {
        return this.info;
    }

    public void setType(RubyType type) {
        assert (type != null) : "Cannot pass null to AstElement#setTypes";
        this.type = type;
    }

    @Override
    public RubyType getType() {
        return this.type;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult result) {
        RubyParseResult parserResult = AstUtilities.getParseResult((Parser.Result)result);
        RubyElement object = RubyParser.resolveHandle(parserResult, this);
        if (object instanceof AstElement) {
            Node target = ((AstElement)object).getNode();
            if (target != null) {
                OffsetRange range = AstUtilities.getRange(this.node);
                return LexUtilities.getLexerOffsets((Parser.Result)parserResult, range);
            }
            return OffsetRange.NONE;
        }
        if (object != null) {
            Logger logger = Logger.getLogger(AstElement.class.getName());
            logger.log(Level.WARNING, "Foreign element: " + object + " of type " + (object != null ? object.getClass().getName() : "null"));
        } else if (this.getNode() != null) {
            OffsetRange astRange = AstUtilities.getRange(this.getNode());
            if (astRange != OffsetRange.NONE) {
                ParserResult oldInfo = this.info;
                if (oldInfo == null) {
                    oldInfo = parserResult;
                }
                return LexUtilities.getLexerOffsets((Parser.Result)oldInfo, astRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

