/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OverridingMethods;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.RubyDeclarationFinderHelper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.MethodElement;

final class OverridingMethodsImpl
implements OverridingMethods {
    private final Map<ParserResult, Cache> cacheHolder = new HashMap<ParserResult, Cache>(1);

    public Collection<? extends DeclarationFinder.AlternativeLocation> overrides(ParserResult info, ElementHandle handle) {
        if (handle.getKind() == ElementKind.METHOD) {
            MethodElement methodElement = (MethodElement)handle;
            for (IndexedMethod each : this.getInheritedMethods(methodElement.getIn(), info)) {
                if (!methodElement.getName().equals(each.getName())) continue;
                return OverridingMethodsImpl.asLocations(Collections.singleton(each));
            }
        }
        return null;
    }

    public boolean isOverriddenBySupported(ParserResult info, ElementHandle handle) {
        return true;
    }

    public Collection<? extends DeclarationFinder.AlternativeLocation> overriddenBy(ParserResult info, ElementHandle handle) {
        if (handle.getKind() == ElementKind.CLASS) {
            ClassElement classElement = (ClassElement)handle;
            return OverridingMethodsImpl.asLocations(this.getSubclasses(classElement.getFqn(), info));
        }
        if (handle.getKind() == ElementKind.METHOD) {
            MethodElement methodElement = (MethodElement)handle;
            Set<IndexedClass> subclzs = this.getSubclasses(methodElement.getIn(), info);
            if (subclzs.isEmpty()) {
                return null;
            }
            RubyIndex index = RubyIndex.get((Parser.Result)info);
            LinkedHashSet<IndexedMethod> overriding = new LinkedHashSet<IndexedMethod>();
            HashSet<String> subClassNames = new HashSet<String>(subclzs.size());
            for (IndexedClass subClz : subclzs) {
                subClassNames.add(subClz.getFqn());
            }
            overriding.addAll(index.getMethods(methodElement.getName(), subClassNames, QuerySupport.Kind.EXACT));
            return OverridingMethodsImpl.asLocations(overriding);
        }
        return null;
    }

    private Set<IndexedClass> getSubclasses(String fqn, ParserResult info) {
        Cache cache = this.getCache(info);
        if (cache.subClasses.containsKey(fqn)) {
            return cache.subClasses.get(fqn);
        }
        RubyIndex index = RubyIndex.get((Parser.Result)info);
        Set<IndexedClass> result = index.getSubClasses(fqn, null, null, false);
        cache.subClasses.put(fqn, result);
        return result;
    }

    private Set<IndexedMethod> getInheritedMethods(String fqn, ParserResult info) {
        Cache cache = this.getCache(info);
        if (cache.inherited.containsKey(fqn)) {
            return cache.inherited.get(fqn);
        }
        RubyIndex index = RubyIndex.get((Parser.Result)info);
        Set<IndexedMethod> result = index.getInheritedMethods(fqn, "", QuerySupport.Kind.PREFIX, false, false);
        cache.inherited.put(fqn, result);
        return result;
    }

    private Cache getCache(ParserResult info) {
        if (this.cacheHolder.containsKey(info)) {
            return this.cacheHolder.get(info);
        }
        this.cacheHolder.clear();
        Cache result = new Cache();
        this.cacheHolder.put(info, result);
        return result;
    }

    private static Collection<RubyDeclarationFinderHelper.RubyAltLocation> asLocations(Collection<? extends IndexedElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<RubyDeclarationFinderHelper.RubyAltLocation> result = new HashSet<RubyDeclarationFinderHelper.RubyAltLocation>(elements.size());
        for (IndexedElement indexedElement : elements) {
            result.add(new RubyDeclarationFinderHelper.RubyAltLocation(indexedElement, false));
        }
        return result;
    }

    private static final class Cache {
        final Map<String, Set<IndexedMethod>> inherited = new HashMap<String, Set<IndexedMethod>>();
        final Map<String, Set<IndexedClass>> subClasses = new HashMap<String, Set<IndexedClass>>();

        private Cache() {
        }
    }
}

