/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.modules.profiler.heapwalk.OQLController;
import org.netbeans.modules.profiler.heapwalk.OQLSupport;
import org.netbeans.modules.profiler.heapwalk.oql.ui.OQLEditor;
import org.netbeans.modules.profiler.heapwalk.ui.OQLQueryCustomizer;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OQLControllerUI
extends JPanel
implements HelpCtx.Provider {
    private static final String CONTROLLER_NAME = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ControllerName");
    private static final String CONTROLLER_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ControllerDescr");
    private static final String QUERY_RESULTS_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_QueryResultsCaption");
    private static final String QUERY_EDITOR_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_QueryEditorCaption");
    private static final String SAVED_QUERIES_CAPTION = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SavedQueriesCaption");
    private static final String EXECUTING_QUERY_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecutingQueryMsg");
    private static final String EXECUTE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecuteButtonText");
    private static final String EXECUTE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_ExecuteButtonAccessDescr");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_CancelButtonText");
    private static final String CANCEL_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_CancelButtonAccessDescr");
    private static final String SAVE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SaveButtonText");
    private static final String SAVE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_SaveButtonAccessDescr");
    private static final String PROPERTIES_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_PropertiesButtonText");
    private static final String PROPERTIES_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_PropertiesButtonAccessDescr");
    private static final String DELETE_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_DeleteButtonText");
    private static final String DELETE_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_DeleteButtonAccessDescr");
    private static final String OPEN_BUTTON_TEXT = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_OpenButtonText");
    private static final String OPEN_BUTTON_ACCESS_DESCR = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_OpenButtonAccessDescr");
    private static final String LOADING_QUERIES_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_LoadingQueriesMsg");
    private static final String NO_SAVED_QUERIES_MSG = NbBundle.getMessage(OQLControllerUI.class, (String)"OQLControllerUI_NoSavedQueriesMsg");
    private static final String HELP_CTX_KEY = "OQLControllerUI.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("OQLControllerUI.HelpCtx");
    private AbstractButton presenter;
    private OQLController oqlController;

    public OQLControllerUI(OQLController controller) {
        this.oqlController = controller;
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter((QueryUI)((Object)this.oqlController.getQueryController().getPanel()));
        }
        return this.presenter;
    }

    private void initComponents() {
        JExtendedSplitPane querySplitter = new JExtendedSplitPane(1, (Component)this.oqlController.getQueryController().getPanel(), (Component)this.oqlController.getSavedController().getPanel());
        OQLControllerUI.tweakSplitPaneUI((JSplitPane)querySplitter);
        querySplitter.setResizeWeight(1.0);
        JExtendedSplitPane mainSplitter = new JExtendedSplitPane(0, (Component)this.oqlController.getResultsController().getPanel(), (Component)querySplitter);
        OQLControllerUI.tweakSplitPaneUI((JSplitPane)mainSplitter);
        mainSplitter.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add((Component)mainSplitter, "Center");
    }

    private static void tweakSplitPaneUI(JSplitPane splitPane) {
        splitPane.setBorder(null);
        splitPane.setDividerSize(3);
        if (!(splitPane.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)splitPane.getUI()).getDivider();
        if (divider != null) {
            divider.setBorder(null);
        }
    }

    public static class SavedUI
    extends JTitledPanel {
        private OQLController.SavedController savedController;
        private JTree savedTree;
        private JScrollPane savedTreeScroll;
        private JButton openButton;
        private JButton editButton;
        private JButton deleteButton;
        private JTextArea descriptionArea;
        private JPanel contentsPanel;
        private JPanel loadingMsgPanel;
        private JPanel noQueriesMsgPanel;
        private OQLSupport.OQLTreeModel treeModel;
        private boolean queriesLoaded = false;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/savedOQL.png", (boolean)false);

        public SavedUI(OQLController.SavedController savedController) {
            super(SAVED_QUERIES_CAPTION, (Icon)ICON, true);
            this.savedController = savedController;
            this.treeModel = OQLSupport.createModel();
            this.initComponents();
            this.refreshQueries();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    OQLController.SavedController.loadData(SavedUI.this.treeModel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SavedUI.this.queriesLoaded = true;
                            SavedUI.this.initializeQueries();
                            SavedUI.this.refreshQueries();
                        }
                    });
                }
            });
        }

        public void saveQuery(final String query) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (OQLQueryCustomizer.saveQuery(query, SavedUI.this.treeModel, SavedUI.this.savedTree)) {
                        SavedUI.this.setVisible(true);
                        SavedUI.this.refreshQueries();
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                OQLController.SavedController.saveData(SavedUI.this.treeModel);
                            }
                        });
                    }
                }
            });
        }

        private void openQuery() {
            TreePath[] selection = this.savedTree.getSelectionPaths();
            if (SavedUI.supportsOpen(selection)) {
                OQLSupport.OQLQueryNode node = (OQLSupport.OQLQueryNode)SavedUI.node(selection[0]);
                this.savedController.getOQLController().getQueryController().setQuery(((OQLSupport.Query)node.getUserObject()).getScript());
            }
        }

        private void editQuery() {
            TreePath[] selection = this.savedTree.getSelectionPaths();
            if (SavedUI.supportsProperties(selection)) {
                OQLSupport.OQLNode node = SavedUI.node(selection[0]);
                if (OQLQueryCustomizer.editNode(node, this.treeModel, this.savedTree)) {
                    this.refreshDescription();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            OQLController.SavedController.saveData(SavedUI.this.treeModel);
                        }
                    });
                }
                this.editButton.requestFocus();
            }
        }

        private void deleteQueries() {
            TreePath[] selection = this.savedTree.getSelectionPaths();
            if (SavedUI.supportsDelete(selection)) {
                DefaultMutableTreeNode otherNode = SavedUI.node(this.savedTree.getLeadSelectionPath()).getPreviousSibling();
                if (otherNode == null) {
                    otherNode = SavedUI.node(this.savedTree.getAnchorSelectionPath()).getNextSibling();
                }
                if (otherNode == null) {
                    otherNode = this.treeModel.customCategory();
                }
                for (TreePath path : selection) {
                    this.treeModel.removeNodeFromParent(SavedUI.node(path));
                }
                if (!this.treeModel.hasCustomQueries()) {
                    this.treeModel.nodeStructureChanged(this.treeModel.customCategory());
                }
                this.savedTree.setSelectionPath(new TreePath(this.treeModel.getPathToRoot(otherNode)));
                this.refreshQueries();
                this.savedTree.requestFocus();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        OQLController.SavedController.saveData(SavedUI.this.treeModel);
                    }
                });
            }
        }

        public void initializeQueries() {
            this.savedTree.expandPath(new TreePath(this.treeModel.getPathToRoot(this.treeModel.customCategory())));
            if (!this.treeModel.hasCustomQueries() && this.treeModel.hasDefinedCategories()) {
                this.savedTree.expandRow(2);
            }
        }

        private void refreshQueries() {
            Component currentContents = ((BorderLayout)this.contentsPanel.getLayout()).getLayoutComponent("Center");
            if (this.queriesLoaded) {
                OQLSupport.OQLNode node = (OQLSupport.OQLNode)this.treeModel.getRoot();
                if (node.getChildCount() == 0) {
                    if (currentContents != this.noQueriesMsgPanel) {
                        if (currentContents != null) {
                            this.contentsPanel.remove(currentContents);
                        }
                        this.contentsPanel.add((Component)this.noQueriesMsgPanel, "Center");
                        this.noQueriesMsgPanel.invalidate();
                        this.contentsPanel.revalidate();
                        this.contentsPanel.repaint();
                    }
                } else if (currentContents != this.savedTreeScroll) {
                    if (currentContents != null) {
                        this.contentsPanel.remove(currentContents);
                    }
                    this.contentsPanel.add((Component)this.savedTreeScroll, "Center");
                    this.savedTreeScroll.invalidate();
                    this.contentsPanel.revalidate();
                    this.contentsPanel.repaint();
                }
            } else {
                this.contentsPanel.add((Component)this.loadingMsgPanel, "Center");
                this.loadingMsgPanel.invalidate();
                this.contentsPanel.revalidate();
                this.contentsPanel.repaint();
            }
        }

        private void refreshButtons() {
            TreePath[] selection = this.savedTree.getSelectionPaths();
            this.openButton.setEnabled(SavedUI.supportsOpen(selection));
            this.editButton.setEnabled(SavedUI.supportsProperties(selection));
            this.deleteButton.setEnabled(SavedUI.supportsDelete(selection));
        }

        private static boolean supportsOpen(TreePath[] selection) {
            if (selection == null || selection.length != 1) {
                return false;
            }
            return SavedUI.node(selection[0]).supportsOpen();
        }

        private static boolean supportsProperties(TreePath[] selection) {
            if (selection == null || selection.length != 1) {
                return false;
            }
            return SavedUI.node(selection[0]).supportsProperties();
        }

        private static boolean supportsDelete(TreePath[] selection) {
            if (selection == null || selection.length == 0) {
                return false;
            }
            for (TreePath path : selection) {
                if (SavedUI.node(path).supportsDelete()) continue;
                return false;
            }
            return true;
        }

        private static OQLSupport.OQLNode node(TreePath selection) {
            return (OQLSupport.OQLNode)selection.getLastPathComponent();
        }

        private void refreshDescription() {
            boolean showDescr;
            TreePath[] selection = this.savedTree.getSelectionPaths();
            String description = null;
            boolean bl = showDescr = selection != null && selection.length == 1;
            if (showDescr) {
                description = SavedUI.node(selection[0]).getDescription();
            }
            if (description != null) {
                this.descriptionArea.setText(description);
                this.descriptionArea.setVisible(true);
            } else {
                this.descriptionArea.setVisible(false);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.savedTree = new JTree(this.treeModel);
            this.savedTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
            this.savedTree.setRootVisible(false);
            this.savedTree.setShowsRootHandles(true);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(null);
            this.savedTree.setCellRenderer(renderer);
            this.savedTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SavedUI.this.refreshButtons();
                    SavedUI.this.refreshDescription();
                }
            });
            this.savedTreeScroll = new JScrollPane(this.savedTree, 20, 30);
            this.savedTreeScroll.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.savedTree.getBackground()));
            this.savedTreeScroll.setViewportBorder(BorderFactory.createEmptyBorder());
            this.loadingMsgPanel = new JPanel(new BorderLayout());
            this.loadingMsgPanel.setOpaque(false);
            JLabel loadingMsgLabel = new JLabel(LOADING_QUERIES_MSG, 0);
            loadingMsgLabel.setEnabled(false);
            this.loadingMsgPanel.add((Component)loadingMsgLabel, "Center");
            this.noQueriesMsgPanel = new JPanel(new BorderLayout());
            this.noQueriesMsgPanel.setOpaque(false);
            JLabel noQueriesMsgLabel = new JLabel(NO_SAVED_QUERIES_MSG, 0);
            noQueriesMsgLabel.setEnabled(false);
            this.noQueriesMsgPanel.add((Component)noQueriesMsgLabel, "Center");
            this.openButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SavedUI.this.openQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.openButton, (String)OPEN_BUTTON_TEXT);
            this.openButton.getAccessibleContext().setAccessibleDescription(OPEN_BUTTON_ACCESS_DESCR);
            this.editButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SavedUI.this.editQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)PROPERTIES_BUTTON_TEXT);
            this.editButton.getAccessibleContext().setAccessibleDescription(PROPERTIES_BUTTON_ACCESS_DESCR);
            this.deleteButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    SavedUI.this.deleteQueries();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)DELETE_BUTTON_TEXT);
            this.deleteButton.getAccessibleContext().setAccessibleDescription(DELETE_BUTTON_ACCESS_DESCR);
            JPanel editContainer = new JPanel(new FlowLayout(3, 5, 0));
            editContainer.setOpaque(false);
            editContainer.add(this.editButton);
            editContainer.add(this.deleteButton);
            JPanel controlPanel = new JPanel(new BorderLayout(5, 5));
            controlPanel.setBorder(BorderFactory.createMatteBorder(5, 0, 5, 5, this.savedTree.getBackground()));
            controlPanel.setOpaque(false);
            controlPanel.add((Component)editContainer, "West");
            controlPanel.add((Component)this.openButton, "East");
            this.descriptionArea = new JTextArea();
            this.descriptionArea.setOpaque(true);
            this.descriptionArea.setEnabled(false);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setDisabledTextColor(UIManager.getColor("ToolTip.foreground"));
            this.descriptionArea.setBackground(UIManager.getColor("ToolTip.background"));
            this.descriptionArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 5, this.savedTree.getBackground()), BorderFactory.createMatteBorder(5, 5, 5, 5, UIManager.getColor("ToolTip.background"))));
            JPanel bottomPanel = new JPanel(new BorderLayout());
            bottomPanel.setOpaque(false);
            bottomPanel.add((Component)this.descriptionArea, "Center");
            bottomPanel.add((Component)controlPanel, "South");
            this.contentsPanel = new JPanel();
            this.contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getTitleBorderColor()));
            this.contentsPanel.setLayout(new BorderLayout());
            this.contentsPanel.setOpaque(true);
            this.contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            this.contentsPanel.add((Component)bottomPanel, "South");
            this.setLayout(new BorderLayout());
            this.add(this.contentsPanel, "Center");
            this.refreshButtons();
            this.refreshDescription();
            this.savedTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "OPEN_QUERY_ACTION");
            this.savedTree.getActionMap().put("OPEN_QUERY_ACTION", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavedUI.this.openQuery();
                }
            });
            this.savedTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_QUERY_ACTION");
            this.savedTree.getActionMap().put("DELETE_QUERY_ACTION", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SavedUI.this.deleteQueries();
                }
            });
            this.savedTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        SavedUI.this.openQuery();
                    }
                }
            });
            this.savedTreeScroll.setPreferredSize(new Dimension(this.openButton.getPreferredSize().width + this.editButton.getPreferredSize().width + this.deleteButton.getPreferredSize().width + 90, 220));
        }
    }

    public static class QueryUI
    extends JTitledPanel {
        private OQLController.QueryController queryController;
        private OQLEditor editor;
        private JButton runButton;
        private JButton saveButton;
        private JButton cancelButton;
        private JLabel progressLabel;
        private JProgressBar progressBar;
        private JPanel controlPanel;
        private JPanel progressPanel;
        private JPanel contentsPanel;
        private boolean queryValid = true;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/rules.png", (boolean)false);

        public QueryUI(OQLController.QueryController queryController, OQLEngine engine) {
            super(QUERY_EDITOR_CAPTION, (Icon)ICON, true);
            this.queryController = queryController;
            this.initComponents(engine);
            this.updateUIState();
        }

        public void setQuery(String query) {
            this.setVisible(true);
            this.editor.setScript(query);
            this.editor.requestFocus();
        }

        public void queryStarted(final BoundedRangeModel model) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryUI.this.updateUIState();
                    QueryUI.this.progressLabel.setText(EXECUTING_QUERY_MSG);
                    QueryUI.this.progressBar.setModel(model);
                    QueryUI.this.progressBar.setMaximumSize(new Dimension(((QueryUI)QueryUI.this).progressBar.getMaximumSize().width, ((QueryUI)QueryUI.this).progressBar.getPreferredSize().height));
                    QueryUI.this.contentsPanel.remove(QueryUI.this.controlPanel);
                    QueryUI.this.contentsPanel.add((Component)QueryUI.this.progressPanel, "South");
                    QueryUI.this.progressPanel.invalidate();
                    QueryUI.this.contentsPanel.revalidate();
                    QueryUI.this.contentsPanel.repaint();
                }
            });
        }

        public void queryFinished() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryUI.this.updateUIState();
                    QueryUI.this.contentsPanel.remove(QueryUI.this.progressPanel);
                    QueryUI.this.contentsPanel.add((Component)QueryUI.this.controlPanel, "South");
                    QueryUI.this.controlPanel.invalidate();
                    QueryUI.this.contentsPanel.revalidate();
                    QueryUI.this.contentsPanel.repaint();
                }
            });
        }

        private void addToQuery(char ch) {
            this.setVisible(true);
            String chs = new String(new char[]{ch});
            this.editor.setScript(this.editor.getScript() + chs);
        }

        public void requestFocus() {
            this.editor.requestFocus();
        }

        private void updateUIState() {
            if (this.queryController.getOQLController().isQueryRunning()) {
                this.runButton.setEnabled(false);
                this.editor.setEditable(false);
                this.editor.setEnabled(false);
            } else {
                this.runButton.setEnabled(this.editor.getScript().length() > 0 && this.queryValid);
                this.saveButton.setEnabled(this.editor.getScript().length() > 0 && this.queryValid);
                this.editor.setEditable(true);
                this.editor.setEnabled(true);
            }
        }

        private void executeQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryUI.this.requestFocus();
                    QueryUI.this.queryController.getOQLController().executeQuery(QueryUI.this.editor.getScript());
                }
            });
        }

        private void saveQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryUI.this.queryController.getOQLController().getSavedController().saveQuery(QueryUI.this.editor.getScript());
                    QueryUI.this.editor.requestFocus();
                }
            });
        }

        private void cancelQuery() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryUI.this.queryController.getOQLController().cancelQuery();
                }
            });
        }

        private void initComponents(OQLEngine engine) {
            this.editor = new OQLEditor(engine);
            this.editor.addPropertyChangeListener("document#valid", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    QueryUI.this.queryValid = (Boolean)evt.getNewValue();
                    QueryUI.this.updateUIState();
                }
            });
            this.editor.setBackground(UIUtils.getProfilerResultsBackground());
            JScrollPane editorScroll = new JScrollPane(this.editor, 20, 30);
            editorScroll.setBorder(BorderFactory.createMatteBorder(5, 5, 0, 5, UIUtils.getProfilerResultsBackground()));
            editorScroll.setViewportBorder(BorderFactory.createEmptyBorder());
            editorScroll.getVerticalScrollBar().setUnitIncrement(10);
            editorScroll.getHorizontalScrollBar().setUnitIncrement(10);
            this.runButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    QueryUI.this.executeQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.runButton, (String)EXECUTE_BUTTON_TEXT);
            this.runButton.getAccessibleContext().setAccessibleDescription(EXECUTE_BUTTON_ACCESS_DESCR);
            this.saveButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    QueryUI.this.saveQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)SAVE_BUTTON_TEXT);
            this.saveButton.getAccessibleContext().setAccessibleDescription(SAVE_BUTTON_ACCESS_DESCR);
            this.controlPanel = new JPanel(new BorderLayout(5, 5));
            this.controlPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            this.controlPanel.setOpaque(false);
            this.controlPanel.add((Component)this.saveButton, "West");
            this.controlPanel.add((Component)this.runButton, "East");
            this.progressBar = new JProgressBar(0);
            this.progressLabel = new JLabel();
            this.progressLabel.setLabelFor(this.progressBar);
            this.cancelButton = new JButton(){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    QueryUI.this.cancelQuery();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)CANCEL_BUTTON_TEXT);
            this.cancelButton.getAccessibleContext().setAccessibleDescription(CANCEL_BUTTON_ACCESS_DESCR);
            this.progressPanel = new JPanel(new GridBagLayout());
            this.progressPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            this.progressPanel.setOpaque(false);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 10);
            this.progressPanel.add((Component)this.progressLabel, c);
            c = new GridBagConstraints();
            c.weightx = 1.0;
            c.anchor = 10;
            c.fill = 2;
            c.insets = new Insets(0, 0, 0, 10);
            this.progressPanel.add((Component)this.progressBar, c);
            c = new GridBagConstraints();
            c.weighty = 1.0;
            c.anchor = 13;
            c.insets = new Insets(0, 0, 0, 0);
            this.progressPanel.add((Component)this.cancelButton, c);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.getTitleBorderColor()));
            this.contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            this.contentsPanel.setOpaque(true);
            this.contentsPanel.add((Component)editorScroll, "Center");
            this.contentsPanel.add((Component)this.controlPanel, "South");
            this.setLayout(new BorderLayout());
            this.add(this.contentsPanel, "Center");
            this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CANCEL_ACTION");
            this.getActionMap().put("CANCEL_ACTION", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryUI.this.cancelQuery();
                }
            });
            editorScroll.setPreferredSize(new Dimension(1, 220));
        }
    }

    public static class ResultsUI
    extends JTitledPanel {
        private OQLController.ResultsController resultsController;
        private HTMLTextArea resultsArea;
        private static ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png", (boolean)false);

        public ResultsUI(OQLController.ResultsController resultsController) {
            super(QUERY_RESULTS_CAPTION, (Icon)ICON, true);
            this.resultsController = resultsController;
            this.initComponents();
        }

        public void setResult(String result) {
            this.resultsArea.setText(result);
            try {
                this.resultsArea.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(true);
        }

        private void initComponents() {
            this.resultsArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    ResultsUI.this.resultsController.showURL(url);
                }
            };
            JScrollPane resultsAreaScroll = new JScrollPane((Component)this.resultsArea, 20, 30);
            resultsAreaScroll.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getProfilerResultsBackground()));
            resultsAreaScroll.setViewportBorder(BorderFactory.createEmptyBorder());
            resultsAreaScroll.getVerticalScrollBar().setUnitIncrement(10);
            resultsAreaScroll.getHorizontalScrollBar().setUnitIncrement(10);
            JPanel contentsPanel = new JPanel();
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getTitleBorderColor()));
            contentsPanel.setLayout(new BorderLayout());
            contentsPanel.setOpaque(true);
            contentsPanel.setBackground(this.resultsArea.getBackground());
            contentsPanel.add((Component)resultsAreaScroll, "Center");
            this.setLayout(new BorderLayout());
            this.add(contentsPanel, "Center");
        }
    }

    private static class Presenter
    extends JToggleButton
    implements HelpCtx.Provider {
        private static ImageIcon ICON_INFO = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/oql.png", (boolean)false);

        public Presenter(final QueryUI queryUI) {
            this.setText(CONTROLLER_NAME);
            this.setToolTipText(CONTROLLER_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(final KeyEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            queryUI.requestFocus();
                            queryUI.addToQuery(e.getKeyChar());
                        }
                    });
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }
    }
}

