/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileUnit;
import org.openide.util.NbBundle;

public abstract class TransferFileTableModel
extends AbstractTableModel {
    private final List<TransferFileUnit> fileData = new ArrayList<TransferFileUnit>();
    private final List<TransferFileTableChangeListener> listeners = new CopyOnWriteArrayList<TransferFileTableChangeListener>();
    volatile String filter = "";

    protected abstract Type getType();

    protected abstract String getTabTitle();

    protected abstract String getFirstColumnName();

    List<TransferFileUnit> getData() {
        return new ArrayList<TransferFileUnit>(this.fileData);
    }

    static Map<Integer, Boolean> captureState(List<TransferFileUnit> files) {
        HashMap<Integer, Boolean> retval = new HashMap<Integer, Boolean>(files.size());
        for (TransferFileUnit unit : files) {
            retval.put(unit.getId(), unit.isMarked());
        }
        return retval;
    }

    static void restoreState(List<TransferFileUnit> newFiles, Map<Integer, Boolean> capturedState, boolean isMarkedAsDefault) {
        for (TransferFileUnit unit : newFiles) {
            Boolean isChecked = capturedState.get(unit.getId());
            if (isChecked != null) {
                if (isChecked.booleanValue() && !unit.isMarked() && unit.canBeMarked()) {
                    unit.setMarked(true);
                    continue;
                }
                if (isChecked.booleanValue() || !unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(false);
                continue;
            }
            if (!isMarkedAsDefault || unit.isMarked() || !unit.canBeMarked()) continue;
            unit.setMarked(true);
        }
    }

    public static boolean isMarkedAsDefault() {
        return true;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        TransferFileUnit u = this.getUnitAtRow(row);
        if (u != null) {
            switch (col) {
                case 0: {
                    res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    res = u.getDisplayName();
                    break;
                }
                default: {
                    assert (false) : "Unknown column index: " + col;
                    break;
                }
            }
        }
        return res;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
            }
        }
        return res;
    }

    public String getTabTooltipText() {
        return null;
    }

    public String getToolTipText(int row, int col) {
        String retval = null;
        if (col == 0) {
            retval = this.getTooltipForCheckBox(row);
        } else if (col == 1) {
            retval = (String)this.getValueAt(row, 1);
        }
        return retval;
    }

    private String getTooltipForCheckBox(int row) {
        return NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmation_TooltipCheckBox", (Object)((String)this.getValueAt(row, 1)));
    }

    public int getMinWidth(JTableHeader header, int col) {
        return header.getHeaderRect((int)col).width;
    }

    public int getPreferredWidth(JTableHeader header, int col) {
        if (col == 1) {
            return this.getMinWidth(header, col) * 4;
        }
        return this.getMinWidth(header, col);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.getFirstColumnName();
            }
            case 1: {
                return NbBundle.getMessage(TransferFileTableModel.class, (String)"FileConfirmationTableModel_Columns_RelativePath");
            }
        }
        assert (false) : "Unknown column index: " + column;
        return super.getColumnName(column);
    }

    public final void sort(int columnIndex, boolean sortAscending) {
        if (columnIndex == 0) {
            Collections.sort(this.fileData, new MarkedComparator(sortAscending));
        } else if (columnIndex == 1) {
            Collections.sort(this.fileData, new PathComparator(sortAscending));
        } else assert (false) : "Unknown column index: " + columnIndex;
        this.fireTableDataChanged();
    }

    protected final void setData(List<TransferFileUnit> files) {
        assert (files != null);
        this.fileData.clear();
        this.fileData.addAll(files);
        this.fireTableDataChanged();
    }

    public void setFilter(final String filter, final Runnable runAfterwards) {
        assert (filter != null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransferFileTableModel.this.filter = filter.toLowerCase();
                TransferFileTableModel.this.fireFilterChange();
                if (runAfterwards != null) {
                    runAfterwards.run();
                }
            }
        });
    }

    public String getFilter() {
        assert (this.filter != null);
        return this.filter;
    }

    public void addUpdateUnitListener(TransferFileTableChangeListener l) {
        this.listeners.add(l);
    }

    public void removeUpdateUnitListener(TransferFileTableChangeListener l) {
        this.listeners.remove(l);
    }

    void fireUpdataUnitChange() {
        for (TransferFileTableChangeListener l : this.listeners) {
            l.updateUnitsChanged();
        }
    }

    void fireFilterChange() {
        for (TransferFileTableChangeListener l : this.listeners) {
            l.filterChanged();
        }
    }

    public List<TransferFileUnit> getVisibleFileUnits() {
        List<TransferFileUnit> dataCopy = this.getData();
        String filterCopy = this.filter;
        ArrayList<TransferFileUnit> retval = new ArrayList<TransferFileUnit>(dataCopy.size());
        for (TransferFileUnit file : dataCopy) {
            if (!file.isVisible(filterCopy)) continue;
            retval.add(file);
        }
        return retval;
    }

    @Override
    public int getRowCount() {
        return this.getVisibleFileUnits().size();
    }

    public int getRawItemCount() {
        return this.fileData.size();
    }

    public List<TransferFileUnit> getAllUnits() {
        List<TransferFileUnit> allUnits = this.getData();
        ArrayList<TransferFileUnit> retval = new ArrayList<TransferFileUnit>(allUnits.size());
        for (TransferFileUnit fUnit : allUnits) {
            if (!fUnit.getTransferFile().isFile()) continue;
            retval.add(fUnit);
        }
        return retval;
    }

    public List<TransferFileUnit> getMarkedUnits() {
        List<TransferFileUnit> allUnits = this.getAllUnits();
        ArrayList<TransferFileUnit> retval = new ArrayList<TransferFileUnit>(allUnits.size());
        for (TransferFileUnit fUnit : allUnits) {
            assert (fUnit.getTransferFile().isFile()) : "Only files can be visible";
            if (!fUnit.isMarked()) continue;
            retval.add(fUnit);
        }
        return retval;
    }

    public TransferFileUnit getUnitAtRow(int row) {
        assert (this.getVisibleFileUnits().size() > row) : String.format("Unknown row index [%d, size %d]", row, this.getVisibleFileUnits().size());
        if (row < 0) {
            return null;
        }
        return this.getVisibleFileUnits().get(row);
    }

    public int getRowForUnit(TransferFileUnit unit) {
        int i = 0;
        for (TransferFileUnit u : this.getVisibleFileUnits()) {
            if (unit.equals(u)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 && Boolean.class.equals(this.getColumnClass(col));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        assert (columnIndex == 0) : "Only first column is editable.";
        assert (aValue instanceof Boolean) : aValue + " must be instance of Boolean.";
        TransferFileUnit u = this.getUnitAtRow(rowIndex);
        if (u != null && ((Boolean)aValue).booleanValue() != u.isMarked()) {
            u.setMarked(!u.isMarked());
            this.fireUpdataUnitChange();
        }
    }

    private static class PathComparator
    implements Comparator<TransferFileUnit> {
        private final boolean sortAscending;

        public PathComparator(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public int compare(TransferFileUnit o1, TransferFileUnit o2) {
            TransferFileUnit unit1 = this.sortAscending ? o1 : o2;
            TransferFileUnit unit2 = this.sortAscending ? o2 : o1;
            return TransferFileUnit.compare(unit1, unit2);
        }
    }

    private static class MarkedComparator
    implements Comparator<TransferFileUnit> {
        private final boolean sortAscending;

        public MarkedComparator(boolean sortAscending) {
            this.sortAscending = sortAscending;
        }

        @Override
        public int compare(TransferFileUnit o1, TransferFileUnit o2) {
            TransferFileUnit unit2;
            TransferFileUnit unit1 = this.sortAscending ? o1 : o2;
            TransferFileUnit transferFileUnit = unit2 = this.sortAscending ? o2 : o1;
            if (unit1.isMarked() && unit2.isMarked()) {
                return TransferFileUnit.compare(unit1, unit2);
            }
            if (unit1.isMarked()) {
                return -1;
            }
            if (unit2.isMarked()) {
                return 1;
            }
            return TransferFileUnit.compare(unit1, unit2);
        }
    }

    public static enum Type {
        UPLOAD,
        DOWNLOAD;

    }
}

