/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.table;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.php.project.PhpPreferences;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableModel;
import org.openide.util.ImageUtilities;

public final class SortColumnHeaderRenderer
implements TableCellRenderer {
    private static final String SORTING_COLUMN_INDEX = "SortingColumnIndex";
    private static final String SORTING_ASCENDING = "SortingAscending";
    private static ImageIcon sortDescIcon;
    private static ImageIcon sortAscIcon;
    private final TransferFileTableModel model;
    private final TableCellRenderer textRenderer;
    private int sortColumnIndex;
    private boolean sortAscending;

    public SortColumnHeaderRenderer(TransferFileTableModel model, TableCellRenderer textRenderer) {
        assert (model != null);
        assert (textRenderer != null);
        this.model = model;
        this.textRenderer = textRenderer;
        this.sortColumnIndex = SortColumnHeaderRenderer.getPreferences().getInt(SORTING_COLUMN_INDEX, this.getDefaultSortingColumn());
        this.sortAscending = SortColumnHeaderRenderer.getPreferences().getBoolean(SORTING_ASCENDING, true);
        model.sort(this.sortColumnIndex, this.sortAscending);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component text = this.textRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (text instanceof JLabel) {
            JLabel label = (JLabel)text;
            if (column == this.sortColumnIndex) {
                label.setIcon(this.sortAscending ? this.getSortAscIcon() : this.getSortDescIcon());
                label.setHorizontalTextPosition(2);
            } else {
                label.setIcon(null);
            }
        }
        return text;
    }

    public void setDefaultSorting() {
        this.setSorting(this.getDefaultSortingColumn());
    }

    private int getDefaultSortingColumn() {
        return 1;
    }

    public void setSorting(int columnIndex) {
        if (columnIndex != this.sortColumnIndex) {
            this.sortColumnIndex = columnIndex;
            this.sortAscending = true;
        } else {
            this.sortAscending = !this.sortAscending;
        }
        SortColumnHeaderRenderer.getPreferences().putInt(SORTING_COLUMN_INDEX, this.sortColumnIndex);
        SortColumnHeaderRenderer.getPreferences().putBoolean(SORTING_ASCENDING, this.sortAscending);
        this.model.sort(columnIndex, this.sortAscending);
    }

    public void sort() {
        this.model.sort(this.sortColumnIndex, this.sortAscending);
    }

    private ImageIcon getSortAscIcon() {
        if (sortAscIcon == null) {
            sortAscIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedDesc.gif", (boolean)false);
        }
        return sortAscIcon;
    }

    private ImageIcon getSortDescIcon() {
        if (sortDescIcon == null) {
            sortDescIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/columnsSortedAsc.gif", (boolean)false);
        }
        return sortDescIcon;
    }

    private static Preferences getPreferences() {
        return PhpPreferences.getPreferences(false);
    }
}

