/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.FileModel;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WrapperParseErrorHandler;
import com.sun.javacard.filemodels.XListEntry;
import com.sun.javacard.filemodels.XListInstanceEntry;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XListModel
extends FileModel<XListEntry> {
    public XListModel(InputStream in, ParseErrorHandler handler) throws IOException {
        if (in == null) {
            throw new NullPointerException("Null input stream");
        }
        handler = handler == null ? ParseErrorHandler.DEFAULT : handler;
        handler = new WrapperParseErrorHandler(handler, this);
        this.parse(in, handler);
        this.close();
    }

    public XListModel() {
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder("<list>\n");
        for (XListEntry e : this.getData()) {
            sb.append("    <bundle>\n");
            sb.append(e.toXml());
            sb.append("    </bundle>\n");
        }
        sb.append("</list>\n");
        return sb.toString();
    }

    private void parse(InputStream in, ParseErrorHandler handler) throws IOException {
        assert (!EventQueue.isDispatchThread());
        try {
            Document doc = null;
            doc = Portability.parse(in);
            NodeList bundles = doc.getElementsByTagName("bundle");
            int len = bundles.getLength();
            int ix = 0;
            for (int i = 0; i < len; ++i) {
                if (Thread.interrupted()) {
                    return;
                }
                Node parent = bundles.item(i);
                NodeList kids = parent.getChildNodes();
                int kidsLen = kids.getLength();
                XListEntry entry = new XListEntry();
                block8: for (int j = 0; j < kidsLen; ++j) {
                    Node bundleItem = kids.item(j);
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (bundleItem.getNodeType() != 1) continue;
                    switch (TopLevelTags.valueOf(bundleItem.getNodeName())) {
                        case name: {
                            String name = bundleItem.getTextContent();
                            entry.setDisplayName(name);
                            continue block8;
                        }
                        case type: {
                            String type = bundleItem.getTextContent();
                            entry.setType(type);
                            continue block8;
                        }
                        case instances: {
                            NodeList insKids = bundleItem.getChildNodes();
                            int iLen = insKids.getLength();
                            for (int k = 0; k < iLen; ++k) {
                                if (Thread.interrupted()) {
                                    return;
                                }
                                Node ins = insKids.item(k);
                                if (ins.getNodeType() != 1 || !"instance".equals(ins.getNodeName())) continue;
                                entry.addInstance(new XListInstanceEntry(ins.getTextContent()));
                            }
                            continue block8;
                        }
                        default: {
                            this.error();
                            Logger.getLogger(XListModel.class.getName()).log(Level.INFO, "Unknown element " + bundleItem.getNodeName() + " from xlist");
                            handler.unrecognizedElementEncountered(bundleItem.getNodeName());
                        }
                    }
                }
                if (!entry.isValid()) continue;
                entry.setOrder(ix++);
                this.add(entry);
            }
        }
        catch (IOException ioe) {
            this.error();
            throw ioe;
        }
    }

    private static enum TopLevelTags {
        name,
        type,
        instances;

    }
}

