/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.openide.util.NbBundle;

public class DataViewUtils {
    public static final String[] HTML_ALLOWABLES = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    public static final String[] HTML_ILLEGALS = new String[]{"&", "\"", "<", ">"};

    public static boolean isNumeric(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrecisionRequired(int jdbcType, boolean isdb2) {
        if (isdb2 && jdbcType == 2004 || jdbcType == 2005) {
            return true;
        }
        return DataViewUtils.isPrecisionRequired(jdbcType);
    }

    public static boolean isPrecisionRequired(int jdbcType) {
        switch (jdbcType) {
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 70: 
            case 91: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
        }
        return true;
    }

    public static boolean isScaleRequired(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isString(int jdbcType) {
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSQLConstantString(Object value) {
        return value == null || value instanceof String && ((String)value).startsWith("<") && ((String)value).endsWith(">");
    }

    public static boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static void closeResources(PreparedStatement pstmt) {
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResources(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeResources(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getColumnToolTip(DBColumn column) {
        boolean pk = column.isPrimaryKey();
        boolean fk = column.isForeignKey();
        boolean isNullable = column.isNullable();
        boolean generated = column.isGenerated();
        StringBuilder strBuf = new StringBuilder("<html> <table border=0 cellspacing=0 cellpadding=0 >");
        strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_name")).append("</td> <td> &nbsp; : &nbsp; <b>");
        strBuf.append(column.getName()).append("</b> </td> </tr>");
        strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_type")).append("</td> <td> &nbsp; : &nbsp; <b>");
        strBuf.append(column.getTypeName()).append("</b> </td> </tr>");
        if (DataViewUtils.isString(column.getJdbcType())) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_length")).append("</td> <td> &nbsp; : &nbsp; <b>");
        } else {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_precision")).append("</td> <td> &nbsp; : &nbsp; <b>");
        }
        strBuf.append(column.getPrecision()).append("</b> </td> </tr>");
        if (DataViewUtils.isScaleRequired(column.getJdbcType())) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_scale")).append("</td> <td> &nbsp; : &nbsp; <b>");
            strBuf.append(column.getScale()).append("</b> </td> </tr>");
        }
        if (pk) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_PK")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        if (fk) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_FK")).append("</td> <td> &nbsp; : &nbsp; <b>" + DataViewUtils.getForeignKeyString(column)).append("</b>").append("</td> </tr>");
        }
        if (!isNullable) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_nullable")).append("</td> <td> &nbsp; : &nbsp; <b> No </b> </td> </tr>");
        }
        if (generated) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_generated")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        if (column.hasDefault()) {
            strBuf.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_default")).append("</td> <td> &nbsp; : &nbsp; <b>").append(column.getDefaultValue()).append("</b> </td> </tr>");
        }
        strBuf.append("</table> </html>");
        return strBuf.toString();
    }

    public static String getForeignKeyString(DBColumn column) {
        String refString = column.getName() + " --> ";
        StringBuilder str = new StringBuilder(refString);
        DBTable table = (DBTable)column.getParentObject();
        List<DBForeignKey> list = table.getForeignKeys();
        for (DBForeignKey fk : list) {
            if (!fk.contains(column)) continue;
            List<String> pkColumnList = fk.getPKColumnNames();
            Iterator<String> it1 = pkColumnList.iterator();
            while (it1.hasNext()) {
                String pkColName = it1.next();
                str.append(pkColName);
                if (!it1.hasNext()) continue;
                str.append(", ");
            }
        }
        return str.toString();
    }

    public static String escapeHTML(String string) {
        return DataViewUtils.replaceInString(string, HTML_ILLEGALS, HTML_ALLOWABLES);
    }

    public static String replaceInString(String originalString, String[] victims, String[] replacements) {
        StringBuffer resultBuffer = new StringBuffer();
        boolean bReplaced = false;
        for (int charPosition = 0; charPosition < originalString.length(); ++charPosition) {
            for (int nSelected = 0; !bReplaced && nSelected < victims.length; ++nSelected) {
                if (!originalString.startsWith(victims[nSelected], charPosition)) continue;
                resultBuffer.append(replacements[nSelected]);
                bReplaced = true;
                charPosition += victims[nSelected].length() - 1;
            }
            if (!bReplaced) {
                resultBuffer.append(originalString.charAt(charPosition));
                continue;
            }
            bReplaced = false;
        }
        return resultBuffer.toString();
    }

    private DataViewUtils() {
    }
}

