/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointsTreeModelFilter
implements TreeModelFilter {
    static final Map<LineBreakpoint, Integer> MAX_LINES = new WeakHashMap<LineBreakpoint, Integer>();
    private static boolean verbose = System.getProperty("netbeans.debugger.show_hidden_breakpoints") != null;

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        int i;
        if (to - from <= 0) {
            return new Object[0];
        }
        Object[] ch = original.getChildren(parent, from, to);
        ArrayList<Object> l = new ArrayList<Object>();
        int k = ch.length;
        int n = to - from;
        HashMap<String, Integer> maxLines = new HashMap<String, Integer>();
        for (i = 0; i < k; ++i) {
            if (!verbose && ch[i] instanceof CndBreakpoint && ((CndBreakpoint)((Object)ch[i])).isHidden() || --from >= 0) continue;
            l.add(ch[i]);
            if (ch[i] instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)((Object)ch[i]);
                String fn = EditorContextBridge.getFileName(lb);
                int line = lb.getLineNumber();
                Integer mI = (Integer)maxLines.get(fn);
                if (mI != null) {
                    line = Math.max(line, mI);
                }
                mI = line;
                maxLines.put(fn, mI);
            }
            if (--n == 0) break;
        }
        for (i = l.size() - 1; i >= 0; --i) {
            Object o = l.get(i);
            if (!(o instanceof LineBreakpoint)) continue;
            LineBreakpoint lb = (LineBreakpoint)((Object)o);
            MAX_LINES.put(lb, (Integer)maxLines.get(EditorContextBridge.getFileName(lb)));
        }
        return l.toArray();
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return this.getChildren(original, node, 0, Integer.MAX_VALUE).length;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

