/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.windows.InputOutput;

public abstract class CndDebugger
implements PropertyChangeListener {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public ContextProvider lookupProvider;
    protected ExecutionEnvironment execEnv;
    protected int platform;
    private String exeName;
    protected State state = State.NONE;

    public CndDebugger(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public abstract void firePropertyChange(String var1, Object var2, Object var3);

    public abstract void finish(boolean var1);

    public abstract InputOutput getIOTab();

    public abstract String getRunDirectory();

    public ContextProvider getContextProvider() {
        return this.lookupProvider;
    }

    public String getExecutableName() {
        return this.exeName;
    }

    public void setExecutableName(String exeName) {
        this.exeName = exeName;
    }

    public ExecutionEnvironment getHostExecutionEnvironment() {
        return this.execEnv;
    }

    public void setHostExecutionEnvironment(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    public static boolean isUnitTest() {
        return false;
    }

    public int getPlatform() {
        return this.platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state == this.state) {
            return;
        }
        State oldState = this.state;
        this.state = state;
        this.firePropertyChange(PROP_STATE, (Object)oldState, (Object)state);
    }

    public void setStarting() {
        this.setState(State.STARTING);
    }

    public void setLoading() {
        this.setState(State.LOADING);
    }

    public void setReady() {
        this.setState(State.READY);
    }

    public void setRunning() {
        this.setState(State.RUNNING);
    }

    public void setStopped() {
        this.setState(State.STOPPED);
    }

    public void setSilentStop() {
        this.setState(State.SILENT_STOP);
    }

    public void setExited() {
        this.setState(State.EXITED);
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public static enum State {
        NONE,
        STARTING,
        LOADING,
        READY,
        RUNNING,
        STOPPED,
        SILENT_STOP,
        EXITED;

    }
}

