/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class PersistenceUtils {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.persistence");

    private PersistenceUtils() {
    }

    public static PersistenceUnit[] getPersistenceUnits(FileObject fileObject) throws IOException {
        if (fileObject == null) {
            throw new NullPointerException("The sourceFile parameter cannot be null");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new PersistenceUnit[0];
        }
        ArrayList<PersistenceUnit> arrayList = new ArrayList<PersistenceUnit>();
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project)) {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                arrayList.add(persistenceUnit);
            }
        }
        return arrayList.toArray(new PersistenceUnit[arrayList.size()]);
    }

    public static Entity getEntity(String string, EntityMappings entityMappings) {
        if (string == null) {
            throw new NullPointerException("The javaClass parameter cannot be null");
        }
        if (entityMappings == null) {
            throw new NullPointerException("The entityMappings parameter cannot be null");
        }
        for (Entity entity : entityMappings.getEntity()) {
            if (!string.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static PersistenceScope[] getPersistenceScopes(Project project) {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        PersistenceScopes persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project);
        if (persistenceScopes != null) {
            return persistenceScopes.getPersistenceScopes();
        }
        return new PersistenceScope[0];
    }

    public static String getJPAVersion(Project project) {
        String string = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        SourceGroup sourceGroup = sourceGroupArray[0];
        FileObject fileObject = sourceGroup.getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        if (classPath.findResource("javax/persistence/criteria/JoinType.class") != null) {
            string = "2.0";
        } else if (classPath.findResource("javax/persistence/Entity.class") != null) {
            string = "1.0";
        }
        return string;
    }

    public static String getJPAVersion(Library library) {
        List list = library.getContent("classpath");
        ClassPath classPath = ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]));
        String string = null;
        if (classPath.findResource("javax/persistence/criteria/JoinType.class") != null) {
            string = "2.0";
        } else if (classPath.findResource("javax/persistence/Entity.class") != null) {
            string = "1.0";
        }
        return string;
    }

    public static void logUsage(Class clazz, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }
}

