/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.DocumentUtil;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;
import org.netbeans.modules.gsfret.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.openide.util.Exceptions;

class LuceneIndex
extends Index {
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    static final String REFERENCES = "gsf";
    private static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private final File refCacheRoot;
    private Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private volatile boolean closed;
    private ClassIndexImpl classIndex;
    private File cacheRoot;
    private static final FieldSelector FILE_AND_TIMESTAMP = new FieldSelector(){

        public FieldSelectorResult accept(String key) {
            return "filename".equals(key) || "timeStamp".equals(key) ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    };

    public static Index create(Language language, File cacheRoot, ClassIndexImpl classIndex) throws IOException {
        assert (cacheRoot != null && cacheRoot.exists() && cacheRoot.canRead() && cacheRoot.canWrite());
        LuceneIndex index = new LuceneIndex(language, LuceneIndex.getReferencesCacheFolder(cacheRoot));
        index.classIndex = classIndex;
        index.cacheRoot = cacheRoot;
        return index;
    }

    private LuceneIndex(Language language, File refCacheRoot) throws IOException {
        super(language);
        assert (refCacheRoot != null);
        this.refCacheRoot = refCacheRoot;
        this.directory = FSDirectory.getDirectory((File)refCacheRoot, (LockFactory)NoLockFactory.getNoLockFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regExpSearch(Pattern pattern, Term startTerm, IndexReader in, Set<Term> toSearch, boolean caseSensitive) throws IOException {
        String startPrefix;
        String startText = startTerm.text();
        if (startText.length() > 0) {
            char c;
            StringBuilder startBuilder = new StringBuilder();
            startBuilder.append(startText.charAt(0));
            for (int i = 1; i < startText.length() && Character.isJavaIdentifierPart(c = startText.charAt(i)); ++i) {
                startBuilder.append(c);
            }
            startPrefix = startBuilder.toString();
        } else {
            startPrefix = startText;
        }
        String camelField = startTerm.field();
        TermEnum en = in.terms(startTerm);
        try {
            Term term;
            while ((term = en.term()) != null && camelField == term.field() && term.text().startsWith(startPrefix)) {
                Matcher m = pattern.matcher(term.text());
                if (m.matches()) {
                    toSearch.add(term);
                }
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefixSearch(Term nameTerm, IndexReader in, Set<Term> toSearch) throws IOException {
        String prefixField = nameTerm.field();
        String name = nameTerm.text();
        TermEnum en = in.terms(nameTerm);
        try {
            Term term;
            while ((term = en.term()) != null && prefixField == term.field() && term.text().startsWith(name)) {
                toSearch.add(term);
                if (en.next()) continue;
                break;
            }
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String resourceName, long timeStamp) throws IOException {
        this.checkPreconditions();
        if (Index.isPreindexed(this.cacheRoot)) {
            return true;
        }
        if (!this.isValid(false)) {
            return false;
        }
        try {
            IndexSearcher searcher = new IndexSearcher(this.getReader());
            try {
                Hits hits;
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        if (this.rootTimeStamp != null) {
                            boolean bl = this.rootTimeStamp >= timeStamp;
                            return bl;
                        }
                    }
                    hits = searcher.search((Query)new TermQuery(DocumentUtil.rootDocumentTerm()));
                } else {
                    hits = searcher.search(DocumentUtil.binaryNameQuery(resourceName));
                }
                if (hits.length() != 1) {
                    boolean bl = false;
                    return bl;
                }
                Hit hit = (Hit)hits.iterator().next();
                long cacheTime = DocumentUtil.getTimeStamp(hit.getDocument());
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        this.rootTimeStamp = new Long(cacheTime);
                    }
                }
                boolean bl = cacheTime >= timeStamp;
                return bl;
            }
            finally {
                searcher.close();
            }
        }
        catch (IOException ioe) {
            this.clear();
            return false;
        }
    }

    @Override
    public Map<String, String> getTimeStamps() throws IOException {
        this.checkPreconditions();
        if (!this.isValid(false)) {
            return null;
        }
        IndexReader in = this.getReader();
        HashMap<String, String> result = new HashMap<String, String>(2 * in.numDocs());
        int n = in.numDocs();
        for (int i = 0; i < n; ++i) {
            if (in.isDeleted(i)) continue;
            Document document = in.document(i, FILE_AND_TIMESTAMP);
            String timestamp = document.get("timeStamp");
            String filename = document.get("filename");
            if (timestamp == null || filename == null) continue;
            result.put(filename, timestamp);
        }
        return result;
    }

    @Override
    public boolean isValid(boolean tryOpen) throws IOException {
        this.checkPreconditions();
        boolean res = false;
        try {
            res = IndexReader.indexExists((Directory)this.directory);
        }
        catch (IOException e) {
            return res;
        }
        if (res && tryOpen) {
            try {
                this.getReader();
            }
            catch (IOException e) {
                res = false;
                this.clear();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() throws IOException {
        block10: {
            this.checkPreconditions();
            this.close();
            try {
                File cacheDir;
                File[] children;
                String[] content = this.directory.list();
                boolean dirty = false;
                for (String file : content) {
                    try {
                        this.directory.deleteFile(file);
                    }
                    catch (IOException e) {
                        if (!this.directory.fileExists(file)) continue;
                        dirty = true;
                    }
                }
                if (!dirty || (children = (cacheDir = ((FSDirectory)this.directory).getFile()).listFiles()) == null) break block10;
                for (File child : children) {
                    if (child.delete()) continue;
                    Class<?> c = this.directory.getClass();
                    int refCount = -1;
                    try {
                        Field field = c.getDeclaredField("refCount");
                        field.setAccessible(true);
                        refCount = field.getInt(this.directory);
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    throw new IOException("Cannot delete: " + child.getAbsolutePath() + "(" + child.exists() + "," + child.canRead() + "," + child.canWrite() + "," + cacheDir.canRead() + "," + cacheDir.canWrite() + "," + refCount + ")");
                }
            }
            finally {
                this.directory = FSDirectory.getDirectory((File)this.refCacheRoot, (LockFactory)NoLockFactory.getNoLockFactory());
                this.closed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        finally {
            this.directory.close();
            if (PREINDEXING) {
                return;
            }
            this.closed = true;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.refCacheRoot.getAbsolutePath() + "]";
    }

    private synchronized IndexReader getReader() throws IOException {
        if (this.reader == null) {
            try {
                this.reader = IndexReader.open((Directory)this.directory);
            }
            catch (IOException ioe) {
                throw this.annotateException(ioe);
            }
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean create) throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        try {
            IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new KeywordAnalyzer(), create);
            return writer;
        }
        catch (IOException ioe) {
            throw this.annotateException(ioe);
        }
    }

    private IOException annotateException(IOException ioe) {
        String message;
        File[] children = this.refCacheRoot.listFiles();
        if (children == null) {
            message = "Non existing index folder";
        } else {
            StringBuilder b = new StringBuilder();
            for (File c : children) {
                b.append(c.getName() + " f: " + c.isFile() + " r: " + c.canRead() + " w: " + c.canWrite() + "\n");
            }
            message = b.toString();
        }
        return (IOException)Exceptions.attachMessage((Throwable)ioe, (String)message);
    }

    private static File getReferencesCacheFolder(File cacheRoot) throws IOException {
        File refRoot = new File(cacheRoot, REFERENCES);
        if (!refRoot.exists()) {
            refRoot.mkdir();
        }
        return refRoot;
    }

    private void checkPreconditions() throws ClassIndexImpl.IndexAlreadyClosedException {
        if (this.closed) {
            throw new ClassIndexImpl.IndexAlreadyClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchStore(List<IndexBatchEntry> list, boolean create) throws IOException {
        this.checkPreconditions();
        if (!create) {
            assert (ClassIndexManager.holdsWriteLock());
            IndexReader in = this.getReader();
            String prevUrl = "";
            for (IndexBatchEntry entry : list) {
                String fileUrl = entry.getFilename();
                if (fileUrl == null || fileUrl.equals(prevUrl)) continue;
                prevUrl = fileUrl;
                IndexSearcher searcher = new IndexSearcher(in);
                try {
                    if (fileUrl != null) {
                        BooleanQuery query = new BooleanQuery();
                        query.add((Query)new TermQuery(new Term("filename", fileUrl)), BooleanClause.Occur.MUST);
                        Hits hits = searcher.search((Query)query);
                        for (int i = 0; i < hits.length(); ++i) {
                            in.deleteDocument(hits.id(i));
                        }
                    }
                    in.deleteDocuments(DocumentUtil.rootDocumentTerm());
                }
                finally {
                    searcher.close();
                }
            }
        }
        long timeStamp = System.currentTimeMillis();
        IndexWriter out = this.getWriter(create);
        try {
            LuceneIndexMBeanImpl indexSettings;
            if (debugIndexMerging) {
                out.setInfoStream(System.err);
            }
            if ((indexSettings = LuceneIndexMBeanImpl.getDefault()) != null) {
                out.setMergeFactor(indexSettings.getMergeFactor());
                out.setMaxMergeDocs(indexSettings.getMaxMergeDocs());
                out.setMaxBufferedDocs(indexSettings.getMaxBufferedDocs());
            }
            LowMemoryNotifier lm = LowMemoryNotifier.getDefault();
            LMListener lmListener = new LMListener();
            lm.addLowMemoryListener(lmListener);
            RAMDirectory memDir = null;
            IndexWriter activeOut = null;
            if (lmListener.lowMemory.getAndSet(false)) {
                activeOut = out;
            } else {
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true);
            }
            try {
                activeOut.addDocument(DocumentUtil.createRootTimeStampDocument(timeStamp));
                for (IndexBatchEntry entry : list) {
                    String filename = entry.getFilename();
                    List<IndexDocumentImpl> documents = entry.getDocuments();
                    if (documents != null && documents.size() > 0) {
                        String createEmptyUrl = null;
                        for (IndexDocumentImpl document : documents) {
                            org.apache.lucene.document.Field field;
                            String value;
                            String key;
                            int i;
                            Document newDoc = new Document();
                            newDoc.add((Fieldable)new org.apache.lucene.document.Field("timeStamp", DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                            if (document.overrideUrl != null) {
                                newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", document.overrideUrl, Field.Store.YES, Field.Index.UN_TOKENIZED));
                                createEmptyUrl = filename;
                            } else if (filename != null) {
                                newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", filename, Field.Store.YES, Field.Index.UN_TOKENIZED));
                            }
                            int n = document.indexedKeys.size();
                            for (i = 0; i < n; ++i) {
                                key = document.indexedKeys.get(i);
                                value = document.indexedValues.get(i);
                                assert (key != null && value != null) : "key=" + key + ", value=" + value;
                                field = new org.apache.lucene.document.Field(key, value, Field.Store.YES, Field.Index.UN_TOKENIZED);
                                newDoc.add((Fieldable)field);
                            }
                            n = document.unindexedKeys.size();
                            for (i = 0; i < n; ++i) {
                                key = document.unindexedKeys.get(i);
                                value = document.unindexedValues.get(i);
                                assert (key != null && value != null) : "key=" + key + ", value=" + value;
                                field = new org.apache.lucene.document.Field(key, value, Field.Store.YES, Field.Index.NO);
                                newDoc.add((Fieldable)field);
                            }
                            activeOut.addDocument(newDoc);
                        }
                        if (createEmptyUrl == null) continue;
                        Document newDoc = new Document();
                        newDoc.add((Fieldable)new org.apache.lucene.document.Field("timeStamp", DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                        newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", createEmptyUrl, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        activeOut.addDocument(newDoc);
                        continue;
                    }
                    if (filename == null || documents == null) continue;
                    Document newDoc = new Document();
                    newDoc.add((Fieldable)new org.apache.lucene.document.Field("timeStamp", DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                    newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", filename, Field.Store.YES, Field.Index.UN_TOKENIZED));
                    activeOut.addDocument(newDoc);
                }
                if (memDir != null && lmListener.lowMemory.getAndSet(false)) {
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    memDir = new RAMDirectory();
                    activeOut = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true);
                }
                if (memDir != null) {
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    activeOut = null;
                    memDir = null;
                }
                LuceneIndex luceneIndex = this;
                synchronized (luceneIndex) {
                    this.rootTimeStamp = new Long(timeStamp);
                }
            }
            finally {
                lm.removeLowMemoryListener(lmListener);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String fileUrl, List<IndexDocument> documents) throws IOException {
        boolean create;
        this.checkPreconditions();
        assert (ClassIndexManager.holdsWriteLock());
        boolean bl = create = !this.isValid(false);
        if (!create) {
            IndexReader in = this.getReader();
            IndexSearcher searcher = new IndexSearcher(in);
            try {
                if (fileUrl != null) {
                    BooleanQuery query = new BooleanQuery();
                    query.add((Query)new TermQuery(new Term("filename", fileUrl)), BooleanClause.Occur.MUST);
                    Hits hits = searcher.search((Query)query);
                    for (int i = 0; i < hits.length(); ++i) {
                        in.deleteDocument(hits.id(i));
                    }
                }
                in.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            finally {
                searcher.close();
            }
        }
        long timeStamp = System.currentTimeMillis();
        if (documents != null) {
            this.store(documents, create, timeStamp, fileUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(List<IndexDocument> d, boolean create, long timeStamp, String filename) throws IOException {
        List<IndexDocument> documents = d;
        IndexWriter out = this.getWriter(create);
        try {
            LuceneIndexMBeanImpl indexSettings;
            if (debugIndexMerging) {
                out.setInfoStream(System.err);
            }
            if ((indexSettings = LuceneIndexMBeanImpl.getDefault()) != null) {
                out.setMergeFactor(indexSettings.getMergeFactor());
                out.setMaxMergeDocs(indexSettings.getMaxMergeDocs());
                out.setMaxBufferedDocs(indexSettings.getMaxBufferedDocs());
            }
            LowMemoryNotifier lm = LowMemoryNotifier.getDefault();
            LMListener lmListener = new LMListener();
            lm.addLowMemoryListener(lmListener);
            RAMDirectory memDir = null;
            IndexWriter activeOut = null;
            if (lmListener.lowMemory.getAndSet(false)) {
                activeOut = out;
            } else {
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true);
            }
            try {
                activeOut.addDocument(DocumentUtil.createRootTimeStampDocument(timeStamp));
                if (documents != null && documents.size() > 0) {
                    for (IndexDocumentImpl indexDocumentImpl : documents) {
                        org.apache.lucene.document.Field field;
                        String value;
                        String key;
                        int i;
                        Document newDoc = new Document();
                        newDoc.add((Fieldable)new org.apache.lucene.document.Field("timeStamp", DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                        if (indexDocumentImpl.overrideUrl != null) {
                            newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", indexDocumentImpl.overrideUrl, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        } else if (filename != null) {
                            newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", filename, Field.Store.YES, Field.Index.UN_TOKENIZED));
                        }
                        int n = indexDocumentImpl.indexedKeys.size();
                        for (i = 0; i < n; ++i) {
                            key = indexDocumentImpl.indexedKeys.get(i);
                            value = indexDocumentImpl.indexedValues.get(i);
                            assert (key != null && value != null) : "key=" + key + ", value=" + value;
                            field = new org.apache.lucene.document.Field(key, value, Field.Store.YES, Field.Index.UN_TOKENIZED);
                            newDoc.add((Fieldable)field);
                        }
                        n = indexDocumentImpl.unindexedKeys.size();
                        for (i = 0; i < n; ++i) {
                            key = indexDocumentImpl.unindexedKeys.get(i);
                            value = indexDocumentImpl.unindexedValues.get(i);
                            assert (key != null && value != null) : "key=" + key + ", value=" + value;
                            field = new org.apache.lucene.document.Field(key, value, Field.Store.YES, Field.Index.NO);
                            newDoc.add((Fieldable)field);
                        }
                        activeOut.addDocument(newDoc);
                    }
                } else if (filename != null) {
                    Document newDoc = new Document();
                    newDoc.add((Fieldable)new org.apache.lucene.document.Field("timeStamp", DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO));
                    newDoc.add((Fieldable)new org.apache.lucene.document.Field("filename", filename, Field.Store.YES, Field.Index.UN_TOKENIZED));
                    activeOut.addDocument(newDoc);
                }
                if (memDir != null && lmListener.lowMemory.getAndSet(false)) {
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    memDir = new RAMDirectory();
                    activeOut = new IndexWriter((Directory)memDir, (Analyzer)new KeywordAnalyzer(), true);
                }
                if (memDir != null) {
                    activeOut.close();
                    out.addIndexes(new Directory[]{memDir});
                    activeOut = null;
                    memDir = null;
                }
                LuceneIndex luceneIndex = this;
                synchronized (luceneIndex) {
                    this.rootTimeStamp = new Long(timeStamp);
                }
            }
            finally {
                lm.removeLowMemoryListener(lmListener);
            }
        }
        finally {
            out.close();
        }
    }

    public void search(String primaryField, String name, NameKind kind, Set<Index.SearchScope> scope, Set<Index.SearchResult> result, Set<String> terms) throws IOException {
        this.checkPreconditions();
        if (!this.isValid(false)) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        assert (name != null);
        TreeSet<Term> toSearch = new TreeSet<Term>(new TermComparator());
        IndexReader in = this.getReader();
        switch (kind) {
            case EXACT_NAME: {
                toSearch.add(new Term(primaryField, name));
                break;
            }
            case PREFIX: {
                if (name.length() == 0) {
                    if (terms != null && terms.size() > 0) {
                        this.gsfEmptyPrefixSearch(in, result, terms);
                    } else {
                        this.gsfEmptyPrefixSearch(in, result, Collections.singleton(primaryField));
                    }
                    return;
                }
                Term nameTerm = new Term(primaryField, name);
                this.prefixSearch(nameTerm, in, toSearch);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (name.length() == 0) {
                    if (terms != null && terms.size() > 0) {
                        this.gsfEmptyPrefixSearch(in, result, terms);
                    } else {
                        this.gsfEmptyPrefixSearch(in, result, Collections.singleton(primaryField));
                    }
                    return;
                }
                Term nameTerm = new Term(primaryField, name.toLowerCase());
                this.prefixSearch(nameTerm, in, toSearch);
                break;
            }
            case CAMEL_CASE: {
                int index;
                if (name.length() == 0) {
                    this.search(primaryField, name, NameKind.CASE_INSENSITIVE_PREFIX, scope, result, terms);
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = name.substring(lastIndex, (index = LuceneIndex.findNextUpper(name, lastIndex + 1)) == -1 ? name.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                Term nameTerm = new Term(primaryField, prefix);
                this.regExpSearch(pattern, nameTerm, in, toSearch, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (name.length() == 0) {
                    this.search(primaryField, name, NameKind.CASE_INSENSITIVE_PREFIX, scope, result, terms);
                    return;
                }
                Pattern pattern = Pattern.compile(name, 2);
                if (Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.regExpSearch(pattern, new Term(primaryField, name.toLowerCase()), in, toSearch, false);
                    break;
                }
                this.regExpSearch(pattern, new Term(primaryField, ""), in, toSearch, false);
                break;
            }
            case REGEXP: {
                if (name.length() == 0) {
                    this.search(primaryField, name, NameKind.PREFIX, scope, result, terms);
                    return;
                }
                Pattern pattern = Pattern.compile(name);
                if (Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.regExpSearch(pattern, new Term(primaryField, name), in, toSearch, true);
                    break;
                }
                this.regExpSearch(pattern, new Term(primaryField, ""), in, toSearch, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        TermDocs tds = in.termDocs();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), toSearch.size()));
        }
        Iterator it = toSearch.iterator();
        TreeSet<Integer> docNums = new TreeSet<Integer>();
        HashMap<Integer, ArrayList<String>> matches = new HashMap<Integer, ArrayList<String>>();
        while (it.hasNext()) {
            Term next = (Term)it.next();
            tds.seek(next);
            while (tds.next()) {
                Integer docNum = tds.doc();
                ArrayList<String> matchTerms = (ArrayList<String>)matches.get(docNum);
                if (matchTerms == null) {
                    matchTerms = new ArrayList<String>();
                    matches.put(docNum, matchTerms);
                }
                matchTerms.add(next.text());
                docNums.add(docNum);
            }
        }
        for (Integer docNum : docNums) {
            Document doc = in.document(docNum.intValue());
            List matchList = (List)matches.get(docNum);
            FilteredDocumentSearchResult map = new FilteredDocumentSearchResult(doc, primaryField, matchList, docNum);
            result.add(map);
        }
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private <T> void gsfEmptyPrefixSearch(IndexReader in, Set<Index.SearchResult> result, Set<String> terms) throws IOException {
        int bound = in.maxDoc();
        CustomFieldSelector fieldSelector = new CustomFieldSelector(terms);
        for (int i = 0; i < bound; ++i) {
            Document doc;
            if (in.isDeleted(i) || (doc = in.document(i, (FieldSelector)fieldSelector)) == null) continue;
            DocumentSearchResult map = new DocumentSearchResult(doc, i);
            result.add(map);
        }
    }

    public IndexReader getDumpIndexReader() throws IOException {
        return this.getReader();
    }

    private static class TermComparator
    implements Comparator<Term> {
        private TermComparator() {
        }

        @Override
        public int compare(Term t1, Term t2) {
            int ret = t1.field().compareTo(t2.field());
            if (ret == 0) {
                ret = t1.text().compareTo(t2.text());
            }
            return ret;
        }
    }

    private class FilteredDocumentSearchResult
    implements Index.SearchResult {
        private Document doc;
        private int docId;
        private String primaryKey;
        private List<String> primaryValues;

        private FilteredDocumentSearchResult(Document doc, String primaryKey, List<String> primaryValues, int docId) {
            this.doc = doc;
            this.primaryKey = primaryKey;
            this.primaryValues = primaryValues;
            this.docId = docId;
        }

        public String getValue(String key) {
            if (key.equals(this.primaryKey)) {
                if (this.primaryValues.size() > 0) {
                    return this.primaryValues.get(0);
                }
                return null;
            }
            return this.doc.get(key);
        }

        public String[] getValues(String key) {
            if (key.equals(this.primaryKey)) {
                return this.primaryValues.toArray(new String[this.primaryValues.size()]);
            }
            return this.doc.getValues(key);
        }

        public String getPersistentUrl() {
            return this.getValue("filename");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Enumeration en = this.doc.fields();
            while (en.hasMoreElements()) {
                org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)en.nextElement();
                if (f.name().equals(this.primaryKey)) {
                    sb.append(this.primaryKey);
                    sb.append(":");
                    sb.append(this.primaryValues.toString());
                } else {
                    sb.append(f.name());
                    sb.append(":");
                    sb.append(f.stringValue());
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        public int getDocumentNumber() {
            return this.docId;
        }

        public Object getDocument() {
            return this.doc;
        }

        public Object getIndexReader() {
            try {
                return LuceneIndex.this.getReader();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return null;
            }
        }

        public Object getIndex() {
            return LuceneIndex.this.classIndex;
        }

        public File getSegment() {
            return LuceneIndex.this.cacheRoot;
        }
    }

    private class DocumentSearchResult
    implements Index.SearchResult {
        private Document doc;
        private int docId;

        private DocumentSearchResult(Document doc, int docId) {
            this.doc = doc;
            this.docId = docId;
        }

        public String getValue(String key) {
            return this.doc.get(key);
        }

        public String[] getValues(String key) {
            return this.doc.getValues(key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Enumeration en = this.doc.fields();
            while (en.hasMoreElements()) {
                org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)en.nextElement();
                sb.append(f.name());
                sb.append(":");
                sb.append(f.stringValue());
                sb.append("\n");
            }
            return sb.toString();
        }

        public int getDocumentNumber() {
            return this.docId;
        }

        public Object getDocument() {
            return this.doc;
        }

        public Object getIndexReader() {
            try {
                return LuceneIndex.this.getReader();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return null;
            }
        }

        public Object getIndex() {
            return LuceneIndex.this.classIndex;
        }

        public File getSegment() {
            return LuceneIndex.this.cacheRoot;
        }

        public String getPersistentUrl() {
            return this.getValue("filename");
        }
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        @Override
        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }

    private static class CustomFieldSelector
    implements FieldSelector {
        private Set<String> includeFields;

        CustomFieldSelector(Set<String> includeFields) {
            this.includeFields = includeFields;
        }

        public FieldSelectorResult accept(String key) {
            boolean include = this.includeFields.contains(key) || key.equals("filename");
            return include ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    }
}

