/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.util.concurrent.TimeoutException;
import org.junit.runners.model.Statement;

public class SpringFailOnTimeout
extends Statement {
    private final Statement next;
    private final long timeout;

    public SpringFailOnTimeout(Statement next, long timeout) {
        this.next = next;
        this.timeout = timeout;
    }

    public void evaluate() throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            this.next.evaluate();
        }
        catch (Throwable throwable) {
            long elapsed = System.currentTimeMillis() - startTime;
            if (elapsed > this.timeout) {
                throw new TimeoutException(String.format("Test took %s ms; limit was %s ms.", elapsed, this.timeout));
            }
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed > this.timeout) {
            throw new TimeoutException(String.format("Test took %s ms; limit was %s ms.", elapsed, this.timeout));
        }
    }
}

