/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.search.BufferedCharSequence;
import org.netbeans.modules.search.RegexpMaker;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openidex.search.SearchPattern;

final class BasicSearchCriteria {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static int instanceCounter;
    private final int instanceId = instanceCounter++;
    private static final Logger LOG;
    private static final Collection<String> searchableXMimeTypes;
    private String textPatternExpr;
    private String fileNamePatternExpr;
    private String replaceExpr;
    private String replaceString;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean regexp;
    private boolean textPatternSpecified = false;
    private boolean fileNamePatternSpecified = false;
    private boolean textPatternValid = false;
    private boolean replacePatternValid = false;
    private boolean fileNamePatternValid = false;
    private Pattern textPattern;
    private Pattern fileNamePattern;
    private boolean criteriaUsable = false;
    private ChangeListener usabilityChangeListener;
    private static Pattern patternCR;
    private static Pattern patternLineSeparator;
    private Charset lastCharset = null;
    private Map<DataObject, List<TextDetail>> detailsMap;
    private DataObject dataObject;

    BasicSearchCriteria() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>()");
        }
    }

    BasicSearchCriteria(BasicSearchCriteria template) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>(template)");
        }
        this.setCaseSensitive(template.caseSensitive);
        this.setWholeWords(template.wholeWords);
        this.setRegexp(template.regexp);
        this.setTextPattern(template.textPatternExpr);
        this.setFileNamePattern(template.fileNamePatternExpr);
        this.setReplaceExpr(template.replaceExpr);
    }

    Pattern getTextPattern() {
        if (!this.textPatternValid) {
            return null;
        }
        if (this.textPattern != null) {
            return this.textPattern;
        }
        if (this.regexp) {
            this.textPatternValid = this.compileRegexpPattern();
        } else {
            this.compileSimpleTextPattern();
            boolean bl = this.textPatternValid = this.textPattern != null;
        }
        assert (this.textPattern != null);
        return this.textPattern;
    }

    String getTextPatternExpr() {
        return this.textPatternExpr != null ? this.textPatternExpr : "";
    }

    void setTextPattern(String pattern) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setTextPattern(" + pattern + ')');
        }
        if (pattern != null && pattern.length() == 0) {
            pattern = null;
        }
        if (pattern == null && this.textPatternExpr == null || pattern != null && pattern.equals(this.textPatternExpr)) {
            LOG.finest(" - no change");
            return;
        }
        if (pattern == null) {
            this.textPatternExpr = null;
            this.textPattern = null;
            this.textPatternSpecified = false;
            this.textPatternValid = false;
        } else {
            this.textPatternExpr = pattern;
            this.textPatternSpecified = true;
            if (!this.regexp) {
                this.textPattern = null;
                this.textPatternValid = true;
            } else {
                this.textPatternValid = this.compileRegexpPattern();
                assert (this.textPattern != null || !this.textPatternValid);
            }
        }
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability();
    }

    private boolean compileRegexpPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (this.regexp);
        assert (this.textPatternExpr != null);
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            int flags = 0;
            if (!this.caseSensitive) {
                flags |= 2;
                flags |= 0x40;
            }
            this.textPattern = Pattern.compile(this.textPatternExpr, flags |= 8);
            return true;
        }
        catch (PatternSyntaxException ex) {
            LOG.finest(" - invalid regexp - setting 'textPattern' to <null>");
            this.textPattern = null;
            return false;
        }
    }

    private boolean validateReplacePattern() {
        if (this.regexp && this.textPatternValid) {
            int groups = this.getTextPattern().matcher("").groupCount();
            String tmpSearch = "";
            for (int i = 1; i <= groups; ++i) {
                tmpSearch = tmpSearch + "(" + i + ")";
            }
            try {
                Pattern.compile(tmpSearch).matcher("123456789").replaceFirst(this.replaceExpr);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private void compileSimpleTextPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (this.textPatternExpr != null);
        try {
            int flags = 0;
            if (!this.caseSensitive) {
                flags |= 2;
                flags |= 0x40;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            String searchRegexp = RegexpMaker.makeRegexp(this.textPatternExpr, this.wholeWords);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - regexp = \"" + searchRegexp + '\"');
            }
            this.textPattern = Pattern.compile(searchRegexp, flags);
        }
        catch (PatternSyntaxException ex) {
            LOG.finest(" - invalid regexp");
            assert (false);
            this.textPattern = null;
        }
    }

    boolean isRegexp() {
        return this.regexp;
    }

    void setRegexp(boolean regexp) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setRegexp(" + regexp + ')');
        }
        if (regexp == this.regexp) {
            LOG.finest(" - no change");
            return;
        }
        this.regexp = regexp;
        if (this.textPatternExpr != null) {
            if (regexp) {
                this.textPatternValid = this.compileRegexpPattern();
            } else {
                this.textPatternValid = true;
                this.textPattern = null;
            }
        }
        this.replacePatternValid = this.validateReplacePattern();
        this.updateUsability();
    }

    boolean isWholeWords() {
        return this.wholeWords;
    }

    void setWholeWords(boolean wholeWords) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setWholeWords(" + wholeWords + ')');
        }
        if (wholeWords == this.wholeWords) {
            LOG.finest(" - no change");
            return;
        }
        this.wholeWords = wholeWords;
        if (!this.regexp) {
            this.textPattern = null;
        }
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean caseSensitive) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setCaseSensitive(" + caseSensitive + ')');
        }
        if (caseSensitive == this.caseSensitive) {
            LOG.finest(" - no change");
            return;
        }
        this.caseSensitive = caseSensitive;
        this.textPattern = null;
    }

    boolean isFullText() {
        return this.textPatternValid;
    }

    Pattern getFileNamePattern() {
        if (!this.fileNamePatternValid) {
            return null;
        }
        assert (this.fileNamePatternExpr != null && this.fileNamePatternExpr.length() != 0);
        if (this.fileNamePattern != null) {
            return this.fileNamePattern;
        }
        this.compileSimpleFileNamePattern();
        assert (this.fileNamePattern != null);
        return this.fileNamePattern;
    }

    String getFileNamePatternExpr() {
        return this.fileNamePatternExpr != null ? this.fileNamePatternExpr : "";
    }

    void setFileNamePattern(String pattern) {
        if (pattern != null && pattern.length() == 0) {
            pattern = null;
        }
        if (pattern == null && this.fileNamePatternExpr == null || pattern != null && pattern.equals(this.fileNamePatternExpr)) {
            return;
        }
        if (pattern == null) {
            this.fileNamePatternExpr = null;
            this.fileNamePattern = null;
            this.fileNamePatternSpecified = false;
            this.fileNamePatternValid = false;
        } else {
            this.fileNamePatternExpr = pattern;
            this.fileNamePattern = null;
            this.fileNamePatternValid = this.fileNamePatternSpecified = BasicSearchCriteria.checkFileNamePattern(this.fileNamePatternExpr);
        }
        this.updateUsability();
    }

    private void compileSimpleFileNamePattern() {
        assert (this.fileNamePatternExpr != null);
        try {
            this.fileNamePattern = Pattern.compile(RegexpMaker.makeMultiRegexp(this.fileNamePatternExpr), 2);
        }
        catch (PatternSyntaxException ex) {
            assert (false);
            this.fileNamePattern = null;
        }
    }

    private static boolean checkFileNamePattern(String fileNamePatternExpr) {
        if (fileNamePatternExpr.length() == 0) {
            return false;
        }
        for (char c : fileNamePatternExpr.toCharArray()) {
            if (c == ',' || c == ' ') continue;
            return true;
        }
        return false;
    }

    boolean isSearchAndReplace() {
        return this.replaceExpr != null;
    }

    String getReplaceExpr() {
        return this.replaceExpr;
    }

    String getReplaceString() {
        if (this.replaceString == null && this.replaceExpr != null) {
            String[] sGroups = this.replaceExpr.split("\\\\\\\\", this.replaceExpr.length());
            String res = "";
            for (int i = 0; i < sGroups.length; ++i) {
                String tmp = sGroups[i];
                tmp = tmp.replace("\\r", "\r");
                tmp = tmp.replace("\\n", "\n");
                tmp = tmp.replace("\\t", "\t");
                res = res + tmp;
                if (i == sGroups.length - 1) continue;
                res = res + "\\\\";
            }
            this.replaceString = res;
        }
        return this.replaceString;
    }

    void setReplaceExpr(String replaceExpr) {
        this.replaceExpr = replaceExpr;
        this.replaceString = null;
        this.replacePatternValid = this.validateReplacePattern();
    }

    private void updateUsability() {
        boolean wasUsable = this.criteriaUsable;
        this.criteriaUsable = this.isUsable();
        if (this.criteriaUsable != wasUsable) {
            this.fireUsabilityChanged();
        }
    }

    boolean isUsable() {
        return (this.textPatternSpecified || !this.isSearchAndReplace() && this.fileNamePatternSpecified) && !this.isInvalid();
    }

    private boolean isInvalid() {
        return this.isTextPatternInvalid() || this.isFileNamePatternInvalid();
    }

    void setUsabilityChangeListener(ChangeListener l) {
        this.usabilityChangeListener = l;
    }

    private void fireUsabilityChanged() {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    boolean isTextPatternUsable() {
        return this.textPatternSpecified && this.textPatternValid;
    }

    boolean isTextPatternInvalid() {
        return this.textPatternSpecified && !this.textPatternValid;
    }

    boolean isReplacePatternInvalid() {
        return !this.replacePatternValid;
    }

    boolean isFileNamePatternUsable() {
        return this.fileNamePatternSpecified && this.fileNamePatternValid;
    }

    boolean isFileNamePatternInvalid() {
        return this.fileNamePatternSpecified && !this.fileNamePatternValid;
    }

    void onOk() {
        LOG.finer("onOk()");
        if (this.textPatternValid && this.textPattern == null) {
            if (this.regexp) {
                this.compileRegexpPattern();
            } else {
                this.compileSimpleTextPattern();
            }
        }
        if (this.fileNamePatternValid && this.fileNamePattern == null) {
            this.compileSimpleFileNamePattern();
        }
        assert (!this.textPatternValid || this.textPattern != null);
        assert (!this.fileNamePatternValid || this.fileNamePattern != null);
    }

    boolean matches(DataObject dataObj) {
        return this.matches(dataObj.getPrimaryFile());
    }

    boolean matches(FileObject fileObj) {
        this.lastCharset = null;
        if (!fileObj.isValid()) {
            return false;
        }
        if (fileObj.isFolder() || !fileObj.isValid() || this.isFullText() && !BasicSearchCriteria.isTextFile(fileObj)) {
            return false;
        }
        if (this.fileNamePatternValid && !this.fileNamePattern.matcher(fileObj.getNameExt()).matches()) {
            return false;
        }
        return !this.textPatternValid || this.checkFileContent(fileObj);
    }

    Charset getLastUsedCharset() {
        return this.lastCharset;
    }

    private static boolean isTextFile(FileObject fileObj) {
        String mimeType = fileObj.getMIMEType();
        if (mimeType.equals("content/unknown")) {
            return fileObj.getSize() <= 0x500000L;
        }
        if (mimeType.startsWith("text/")) {
            return true;
        }
        if (mimeType.startsWith("application/")) {
            String subtype = mimeType.substring(12);
            return subtype.equals("rtf") || subtype.equals("sgml") || subtype.startsWith("xml-") || subtype.endsWith("+xml") || subtype.startsWith("x-") && searchableXMimeTypes.contains(subtype.substring(2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileContent(FileObject fo) {
        block29: {
            boolean bl;
            this.lastCharset = FileEncodingQuery.getEncoding((FileObject)fo);
            SearchPattern sp = this.createSearchPattern();
            BufferedCharSequence bcs = null;
            try {
                FileInputStream fis = (FileInputStream)fo.getInputStream();
                bcs = new BufferedCharSequence(fis, this.lastCharset);
                ArrayList<TextDetail> txtDetails = this.getTextDetails(bcs, fo, sp);
                if (txtDetails.isEmpty()) {
                    boolean bl2 = false;
                    return bl2;
                }
                assert (this.dataObject != null);
                this.getDetailsMap().put(this.dataObject, txtDetails);
                this.freeDataObject();
                bl = true;
            }
            catch (DataObjectNotFoundException e) {
                LOG.severe("Unable to get data object for the " + fo);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", e);
                break block29;
            }
            catch (FileNotFoundException e) {
                LOG.severe("Unable to get input stream for the " + fo);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", e);
                break block29;
            }
            catch (BufferedCharSequence.SourceIOException e) {
                LOG.severe("IOException during process for the " + fo);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", e);
                break block29;
            }
            catch (Exception e) {
                LOG.severe("Unexpected Exception during process for the " + fo);
                LOG.throwing(BasicSearchCriteria.class.getName(), "checkFileContent", e);
                break block29;
            }
            finally {
                if (bcs != null) {
                    try {
                        bcs.close();
                    }
                    catch (IOException ex) {}
                }
            }
            return bl;
        }
        return false;
    }

    private ArrayList<TextDetail> getTextDetails(BufferedCharSequence bcs, FileObject fo, SearchPattern sp) throws BufferedCharSequence.SourceIOException, DataObjectNotFoundException {
        ArrayList<TextDetail> txtDetails = new ArrayList<TextDetail>();
        FindState fs = new FindState(bcs);
        Matcher matcher = this.textPattern.matcher(bcs);
        while (matcher.find()) {
            int matcherStart = matcher.start();
            int column = fs.calcColumn(matcherStart);
            int lineNumber = fs.getLineNumber();
            String lineText = fs.getLineText();
            this.findDataObject(fo);
            TextDetail det = this.newTextDetail(sp, matcher);
            det.associate(lineNumber, column, lineText);
            txtDetails.add(det);
        }
        txtDetails.trimToSize();
        return txtDetails;
    }

    private TextDetail newTextDetail(SearchPattern searchPattern, Matcher matcher) {
        String group = matcher.group();
        int start = matcher.start();
        int end = matcher.end();
        int countCR = this.countCR(group);
        int markLength = end - start - countCR;
        assert (this.dataObject != null);
        TextDetail det = new TextDetail(this.dataObject, searchPattern);
        det.setMatchedText(group);
        det.setStartOffset(start);
        det.setEndOffset(end);
        det.setMarkLength(markLength);
        return det;
    }

    private int countCR(String s) {
        Matcher matcherCR = patternCR.matcher(s);
        int countCR = 0;
        while (matcherCR.find()) {
            ++countCR;
        }
        return countCR;
    }

    public Node[] getDetails(Object resultObject) {
        List<TextDetail> details = this.getDetailsMap().get(resultObject);
        if (details == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> detailNodes = new ArrayList<TextDetail.DetailNode>(details.size());
        for (TextDetail txtDetail : details) {
            detailNodes.add(new TextDetail.DetailNode(txtDetail));
        }
        return detailNodes.toArray(new Node[detailNodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DataObject, List<TextDetail>> getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        BasicSearchCriteria basicSearchCriteria = this;
        synchronized (basicSearchCriteria) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap<DataObject, List<TextDetail>>(20);
            }
        }
        return this.detailsMap;
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object resultObject) {
        List<TextDetail> details = this.getDetailsMap().get(resultObject);
        return details != null ? details.size() : 0;
    }

    public List<TextDetail> getTextDetails(Object resultObject) {
        List<TextDetail> obtained = this.getDetailsMap().get(resultObject);
        return obtained != null ? new ArrayList<TextDetail>(obtained) : null;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.create((String)this.textPatternExpr, (boolean)this.wholeWords, (boolean)this.caseSensitive, (boolean)this.regexp);
    }

    private void findDataObject(FileObject fo) throws DataObjectNotFoundException {
        if (this.dataObject == null) {
            this.dataObject = DataObject.find((FileObject)fo);
        }
    }

    private void freeDataObject() {
        this.dataObject = null;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.BasicSearchCriteria");
        searchableXMimeTypes = new HashSet<String>(17);
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
        patternCR = Pattern.compile("\r");
        patternLineSeparator = Pattern.compile("(?:\r\n|\n|\r)");
    }

    private class FindState {
        int lineNumber = 1;
        int lineStartOffset = 0;
        int prevCR = 0;
        BufferedCharSequence bcs;

        FindState(BufferedCharSequence bcs) {
            this.bcs = bcs;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        String getLineText() {
            return this.bcs.getLineText(this.lineStartOffset);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int calcColumn(int matcherStart) {
            try {
                block6: while (this.bcs.position() < matcherStart) {
                    char curChar = this.bcs.nextChar();
                    switch (curChar) {
                        case '\n': 
                        case '\f': 
                        case '\u0085': 
                        case '\u2028': 
                        case '\u2029': {
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                        case '\r': {
                            ++this.prevCR;
                            char nextChar = this.bcs.charAt(this.bcs.position());
                            if (nextChar == '\n') continue block6;
                            ++this.lineNumber;
                            this.lineStartOffset = this.bcs.position();
                            this.prevCR = 0;
                            continue block6;
                        }
                    }
                    this.prevCR = 0;
                }
                return matcherStart - this.lineStartOffset + 1 - this.prevCR;
            }
            catch (IndexOutOfBoundsException ioobe) {
                // empty catch block
            }
            return matcherStart - this.lineStartOffset + 1 - this.prevCR;
        }
    }
}

