/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class BiVariableMap
implements Map<String, Object> {
    private final LocalContextProvider provider;
    private final boolean lazy;
    private List<String> varNames;
    private List<BiVariable> variables;

    public BiVariableMap(LocalContextProvider provider, boolean lazy) {
        this.provider = provider;
        this.lazy = lazy;
    }

    public List<String> getNames() {
        return this.varNames == null ? (this.varNames = new ArrayList<String>()) : this.varNames;
    }

    public List<BiVariable> getVariables() {
        return this.variables == null ? (this.variables = new ArrayList<BiVariable>()) : this.variables;
    }

    public Ruby getRuntime() {
        return this.provider.getRuntime();
    }

    public LocalVariableBehavior getLocalVariableBehavior() {
        return this.provider.getLocalVariableBehavior();
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.variables != null) {
            for (BiVariable var : this.getVariables()) {
                map.put(var.getName(), var.getJavaObject());
            }
        }
        return map;
    }

    @Override
    public int size() {
        return this.variables == null ? 0 : this.variables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.variables == null || this.variables.isEmpty();
    }

    private static String checkKey(Object key2) {
        if (key2 == null) {
            throw new NullPointerException("key is null");
        }
        if (!(key2 instanceof String)) {
            throw new ClassCastException("key is NOT String");
        }
        if (((String)key2).isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        return (String)key2;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (this.varNames == null || key2 == null) {
            return false;
        }
        return this.varNames.contains(BiVariableMap.checkKey(key2));
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.variables == null || value2 == null) {
            return false;
        }
        for (BiVariable var : this.getVariables()) {
            if (!value2.equals(var.getJavaObject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key2) {
        return this.get(null, key2);
    }

    public Object get(Object receiver2, Object key2) {
        BiVariable var;
        BiVariableMap.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        if (this.isLazy()) {
            VariableInterceptor.tryLazyRetrieval(this.provider.getLocalVariableBehavior(), this, robj, key2);
        }
        return (var = this.getVariable(robj, (String)key2)) == null ? null : var.getJavaObject();
    }

    private RubyObject getReceiverObject(Object receiver2) {
        if (receiver2 instanceof RubyObject) {
            return (RubyObject)receiver2;
        }
        return this.getTopSelf();
    }

    private RubyObject getTopSelf() {
        return (RubyObject)this.getRuntime().getTopSelf();
    }

    public BiVariable getVariable(String name2) {
        return this.getVariable(this.getTopSelf(), name2);
    }

    public BiVariable getVariable(RubyObject receiver2, String name2) {
        if (this.variables == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            BiVariable var;
            if (!name2.equals(this.getNames().get(i2)) || (var = this.getVariables().get(i2)) == null || !var.isReceiverIdentical(receiver2)) continue;
            return var;
        }
        return null;
    }

    public void setVariable(BiVariable var) {
        this.setVariable(this.getTopSelf(), var);
    }

    public void setVariable(RubyObject receiver2, BiVariable var) {
        if (var == null) {
            return;
        }
        String key2 = var.getName();
        BiVariable old = this.getVariable(receiver2, key2);
        if (old != null) {
            old.setJavaObject(receiver2.getRuntime(), var.getJavaObject());
        } else {
            this.update(key2, var);
        }
    }

    @Override
    public Object put(String key2, Object value2) {
        return this.put(null, key2, value2);
    }

    public Object put(Object receiver2, String key2, Object value2) {
        BiVariableMap.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        String name2 = key2.intern();
        BiVariable var = this.getVariable(robj, name2);
        Object oldValue = null;
        if (var != null) {
            oldValue = var.getJavaObject();
            var.setJavaObject(robj.getRuntime(), value2);
        } else {
            var = VariableInterceptor.getVariableInstance(this.provider.getLocalVariableBehavior(), robj, name2, value2);
            if (var != null) {
                this.update(name2, var);
            }
        }
        return oldValue;
    }

    public String[] getLocalVarNames() {
        if (this.variables == null) {
            return new String[0];
        }
        ArrayList<String> localVarNames = new ArrayList<String>();
        for (BiVariable var : this.variables) {
            if (var.getType() != BiVariable.Type.LocalVariable) continue;
            localVarNames.add(var.getName());
        }
        return localVarNames.toArray(new String[localVarNames.size()]);
    }

    public IRubyObject[] getLocalVarValues() {
        if (this.variables == null) {
            return IRubyObject.NULL_ARRAY;
        }
        ArrayList<IRubyObject> localVarValues = new ArrayList<IRubyObject>();
        for (BiVariable var : this.variables) {
            if (var.getType() != BiVariable.Type.LocalVariable) continue;
            localVarValues.add(var.getRubyObject());
        }
        return localVarValues.toArray(new IRubyObject[localVarValues.size()]);
    }

    void inject(ManyVarsDynamicScope scope, int depth, IRubyObject receiver2) {
        VariableInterceptor.inject(this, this.provider.getRuntime(), scope, depth, receiver2);
    }

    void retrieve(IRubyObject receiver2) {
        RubyObject robj = this.getReceiverObject(receiver2);
        VariableInterceptor.retrieve(this.getLocalVariableBehavior(), this, robj);
    }

    void terminate() {
        VariableInterceptor.terminateGlobalVariables(this.getLocalVariableBehavior(), this.getVariables(), this.getRuntime());
        VariableInterceptor.terminateLocalVariables(this.getLocalVariableBehavior(), this.getNames(), this.getVariables());
    }

    @Override
    public Object remove(Object key2) {
        return this.removeFrom(this.getTopSelf(), key2);
    }

    public Object removeFrom(Object receiver2, Object key2) {
        if (this.variables == null) {
            return null;
        }
        BiVariableMap.checkKey(key2);
        RubyObject robj = this.getReceiverObject(receiver2);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            BiVariable var;
            if (!((String)key2).equals(this.varNames.get(i2)) || !(var = this.variables.get(i2)).isReceiverIdentical(robj)) continue;
            this.varNames.remove(i2);
            this.variables.remove(i2);
            return var.getJavaObject();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("map is empty");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            String key2 = entry.getKey();
            if (key2 instanceof String) {
                this.put(key2, entry.getValue());
                continue;
            }
            throw new ClassCastException("key is not String");
        }
    }

    @Override
    public void clear() {
        if (this.variables == null) {
            return;
        }
        BiVariable argv = null;
        for (BiVariable var : this.getVariables()) {
            if (var == null) continue;
            if ("ARGV".equals(var.getName())) {
                argv = var;
                continue;
            }
            var.remove();
        }
        this.getNames().clear();
        this.getVariables().clear();
        if (argv != null) {
            this.update("ARGV", argv);
        }
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.getNames());
    }

    @Override
    public Collection<Object> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getMap().entrySet();
    }

    public void update(String name2, BiVariable value2) {
        this.getNames().add(name2);
        this.getVariables().add(value2);
    }

    public void updateVariable(RubyObject receiver2, String name2, IRubyObject value2, Class<? extends BiVariable> type2) {
        BiVariable var = this.getVariable(receiver2, name2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            this.update(name2, BiVariableMap.newVariable(receiver2, name2, value2, type2));
        }
    }

    private static BiVariable newVariable(RubyObject receiver2, String name2, IRubyObject value2, Class<? extends BiVariable> type2) {
        try {
            Constructor<? extends BiVariable> constructor2 = type2.getDeclaredConstructor(RubyObject.class, String.class, IRubyObject.class);
            constructor2.setAccessible(true);
            return constructor2.newInstance(receiver2, name2, value2);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause2 = ex.getTargetException();
            if (cause2 instanceof RuntimeException) {
                throw (RuntimeException)cause2;
            }
            throw new RuntimeException(cause2);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getName());
        str.append('{');
        for (int i2 = 0; i2 < this.size(); ++i2) {
            String name2 = this.getNames().get(i2);
            BiVariable variable = this.getVariables().get(i2);
            str.append(name2).append('=').append(variable.getJavaObject());
            if (i2 == this.size() - 1) break;
            str.append(',').append(' ');
        }
        return str.append('}').toString();
    }
}

