/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriDomParser;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNonStrictErrorHandler4NekoHtml;
import nokogiri.internals.NokogiriStrictErrorHandler;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class HtmlDomParserContext
extends XmlDomParserContext {
    private String encoding;

    public HtmlDomParserContext(Ruby ruby, IRubyObject iRubyObject) {
        super(ruby, iRubyObject);
    }

    public HtmlDomParserContext(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        super(ruby, iRubyObject, iRubyObject2);
    }

    @Override
    protected void initErrorHandler() {
        this.errorHandler = this.options.strict ? new NokogiriStrictErrorHandler(this.options.noError, this.options.noWarning) : new NokogiriNonStrictErrorHandler4NekoHtml(this.options.noError, this.options.noWarning);
    }

    @Override
    protected void initParser(Ruby ruby) {
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        RemoveNSAttrsFilter removeNSAttrsFilter = new RemoveNSAttrsFilter();
        ElementValidityCheckFilter elementValidityCheckFilter = new ElementValidityCheckFilter(this.errorHandler);
        XMLDocumentFilter[] xMLDocumentFilterArray = new XMLDocumentFilter[]{elementValidityCheckFilter};
        hTMLConfiguration.setErrorHandler((XMLErrorHandler)this.errorHandler);
        this.parser = new NokogiriDomParser((XMLParserConfiguration)hTMLConfiguration);
        this.setProperty("http://cyberneko.org/html/properties/default-encoding", this.java_encoding);
        this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        this.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
        this.setProperty("http://cyberneko.org/html/properties/filters", xMLDocumentFilterArray);
        this.setFeature("http://cyberneko.org/html/features/report-errors", true);
        this.setFeature("http://xml.org/sax/features/namespaces", false);
    }

    @Override
    public void setEncoding(String string) {
        super.setEncoding(string);
    }

    public void enableDocumentFragment() {
        this.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
    }

    @Override
    protected XmlDocument getNewEmptyDocument(ThreadContext threadContext) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{};
        return (XmlDocument)XmlDocument.rbNew(threadContext, (IRubyObject)NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"), iRubyObjectArray);
    }

    @Override
    protected XmlDocument wrapDocument(ThreadContext threadContext, RubyClass rubyClass, Document document) {
        HtmlDocument htmlDocument = (HtmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), rubyClass);
        htmlDocument.setDocumentNode(threadContext, document);
        if (this.ruby_encoding.isNil()) {
            if (this.detected_encoding != null && !this.detected_encoding.isNil()) {
                this.ruby_encoding = this.detected_encoding;
            } else {
                String string = this.tryGetCharsetFromHtml5MetaTag(document);
                this.ruby_encoding = NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string);
            }
        }
        htmlDocument.setEncoding(this.ruby_encoding);
        htmlDocument.setParsedEncoding(this.java_encoding);
        return htmlDocument;
    }

    private String tryGetCharsetFromHtml5MetaTag(Document document) {
        if (!"html".equalsIgnoreCase(document.getDocumentElement().getNodeName())) {
            return null;
        }
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!"head".equalsIgnoreCase(nodeList.item(i).getNodeName())) continue;
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!"meta".equalsIgnoreCase(nodeList2.item(j).getNodeName())) continue;
                NamedNodeMap namedNodeMap = nodeList2.item(j).getAttributes();
                for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                    if (!"charset".equalsIgnoreCase(namedNodeMap.item(k).getNodeName())) continue;
                    return namedNodeMap.item(k).getNodeValue();
                }
            }
        }
        return null;
    }

    public static class ElementValidityCheckFilter
    extends DefaultFilter {
        private NokogiriErrorHandler errorHandler;
        private static String[][] element_names = new String[][]{{"a", "abbr", "acronym", "address", "area"}, {"b", "base", "basefont", "bdo", "big", "blockquote", "body", "br", "button"}, {"caption", "cite", "code", "col", "colgroup"}, {"dd", "del", "dfn", "div", "dl", "dt"}, {"em"}, {"fieldset", "font", "form", "frame", "frameset"}, new String[0], {"h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html"}, {"i", "iframe", "img", "input", "ins"}, new String[0], {"kbd"}, {"label", "legend", "li", "link"}, {"map", "meta"}, {"noframes", "noscript"}, {"object", "ol", "optgroup", "option"}, {"p", "param", "pre"}, {"q"}, new String[0], {"s", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "sup"}, {"table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt"}, {"u", "ul"}, {"var"}, new String[0], new String[0], new String[0], new String[0]};

        private ElementValidityCheckFilter(NokogiriErrorHandler nokogiriErrorHandler) {
            this.errorHandler = nokogiriErrorHandler;
        }

        private boolean isValid(String string) {
            char[] cArray = string.toCharArray();
            int n = new Integer(cArray[0]) - 97;
            if (n > 25) {
                return false;
            }
            for (int i = 0; i < element_names[n].length; ++i) {
                if (!string.equals(element_names[n][i])) continue;
                return true;
            }
            return false;
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            if (!this.isValid(qName.rawname)) {
                this.errorHandler.getErrors().add(new Exception("Tag " + qName.rawname + " invalid"));
            }
            super.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public static class RemoveNSAttrsFilter
    extends DefaultFilter {
        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            for (int i = 0; i < xMLAttributes.getLength(); ++i) {
                if (!NokogiriHelpers.isNamespace(xMLAttributes.getQName(i))) continue;
                xMLAttributes.removeAttributeAt(i);
                --i;
            }
            qName.uri = null;
            super.startElement(qName, xMLAttributes, augmentations);
        }
    }
}

