/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.IntSequence;
import gnu.lists.ShortVector;

public class S16Vector
extends ShortVector<Short> {
    public S16Vector() {
        this.data = empty;
    }

    public S16Vector(int size, short value) {
        short[] array = new short[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public S16Vector(int size) {
        this(new short[size]);
    }

    public S16Vector(short[] data) {
        this.data = data;
    }

    public S16Vector(short[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public S16Vector(short[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Short get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final Short getBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final void setBuffer(int index, Short value) {
        this.data[index] = value;
    }

    protected S16Vector withIndexes(IntSequence ind) {
        return new S16Vector(this.data, ind);
    }

    @Override
    public S16Vector subList(int fromIx, int toIx) {
        return new S16Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 20;
    }

    @Override
    public String getTag() {
        return "s16";
    }

    public int compareTo(Object obj) {
        return S16Vector.compareToInt(this, (S16Vector)obj);
    }
}

