/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.PrimIntegerVector;

public abstract class IntVector<E>
extends PrimIntegerVector<E> {
    int[] data;
    protected static int[] empty = new int[0];

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            int[] tmp = new int[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    public int[] getBuffer() {
        return this.data;
    }

    @Override
    protected void setBuffer(Object buffer) {
        this.data = (int[])buffer;
    }

    @Override
    public final int intAt(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    public final void setIntAt(int index, int value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.data[index] = value;
    }

    public final void setIntAtBuffer(int index, int value) {
        this.data[index] = value;
    }

    public void add(int v) {
        int sz = this.size();
        this.addSpace(sz, 1);
        this.setIntAt(sz, v);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        int[] d = this.data;
        while (--count >= 0) {
            d[start++] = 0;
        }
    }
}

