/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String explainOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        Main.error(osmApiInitializationException);
        return I18n.tr("<html>Failed to initialize communication with the OSM server {0}.<br>Check the server URL in your preferences and your internet connection.", OsmApi.getOsmApi().getServerUrl()) + "</html>";
    }

    public static String explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException missingOAuthAccessTokenException) {
        Main.error(missingOAuthAccessTokenException);
        return I18n.tr("<html>Failed to authenticate at the OSM server ''{0}''.<br>You are using OAuth to authenticate but currently there is no<br>OAuth Access Token configured.<br>Please open the Preferences Dialog and generate or enter an Access Token.</html>", OsmApi.getOsmApi().getServerUrl());
    }

    public static Pair<OsmPrimitive, Collection<OsmPrimitive>> parsePreconditionFailed(String string) {
        if (string == null) {
            return null;
        }
        TreeSet<OsmPrimitive> treeSet = new TreeSet<OsmPrimitive>();
        Matcher matcher = Pattern.compile(".*Node (\\d+) is still used by relations? (\\d+(?:,\\d+)*).*").matcher(string);
        if (matcher.matches()) {
            Node node = new Node(Long.parseLong(matcher.group(1)));
            for (String string2 : matcher.group(2).split(",")) {
                treeSet.add(new Relation(Long.parseLong(string2)));
            }
            return Pair.create(node, treeSet);
        }
        matcher = Pattern.compile(".*Node (\\d+) is still used by ways? (\\d+(?:,\\d+)*).*").matcher(string);
        if (matcher.matches()) {
            Node node = new Node(Long.parseLong(matcher.group(1)));
            for (String string3 : matcher.group(2).split(",")) {
                treeSet.add(new Way(Long.parseLong(string3)));
            }
            return Pair.create(node, treeSet);
        }
        matcher = Pattern.compile(".*The relation (\\d+) is used in relations? (\\d+(?:,\\d+)*).*").matcher(string);
        if (matcher.matches()) {
            Relation relation = new Relation(Long.parseLong(matcher.group(1)));
            for (String string4 : matcher.group(2).split(",")) {
                treeSet.add(new Relation(Long.parseLong(string4)));
            }
            return Pair.create(relation, treeSet);
        }
        matcher = Pattern.compile(".*Way (\\d+) is still used by relations? (\\d+(?:,\\d+)*).*").matcher(string);
        if (matcher.matches()) {
            Way way = new Way(Long.parseLong(matcher.group(1)));
            for (String string5 : matcher.group(2).split(",")) {
                treeSet.add(new Relation(Long.parseLong(string5)));
            }
            return Pair.create(way, treeSet);
        }
        matcher = Pattern.compile(".*Way (\\d+) requires the nodes with id in (\\d+(?:,\\d+)*).*").matcher(string);
        if (matcher.matches()) {
            Way way = new Way(Long.parseLong(matcher.group(1)));
            for (String string6 : matcher.group(2).split(",")) {
                treeSet.add(new Node(Long.parseLong(string6)));
            }
            return Pair.create(way, treeSet);
        }
        return null;
    }

    public static String explainPreconditionFailed(OsmApiException osmApiException) {
        Main.error(osmApiException);
        Pair<OsmPrimitive, Collection<OsmPrimitive>> pair = ExceptionUtil.parsePreconditionFailed(osmApiException.getErrorHeader());
        if (pair != null) {
            String string;
            OsmPrimitive osmPrimitive = (OsmPrimitive)((Collection)pair.b).iterator().next();
            String string2 = Long.toString(((OsmPrimitive)pair.a).getId());
            Collection<Long> collection = Utils.transform((Collection)pair.b, AbstractPrimitive::getId);
            String string3 = string = collection.size() == 1 ? collection.iterator().next().toString() : collection.toString();
            if (pair.a instanceof Node) {
                if (osmPrimitive instanceof Node) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by node {1}.<br>Please load the node, remove the reference to the node, and upload again.", "<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by nodes {1}.<br>Please load the nodes, remove the reference to the node, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Way) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by way {1}.<br>Please load the way, remove the reference to the node, and upload again.", "<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by ways {1}.<br>Please load the ways, remove the reference to the node, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the node, and upload again.", "<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the node, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                throw new IllegalStateException();
            }
            if (pair.a instanceof Way) {
                if (osmPrimitive instanceof Node) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by node {1}.<br>Please load the node, remove the reference to the way, and upload again.", "<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by nodes {1}.<br>Please load the nodes, remove the reference to the way, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Way) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by way {1}.<br>Please load the way, remove the reference to the way, and upload again.", "<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by ways {1}.<br>Please load the ways, remove the reference to the way, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the way, and upload again.", "<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the way, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                throw new IllegalStateException();
            }
            if (pair.a instanceof Relation) {
                if (osmPrimitive instanceof Node) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by node {1}.<br>Please load the node, remove the reference to the relation, and upload again.", "<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by nodes {1}.<br>Please load the nodes, remove the reference to the relation, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Way) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by way {1}.<br>Please load the way, remove the reference to the relation, and upload again.", "<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by ways {1}.<br>Please load the ways, remove the reference to the relation, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                if (osmPrimitive instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the relation, and upload again.", "<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the relation, and upload again.", ((Collection)pair.b).size(), string2, string) + "</html>";
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        return I18n.tr("<html>Uploading to the server <strong>failed</strong> because your current<br>dataset violates a precondition.<br>The error message is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(osmApiException.getMessage()));
    }

    public static String explainFailedBasicAuthentication(OsmApiException osmApiException) {
        Main.error(osmApiException);
        return I18n.tr("<html>Authentication at the OSM server with the username ''{0}'' failed.<br>Please check the username and the password in the JOSM preferences.</html>", CredentialsManager.getInstance().getUsername());
    }

    public static String explainFailedOAuthAuthentication(OsmApiException osmApiException) {
        Main.error(osmApiException);
        return I18n.tr("<html>Authentication at the OSM server with the OAuth token ''{0}'' failed.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey());
    }

    public static String explainFailedAuthorisation(OsmApiException osmApiException) {
        Main.error(osmApiException);
        String string = osmApiException.getErrorHeader();
        String string2 = osmApiException.getErrorBody();
        String string3 = string != null ? (string2 != null && !string.equals(string2) ? string + " (" + string2 + ')' : string) : string2;
        if (string3 != null && !string3.isEmpty()) {
            return I18n.tr("<html>Authorisation at the OSM server failed.<br>The server reported the following error:<br>''{0}''</html>", string3);
        }
        return I18n.tr("<html>Authorisation at the OSM server failed.<br></html>", new Object[0]);
    }

    public static String explainFailedOAuthAuthorisation(OsmApiException osmApiException) {
        Main.error(osmApiException);
        return I18n.tr("<html>Authorisation at the OSM server with the OAuth token ''{0}'' failed.<br>The token is not authorised to access the protected resource<br>''{1}''.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey(), osmApiException.getAccessedUrl() == null ? I18n.tr("unknown", new Object[0]) : osmApiException.getAccessedUrl());
    }

    public static String explainClientTimeout(OsmApiException osmApiException) {
        Main.error(osmApiException);
        return I18n.tr("<html>Communication with the OSM server ''{0}'' timed out. Please retry later.</html>", ExceptionUtil.getUrlFromException(osmApiException));
    }

    public static String explainGenericOsmApiException(OsmApiException osmApiException) {
        Main.error(osmApiException);
        String string = osmApiException.getErrorHeader();
        if (string == null) {
            string = osmApiException.getErrorBody();
        }
        if (string == null) {
            string = I18n.tr("no error message available", new Object[0]);
        }
        return I18n.tr("<html>Communication with the OSM server ''{0}''failed. The server replied<br>the following error code and the following error message:<br><strong>Error code:<strong> {1}<br><strong>Error message (untranslated)</strong>: {2}</html>", ExceptionUtil.getUrlFromException(osmApiException), osmApiException.getResponseCode(), string);
    }

    public static String explainConflict(OsmApiException osmApiException) {
        Main.error(osmApiException);
        String string = osmApiException.getErrorHeader();
        if (string != null) {
            Matcher matcher = Pattern.compile("The changeset (\\d+) was closed at (.*)").matcher(string);
            if (matcher.matches()) {
                long l = Long.parseLong(matcher.group(1));
                Date date = null;
                try {
                    date = DateUtils.newOsmApiDateTimeFormat().parse(matcher.group(2));
                }
                catch (ParseException parseException) {
                    Main.error(I18n.tr("Failed to parse date ''{0}'' replied by server.", matcher.group(2)));
                    Main.error(parseException);
                }
                string = date == null ? I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed <br>because it has already been closed.", l) : I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed<br> because it has already been closed on {1}.", l, DateUtils.formatDateTime(date, 2, 2));
                return string;
            }
            string = I18n.tr("<html>The server reported that it has detected a conflict.<br>Error message (untranslated):<br>{0}</html>", string);
        } else {
            string = I18n.tr("<html>The server reported that it has detected a conflict.", new Object[0]);
        }
        return string.endsWith("</html>") ? string : string + "</html>";
    }

    public static String explainChangesetClosedException(ChangesetClosedException changesetClosedException) {
        Main.error(changesetClosedException);
        return I18n.tr("<html>Failed to upload to changeset <strong>{0}</strong><br>because it has already been closed on {1}.", changesetClosedException.getChangesetId(), changesetClosedException.getClosedOn() == null ? "?" : DateUtils.formatDateTime(changesetClosedException.getClosedOn(), 2, 2));
    }

    public static String explainGeneric(Exception exception) {
        String string = exception.getMessage();
        if (string == null || string.trim().isEmpty()) {
            string = exception.toString();
        }
        Main.error(exception);
        return Utils.escapeReservedCharactersHTML(string);
    }

    public static String explainSecurityException(OsmTransferException osmTransferException) {
        String string = osmTransferException.getUrl();
        String string2 = I18n.tr("unknown", new Object[0]);
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            Main.trace(malformedURLException);
        }
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''<br>for security reasons. This is most likely because you are running<br>in an applet and because you did not load your applet from ''{1}''.", string, string2) + "</html>";
    }

    public static String explainNestedSocketException(OsmTransferException osmTransferException) {
        Main.error(osmTransferException);
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Please check your internet connection.", osmTransferException.getUrl()) + "</html>";
    }

    public static String explainNestedIOException(OsmTransferException osmTransferException) {
        IOException iOException = ExceptionUtil.getNestedException(osmTransferException, IOException.class);
        Main.error(osmTransferException);
        return I18n.tr("<html>Failed to upload data to or download data from<br>''{0}''<br>due to a problem with transferring data.<br>Details (untranslated): {1}</html>", osmTransferException != null ? osmTransferException.getUrl() : "null", iOException != null ? iOException.getMessage() : "null");
    }

    public static String explainNestedIllegalDataException(OsmTransferException osmTransferException) {
        IllegalDataException illegalDataException = ExceptionUtil.getNestedException(osmTransferException, IllegalDataException.class);
        Main.error(osmTransferException);
        return I18n.tr("<html>Failed to download data. Its format is either unsupported, ill-formed, and/or inconsistent.<br><br>Details (untranslated): {0}</html>", illegalDataException != null ? illegalDataException.getMessage() : "null");
    }

    public static String explainOfflineAccessException(OsmTransferException osmTransferException) {
        OfflineAccessException offlineAccessException = ExceptionUtil.getNestedException(osmTransferException, OfflineAccessException.class);
        Main.error(osmTransferException);
        return I18n.tr("<html>Failed to download data.<br><br>Details: {0}</html>", offlineAccessException != null ? offlineAccessException.getMessage() : "null");
    }

    public static String explainInternalServerError(OsmTransferException osmTransferException) {
        Main.error(osmTransferException);
        return I18n.tr("<html>The OSM server<br>''{0}''<br>reported an internal server error.<br>This is most likely a temporary problem. Please try again later.", osmTransferException.getUrl()) + "</html>";
    }

    public static String explainBadRequest(OsmApiException osmApiException) {
        String string = I18n.tr("The OSM server ''{0}'' reported a bad request.<br>", ExceptionUtil.getUrlFromException(osmApiException));
        String string2 = osmApiException.getErrorHeader();
        if (string2 != null && (string2.startsWith("The maximum bbox") || string2.startsWith("You requested too many nodes"))) {
            string = string + "<br>" + I18n.tr("The area you tried to download is too big or your request was too large.<br>Either request a smaller area or use an export file provided by the OSM community.", new Object[0]);
        } else if (string2 != null) {
            string = string + I18n.tr("<br>Error message(untranslated): {0}", string2);
        }
        Main.error(osmApiException);
        return "<html>" + string + "</html>";
    }

    public static String explainBandwidthLimitExceeded(OsmApiException osmApiException) {
        Main.error(osmApiException);
        return ExceptionUtil.explainGenericOsmApiException(osmApiException);
    }

    public static String explainNotFound(OsmApiException osmApiException) {
        String string = I18n.tr("The OSM server ''{0}'' does not know about an object<br>you tried to read, update, or delete. Either the respective object<br>does not exist on the server or you are using an invalid URL to access<br>it. Please carefully check the server''s address ''{0}'' for typos.", ExceptionUtil.getUrlFromException(osmApiException));
        Main.error(osmApiException);
        return "<html>" + string + "</html>";
    }

    public static String explainNestedUnknownHostException(OsmTransferException osmTransferException) {
        String string = osmTransferException.getUrl();
        String string2 = I18n.tr("unknown", new Object[0]);
        try {
            string2 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            Main.trace(osmTransferException);
        }
        Main.error(osmTransferException);
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Host name ''{1}'' could not be resolved. <br>Please check the API URL in your preferences and your internet connection.", string, string2) + "</html>";
    }

    public static <T> T getNestedException(Exception exception, Class<T> clazz) {
        Throwable throwable;
        for (throwable = exception; throwable != null && !clazz.isInstance(throwable); throwable = throwable.getCause()) {
        }
        if (throwable == null) {
            return null;
        }
        if (clazz.isInstance(throwable)) {
            return clazz.cast(throwable);
        }
        return null;
    }

    public static String explainOsmTransferException(OsmTransferException osmTransferException) {
        if (ExceptionUtil.getNestedException(osmTransferException, SecurityException.class) != null) {
            return ExceptionUtil.explainSecurityException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, SocketException.class) != null) {
            return ExceptionUtil.explainNestedSocketException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, UnknownHostException.class) != null) {
            return ExceptionUtil.explainNestedUnknownHostException(osmTransferException);
        }
        if (ExceptionUtil.getNestedException(osmTransferException, IOException.class) != null) {
            return ExceptionUtil.explainNestedIOException(osmTransferException);
        }
        if (osmTransferException instanceof OsmApiInitializationException) {
            return ExceptionUtil.explainOsmApiInitializationException((OsmApiInitializationException)osmTransferException);
        }
        if (osmTransferException instanceof ChangesetClosedException) {
            return ExceptionUtil.explainChangesetClosedException((ChangesetClosedException)osmTransferException);
        }
        if (osmTransferException instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)osmTransferException;
            if (osmApiException.getResponseCode() == 412) {
                return ExceptionUtil.explainPreconditionFailed(osmApiException);
            }
            if (osmApiException.getResponseCode() == 410) {
                return ExceptionUtil.explainGoneForUnknownPrimitive(osmApiException);
            }
            if (osmApiException.getResponseCode() == 500) {
                return ExceptionUtil.explainInternalServerError(osmApiException);
            }
            if (osmApiException.getResponseCode() == 400) {
                return ExceptionUtil.explainBadRequest(osmApiException);
            }
            if (osmApiException.getResponseCode() == 509) {
                return ExceptionUtil.explainBandwidthLimitExceeded(osmApiException);
            }
        }
        return ExceptionUtil.explainGeneric(osmTransferException);
    }

    public static String explainGoneForUnknownPrimitive(OsmApiException osmApiException) {
        return I18n.tr("<html>The server reports that an object is deleted.<br><strong>Uploading failed</strong> if you tried to update or delete this object.<br> <strong>Downloading failed</strong> if you tried to download this object.<br><br>The error message is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(osmApiException.getMessage()));
    }

    public static String explainException(Exception exception) {
        Main.error(exception);
        if (exception instanceof OsmTransferException) {
            return ExceptionUtil.explainOsmTransferException((OsmTransferException)exception);
        }
        return ExceptionUtil.explainGeneric(exception);
    }

    static String getUrlFromException(OsmApiException osmApiException) {
        if (osmApiException.getAccessedUrl() != null) {
            try {
                return new URL(osmApiException.getAccessedUrl()).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                Main.warn(malformedURLException);
            }
        }
        if (osmApiException.getUrl() != null) {
            return osmApiException.getUrl();
        }
        return OsmApi.getOsmApi().getBaseUrl();
    }
}

