/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.util.List;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.I18n;

public enum PaintColors {
    INACTIVE(I18n.marktr("inactive"), Color.darkGray),
    SELECTED(I18n.marktr("selected"), Color.red),
    RELATIONSELECTED(I18n.marktr("Relation: selected"), Color.magenta),
    NODE(I18n.marktr("Node: standard"), Color.yellow),
    CONNECTION(I18n.marktr("Node: connection"), Color.yellow),
    TAGGED(I18n.marktr("Node: tagged"), new Color(204, 255, 255)),
    DEFAULT_WAY(I18n.marktr("way"), new Color(0, 0, 128)),
    RELATION(I18n.marktr("relation"), new Color(0, 128, 128)),
    UNTAGGED_WAY(I18n.marktr("untagged way"), new Color(0, 128, 0)),
    BACKGROUND(I18n.marktr("background"), Color.BLACK),
    HIGHLIGHT(I18n.marktr("highlight"), SELECTED.get()),
    HIGHLIGHT_WIREFRAME(I18n.marktr("highlight wireframe"), Color.orange),
    UNTAGGED(I18n.marktr("untagged"), Color.GRAY),
    TEXT(I18n.marktr("text"), Color.WHITE),
    AREA_TEXT(I18n.marktr("areatext"), Color.LIGHT_GRAY);

    private final String name;
    private final Color defaultColor;
    private final ColorProperty baseProperty;
    private final CachingProperty<Color> property;
    private static volatile Color backgroundColorCache;
    private static final MapPaintStyles.MapPaintSylesUpdateListener styleOverrideListener;

    private PaintColors(String string2, Color color) {
        this.baseProperty = new ColorProperty(string2, color);
        this.property = this.baseProperty.cached();
        this.name = string2;
        this.defaultColor = color;
    }

    public Color getDefaultValue() {
        return (Color)this.property.getDefaultValue();
    }

    public Color get() {
        return this.property.get();
    }

    public static Color getBackgroundColor() {
        if (backgroundColorCache != null) {
            return backgroundColorCache;
        }
        List<StyleSource> list = MapPaintStyles.getStyles().getStyleSources();
        for (StyleSource styleSource : list) {
            Color color;
            if (!styleSource.active || (color = styleSource.getBackgroundColorOverride()) == null) continue;
            backgroundColorCache = color;
        }
        if (backgroundColorCache == null) {
            return BACKGROUND.get();
        }
        return backgroundColorCache;
    }

    public ColorProperty getProperty() {
        return this.baseProperty;
    }

    static {
        styleOverrideListener = new MapPaintStyles.MapPaintSylesUpdateListener(){

            @Override
            public void mapPaintStylesUpdated() {
                backgroundColorCache = null;
            }

            @Override
            public void mapPaintStyleEntryUpdated(int n) {
                this.mapPaintStylesUpdated();
            }
        };
        MapPaintStyles.addMapPaintSylesUpdateListener(styleOverrideListener);
    }
}

