/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.tools.Utils;

public final class GetCapabilitiesParseHelper {
    public static final String OWS_NS_URL = "http://www.opengis.net/ows/1.1";
    public static final String XLINK_NS_URL = "http://www.w3.org/1999/xlink";
    static final QName QN_OWS_ALLOWED_VALUES = new QName("http://www.opengis.net/ows/1.1", "AllowedValues");
    static final QName QN_OWS_CONSTRAINT = new QName("http://www.opengis.net/ows/1.1", "Constraint");
    static final QName QN_OWS_DCP = new QName("http://www.opengis.net/ows/1.1", "DCP");
    static final QName QN_OWS_GET = new QName("http://www.opengis.net/ows/1.1", "Get");
    static final QName QN_OWS_HTTP = new QName("http://www.opengis.net/ows/1.1", "HTTP");
    static final QName QN_OWS_IDENTIFIER = new QName("http://www.opengis.net/ows/1.1", "Identifier");
    static final QName QN_OWS_OPERATION = new QName("http://www.opengis.net/ows/1.1", "Operation");
    static final QName QN_OWS_OPERATIONS_METADATA = new QName("http://www.opengis.net/ows/1.1", "OperationsMetadata");
    static final QName QN_OWS_SUPPORTED_CRS = new QName("http://www.opengis.net/ows/1.1", "SupportedCRS");
    static final QName QN_OWS_VALUE = new QName("http://www.opengis.net/ows/1.1", "Value");

    private GetCapabilitiesParseHelper() {
    }

    public static XMLStreamReader getReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newFactory();
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xMLInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xMLInputFactory.createXMLStreamReader(inputStream);
    }

    public static void moveReaderToEndCurrentTag(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = 0;
        QName qName = xMLStreamReader.getName();
        int n2 = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext()) {
            if (1 == n2) {
                ++n;
            } else if (2 == n2 && --n == 0 && qName.equals(xMLStreamReader.getName())) {
                return;
            }
            if (n < 0) {
                throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
            }
            n2 = xMLStreamReader.next();
        }
        throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
    }

    public static boolean moveReaderToTag(XMLStreamReader xMLStreamReader, QName ... qNameArray) throws XMLStreamException {
        QName qName = xMLStreamReader.getName();
        int n = 0;
        QName qName2 = qNameArray[n];
        QName qName3 = null;
        QName qName4 = null;
        int n2 = 0;
        while (xMLStreamReader.hasNext() && (n2 != 2 || !qName.equals(xMLStreamReader.getName()))) {
            if (n2 == 2 && qName4 != null && qName4.equals(xMLStreamReader.getName())) {
                qName4 = null;
            }
            if (qName4 == null) {
                if (n2 == 1) {
                    if (qName2.equals(xMLStreamReader.getName())) {
                        if (++n >= qNameArray.length) {
                            return true;
                        }
                        qName3 = qName2;
                        qName2 = qNameArray[n];
                    } else {
                        qName4 = xMLStreamReader.getName();
                    }
                }
                if (n2 == 2 && qName3 != null && qName3.equals(xMLStreamReader.getName())) {
                    qName2 = qName3;
                    qName3 = --n >= 0 ? qNameArray[n] : null;
                }
            }
            n2 = xMLStreamReader.next();
        }
        return false;
    }

    public static TransferMode getTransferMode(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        QName qName = QN_OWS_GET;
        Utils.ensure(qName.equals(xMLStreamReader.getName()), "WMTS Parser state invalid. Expected element %s, got %s", qName, xMLStreamReader.getName());
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !qName.equals(xMLStreamReader.getName()))) {
            if (n == 1 && QN_OWS_CONSTRAINT.equals(xMLStreamReader.getName()) && "GetEncoding".equals(xMLStreamReader.getAttributeValue("", "name"))) {
                GetCapabilitiesParseHelper.moveReaderToTag(xMLStreamReader, QN_OWS_ALLOWED_VALUES, QN_OWS_VALUE);
                return TransferMode.fromString(xMLStreamReader.getElementText());
            }
            n = xMLStreamReader.next();
        }
        return null;
    }

    public static String normalizeCapabilitiesUrl(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
        return uRL2.toExternalForm();
    }

    public static String crsToCode(String string) {
        if (string.startsWith("urn:ogc:def:crs:")) {
            return string.replaceFirst("urn:ogc:def:crs:([^:]*):.*:(.*)$", "$1:$2");
        }
        return string;
    }

    static enum TransferMode {
        KVP("KVP"),
        REST("RESTful");

        private final String typeString;

        private TransferMode(String string2) {
            this.typeString = string2;
        }

        private String getTypeString() {
            return this.typeString;
        }

        static TransferMode fromString(String string) {
            for (TransferMode transferMode : TransferMode.values()) {
                if (!transferMode.getTypeString().equals(string)) continue;
                return transferMode;
            }
            return null;
        }
    }
}

