/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchInstructionByOffsetVisitor {
    public static Instruction visit(Instruction instruction, int offset) {
        if (instruction.offset == offset) {
            return instruction;
        }
        switch (instruction.opcode) {
            case 190: {
                return SearchInstructionByOffsetVisitor.visit(((ArrayLength)instruction).arrayref, offset);
            }
            case 83: 
            case 272: {
                return SearchInstructionByOffsetVisitor.visit(((ArrayStoreInstruction)instruction).arrayref, offset);
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                instruction = SearchInstructionByOffsetVisitor.visit(ai.test, offset);
                if (instruction != null) {
                    return instruction;
                }
                if (ai.msg == null) {
                    return null;
                }
                return SearchInstructionByOffsetVisitor.visit(ai.msg, offset);
            }
            case 191: {
                return SearchInstructionByOffsetVisitor.visit(((AThrow)instruction).value, offset);
            }
            case 266: {
                return SearchInstructionByOffsetVisitor.visit(((UnaryOperatorInstruction)instruction).value, offset);
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                instruction = SearchInstructionByOffsetVisitor.visit(boi.value1, offset);
                if (instruction != null) {
                    return instruction;
                }
                return SearchInstructionByOffsetVisitor.visit(boi.value2, offset);
            }
            case 192: {
                return SearchInstructionByOffsetVisitor.visit(((CheckCast)instruction).objectref, offset);
            }
            case 54: 
            case 58: 
            case 269: {
                return SearchInstructionByOffsetVisitor.visit(((StoreInstruction)instruction).valueref, offset);
            }
            case 264: {
                return SearchInstructionByOffsetVisitor.visit(((DupStore)instruction).objectref, offset);
            }
            case 275: 
            case 276: {
                return SearchInstructionByOffsetVisitor.visit(((ConvertInstruction)instruction).value, offset);
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                instruction = SearchInstructionByOffsetVisitor.visit(ifCmp.value1, offset);
                if (instruction != null) {
                    return instruction;
                }
                return SearchInstructionByOffsetVisitor.visit(ifCmp.value2, offset);
            }
            case 260: 
            case 262: {
                return SearchInstructionByOffsetVisitor.visit(((IfInstruction)instruction).value, offset);
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    instruction = SearchInstructionByOffsetVisitor.visit(branchList.get(i), offset);
                    if (instruction != null) {
                        return instruction;
                    }
                    --i;
                }
                break;
            }
            case 193: {
                return SearchInstructionByOffsetVisitor.visit(((InstanceOf)instruction).objectref, offset);
            }
            case 182: 
            case 183: 
            case 185: {
                Instruction result = SearchInstructionByOffsetVisitor.visit(((InvokeNoStaticInstruction)instruction).objectref, offset);
                if (result != null) {
                    return result;
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    instruction = SearchInstructionByOffsetVisitor.visit(list.get(i), offset);
                    if (instruction != null) {
                        return instruction;
                    }
                    --i;
                }
                break;
            }
            case 171: {
                return SearchInstructionByOffsetVisitor.visit(((LookupSwitch)instruction).key, offset);
            }
            case 194: {
                return SearchInstructionByOffsetVisitor.visit(((MonitorEnter)instruction).objectref, offset);
            }
            case 195: {
                return SearchInstructionByOffsetVisitor.visit(((MonitorExit)instruction).objectref, offset);
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    instruction = SearchInstructionByOffsetVisitor.visit(dimensions[i], offset);
                    if (instruction != null) {
                        return instruction;
                    }
                    --i;
                }
                break;
            }
            case 188: {
                return SearchInstructionByOffsetVisitor.visit(((NewArray)instruction).dimension, offset);
            }
            case 189: {
                return SearchInstructionByOffsetVisitor.visit(((ANewArray)instruction).dimension, offset);
            }
            case 87: {
                return SearchInstructionByOffsetVisitor.visit(((Pop)instruction).objectref, offset);
            }
            case 181: {
                PutField putField = (PutField)instruction;
                instruction = SearchInstructionByOffsetVisitor.visit(putField.objectref, offset);
                if (instruction != null) {
                    return instruction;
                }
                return SearchInstructionByOffsetVisitor.visit(putField.valueref, offset);
            }
            case 179: {
                return SearchInstructionByOffsetVisitor.visit(((PutStatic)instruction).valueref, offset);
            }
            case 273: {
                return SearchInstructionByOffsetVisitor.visit(((ReturnInstruction)instruction).valueref, offset);
            }
            case 170: {
                return SearchInstructionByOffsetVisitor.visit(((TableSwitch)instruction).key, offset);
            }
            case 280: {
                return SearchInstructionByOffsetVisitor.visit(((TernaryOpStore)instruction).objectref, offset);
            }
            case 277: 
            case 278: {
                return SearchInstructionByOffsetVisitor.visit(((IncInstruction)instruction).value, offset);
            }
            case 180: {
                return SearchInstructionByOffsetVisitor.visit(((GetField)instruction).objectref, offset);
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                instruction = SearchInstructionByOffsetVisitor.visit(iai.newArray, offset);
                if (instruction != null) {
                    return instruction;
                }
                if (iai.values == null) break;
                return SearchInstructionByOffsetVisitor.visit(iai.values, offset);
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search instruction in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
        return null;
    }

    private static Instruction visit(List<Instruction> instructions, int offset) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            Instruction instruction = SearchInstructionByOffsetVisitor.visit(instructions.get(i), offset);
            if (instruction != null) {
                return instruction;
            }
            --i;
        }
        return null;
    }
}

