/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @NotNull
    public static CompilerMessageLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
            if (compilerMessageLocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/MessageUtil", "psiElementToMessageLocation"));
            }
            return compilerMessageLocation;
        }
        PsiFile file = element.getContainingFile();
        CompilerMessageLocation compilerMessageLocation = MessageUtil.psiFileToMessageLocation(file, "<no path>", DiagnosticUtils.getLineAndColumnInPsiFile(file, element.getTextRange()));
        if (compilerMessageLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/MessageUtil", "psiElementToMessageLocation"));
        }
        return compilerMessageLocation;
    }

    @NotNull
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file, @Nullable String defaultValue, @NotNull DiagnosticUtils.LineAndColumn lineAndColumn) {
        String path;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cli/common/messages/MessageUtil", "psiFileToMessageLocation"));
        }
        if (lineAndColumn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineAndColumn", "org/jetbrains/kotlin/cli/common/messages/MessageUtil", "psiFileToMessageLocation"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            path = defaultValue;
        } else {
            path = virtualFile.getPath();
            if (virtualFile instanceof CoreLocalVirtualFile || virtualFile instanceof CoreJarVirtualFile) {
                path = FileUtil.toSystemDependentName(path);
            }
        }
        CompilerMessageLocation compilerMessageLocation = CompilerMessageLocation.create(path, lineAndColumn.getLine(), lineAndColumn.getColumn(), lineAndColumn.getLineContent());
        if (compilerMessageLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/MessageUtil", "psiFileToMessageLocation"));
        }
        return compilerMessageLocation;
    }
}

