/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.util.LinesUtil;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class SamplingInstrumenter
extends Instrumenter {
    private static final String OBJECT_TYPE = "Ljava/lang/Object;";

    public SamplingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, final String name, final String desc, int access, String signature, String[] exceptions) {
        int variablesCount = (8 & access) != 0 ? 0 : 1;
        Type[] args = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < args.length; ++i) {
            variablesCount += args[i].getSize();
        }
        final int varCount = variablesCount;
        return new MethodVisitor(393216, mv){
            private Label myStartLabel;
            private Label myEndLabel;

            public void visitLabel(Label label) {
                if (this.myStartLabel == null) {
                    this.myStartLabel = label;
                }
                this.myEndLabel = label;
                super.visitLabel(label);
            }

            public void visitLineNumber(int line, Label start) {
                SamplingInstrumenter.this.getOrCreateLineData(line, name, desc);
                this.mv.visitVarInsn(25, this.getCurrentClassDataNumber());
                if (line <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, line);
                } else {
                    this.mv.visitLdcInsn((Object)new Integer(line));
                }
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchLine", "(Ljava/lang/Object;I)V");
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitLdcInsn((Object)SamplingInstrumenter.this.getClassName());
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;");
                this.mv.visitVarInsn(58, this.getCurrentClassDataNumber());
                super.visitCode();
            }

            public void visitLocalVariable(String name2, String desc2, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name2, desc2, signature, start, end, this.adjustVariable(index));
            }

            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(this.adjustVariable(var), increment);
            }

            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, this.adjustVariable(var));
            }

            private int adjustVariable(int var) {
                return var >= varCount ? var + 1 : var;
            }

            private int getCurrentClassDataNumber() {
                return varCount;
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.myStartLabel != null && this.myEndLabel != null) {
                    this.mv.visitLocalVariable("__class__data__", SamplingInstrumenter.OBJECT_TYPE, null, this.myStartLabel, this.myEndLabel, this.getCurrentClassDataNumber());
                }
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }

    protected void initLineData() {
        LineData[] lines = LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines);
        this.myClassData.initLineMask(lines);
        this.myClassData.setLines(lines);
    }
}

