/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;

public class ViewConstructorDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ViewConstructor", "Missing View constructors for XML inflation", "Some layout tools (such as the Android layout editor) need to find a constructor with one of the following signatures:\n* `View(Context context)`\n* `View(Context context, AttributeSet attrs)`\n* `View(Context context, AttributeSet attrs, int defStyle)`\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if `View#isInEditMode()` is false, since that method will return `false` at runtime but true within a user interface editor.", Category.USABILITY, 3, Severity.WARNING, new Implementation(ViewConstructorDetector.class, Scope.JAVA_FILE_SCOPE));

    private static boolean isXmlConstructor(@NonNull JavaEvaluator evaluator, @NonNull PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        int argumentCount = parameterList.getParametersCount();
        if (argumentCount == 0 || argumentCount > 3) {
            return false;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (!evaluator.typeMatches(parameters2[0].getType(), "android.content.Context")) {
            return false;
        }
        if (argumentCount == 1) {
            return true;
        }
        if (!evaluator.typeMatches(parameters2[1].getType(), "android.util.AttributeSet")) {
            return false;
        }
        if (argumentCount == 2) {
            return true;
        }
        return PsiType.INT.equals((Object)parameters2[2].getType());
    }

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass declaration2) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract(declaration2) || declaration2 instanceof PsiAnonymousClass) {
            return;
        }
        if (declaration2.getContainingClass() != null && !evaluator.isStatic(declaration2)) {
            return;
        }
        boolean found = false;
        for (PsiMethod constructor : declaration2.getConstructors()) {
            if (!ViewConstructorDetector.isXmlConstructor(evaluator, constructor)) continue;
            found = true;
            break;
        }
        if (!found) {
            String message2 = String.format("Custom view `%1$s` is missing constructor used by tools: `(Context)` or `(Context,AttributeSet)` or `(Context,AttributeSet,int)`", declaration2.getName());
            Location location = context.getUastNameLocation(declaration2);
            context.reportUast(ISSUE, declaration2, location, message2);
        }
    }
}

